/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common.macros;

import java.util.LinkedList;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.ICfw;
import oracle.sysman.emCfg.common.IMicroStepState;

public class Session {
    public static void setActiveAllAggregateReferences(ICfw session, boolean active) throws CfwException {
        IAggregateReference[] loadedAggRefs = session.getAggregateReferences("common");
        for (int i = 0; i < loadedAggRefs.length; ++i) {
            IAggregate currLoadedAgg = session.getAggregate(loadedAggRefs[i]);
            IAggregateReference[] referredRefs = currLoadedAgg.getAllReferredAggregateReferences();
            for (int j = 0; j < referredRefs.length; ++j) {
                currLoadedAgg.setActive(active, referredRefs[j]);
            }
        }
    }

    public static IAggregate[] getAllAggregates(ICfw session) throws CfwException {
        LinkedList<IAggregate> result = new LinkedList<IAggregate>();
        IAggregateReference[] loadedAggRefs = session.getAggregateReferences("common");
        for (int i = 0; i < loadedAggRefs.length; ++i) {
            result.add(session.getAggregate(loadedAggRefs[i]));
        }
        return result.toArray(new IAggregate[0]);
    }

    public static IAction[] getActions(IAggregate aggregate) throws CfwException {
        LinkedList<IAction> result = new LinkedList<IAction>();
        IActionReference[] actionRefs = aggregate.getActionReferences();
        for (int i = 0; i < actionRefs.length; ++i) {
            result.add(aggregate.getAction(actionRefs[i]));
        }
        return result.toArray(new IAction[0]);
    }

    public static IMicroStepState[] verifyDetachedToolsHaveNonSilentInvocation(ICfw session) throws CfwException {
        LinkedList<IMicroStepState> result = new LinkedList<IMicroStepState>();
        IAggregate[] allAggs = Session.getAllAggregates(session);
        for (int i = 0; i < allAggs.length; ++i) {
            IAggregate currAgg = allAggs[i];
            IAction[] actions = Session.getActions(currAgg);
            for (int j = 0; j < actions.length; ++j) {
                IActionStepState[] actionStepStates = actions[j].getActionState().getActionStepStates();
                for (int k = 0; k < actionStepStates.length; ++k) {
                    IMicroStepState[] microStepStates = actionStepStates[k].getMicroStepStates();
                    for (int l = 0; l < microStepStates.length; ++l) {
                        IMicroStepState mss = microStepStates[l];
                        if (!mss.getFlavor().isPlugInInvocation() || mss.getPlugInInvocationState().hasNonSilentInvocation() || currAgg.getPlugIn(mss.getPlugInID()).isInvocationAttached()) continue;
                        result.add(mss);
                    }
                }
            }
        }
        return result.toArray(new IMicroStepState[0]);
    }
}

