/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common.macros;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.support.Formatter;

public class Parameter {
    public static IParameter getParameter(IAggregate aggregate, String parameterID) throws CfwException {
        IParameterReference ref = aggregate.getParameterReference(parameterID);
        return aggregate.getParameter(ref);
    }

    public static String toXmlRawData(String dataType, String dataValue) {
        return Parameter.datiStartString() + "<" + "Dimensions" + "></" + "Dimensions" + ">" + Parameter.datumString(dataType, dataValue) + Parameter.datiEndString();
    }

    public static String toXmlRawDataArray(String dataType, String[] val) throws CfwException {
        int length = val != null ? val.length : -1;
        StringBuffer sb = new StringBuffer().append(Parameter.datiStartString()).append("<Dimensions>" + length + "</" + "Dimensions" + ">");
        for (int i = 0; i < length; ++i) {
            sb.append(Parameter.datumString(dataType, val[i]));
        }
        sb.append(Parameter.datiEndString());
        return sb.toString();
    }

    public static String toXmlRawDataComplex(String dataType, String[] val) throws CfwException {
        StringBuffer sb = new StringBuffer().append(Parameter.datiStartString()).append("<Dimensions></Dimensions>");
        for (int i = 0; i < val.length; ++i) {
            sb.append(Parameter.datumString(dataType, val[i]));
        }
        sb.append(Parameter.datiEndString());
        return sb.toString();
    }

    public static void setComplexAsStringArray(IParameter parameter, String[] value) throws CfwException {
        parameter.setValue(Parameter.toXmlRawDataComplex("xsd:string", value));
    }

    private static String datiStartString() {
        return "<ParameterDati>";
    }

    private static String datiEndString() {
        return "</ParameterDati>";
    }

    private static String datumString(String dataType, String dataValue) {
        String isNull = "";
        if (dataValue == null) {
            dataValue = "";
            isNull = "\" null=\"true";
        }
        return "<ParameterDatum type=\"" + dataType + isNull + "\">" + Formatter.escapeXMLSequences(dataValue) + "</" + "ParameterDatum" + ">";
    }
}

