/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import java.io.PrintStream;
import java.text.MessageFormat;
import oracle.sysman.emCfg.client.CfwProgressMonitor;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.EmCfgActionPerform;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStateReference;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.MicroStepStatus;

class MyProgress
extends CfwProgressMonitor {
    private final EmCfgActionPerform performer;
    private final IAggregate cfwAggregate;
    private final PrintStream out;

    public MyProgress(CfwSession session, IAggregateReference aggrRef, EmCfgActionPerform performer, PrintStream out, PrintStream err) throws CfwException {
        super(session);
        this.cfwAggregate = session.getAggregate(aggrRef);
        this.cfwAggregate.addProgressListener(this);
        this.performer = performer;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void plugInStart(IMicroStepStateReference microStepStateReference) throws CfwException {
        IMicroStepState state = this.getSession().getMicroStepState(microStepStateReference);
        MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
        PrintStream printStream = this.out;
        synchronized (printStream) {
            this.out.println("------------------------------------------------------");
            Object[] args = new String[]{state.getPlugInID()};
            this.out.println(MessageFormat.format(microStatus.getLocalizedBriefString(), args));
            this.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void plugInEnd(IMicroStepStateReference microStepStateReference) throws CfwException {
        IMicroStepState state = this.getSession().getMicroStepState(microStepStateReference);
        MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
        IActionStepState asState = state.getActionStepState();
        PrintStream printStream = this.out;
        synchronized (printStream) {
            this.out.println();
            Object[] args = new String[]{state.getPlugInID()};
            this.out.println(MessageFormat.format(microStatus.getLocalizedBriefString(), args));
            this.out.println("------------------------------------------------------");
        }
        if (!microStatus.equals(MicroStepStatus.PERFORMED_SUCCESS)) {
            if (asState.isRequired()) {
                this.performer.updateExitCode(3);
            } else {
                this.performer.updateExitCode(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionStart(IActionStateReference actionReference, IActionStepStateReference[] items) throws CfwException {
        IActionState aState = this.getSession().getActionState(actionReference);
        ActionStatus actStatus = (ActionStatus)aState.getStatus();
        PrintStream printStream = this.out;
        synchronized (printStream) {
            this.out.println("###################################################");
            Object[] args = new String[]{aState.getSelfID()};
            this.out.println(MessageFormat.format(actStatus.getLocalizedBriefString(), args));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEnd(IActionStateReference actionReference) throws CfwException {
        IActionState aState = this.getSession().getActionState(actionReference);
        ActionStatus actStatus = (ActionStatus)aState.getStatus();
        PrintStream printStream = this.out;
        synchronized (printStream) {
            Object[] args = new String[]{aState.getSelfID()};
            this.out.println(MessageFormat.format(actStatus.getLocalizedBriefString(), args));
            this.out.println("###################################################");
        }
        this.getSession().save();
    }
}

