/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Shell;

public class Environment {
    private static final CfmLogger logger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private static final String envCmd;
    private static final boolean caseSensitive;
    private final Properties env;

    private static String handleCase(String str) {
        if (!caseSensitive) {
            return str.toUpperCase();
        }
        return str;
    }

    public static Environment getSystemEnv() throws CfwException {
        String envCommand = envCmd;
        Shell shell = new Shell(true);
        try {
            shell.run(envCommand);
            return Environment.getInstance(shell.getProcessOutputChannel(), false);
        }
        catch (Exception e) {
            String msg = "Failed to retrieve environment variables: " + e.toString();
            if (logger != null) {
                logger.log(Level.SEVERE, msg);
            }
            throw new CfwException(msg, e);
        }
    }

    public static Environment getInstance(InputStream inputStream, boolean strict) throws CfwException, IOException {
        return Environment.getInstance(new BufferedReader(new InputStreamReader(inputStream)), strict);
    }

    public static Environment getInstance(BufferedReader reader, boolean strict) throws CfwException, IOException {
        Environment envProperties = new Environment();
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith("#")) continue;
            try {
                String[] keyValuePair = Environment.parseLine(line);
                envProperties.setProperty(keyValuePair[0], keyValuePair[1]);
                continue;
            }
            catch (CfwException e) {
                if (strict) {
                    throw e;
                }
                if (logger == null) continue;
                logger.log(Level.WARNING, "Skipping environment variable line: \"" + line + "\": " + e);
                continue;
            }
            break;
        }
        return envProperties;
    }

    public Environment(Environment copyFrom) {
        this.env = (Properties)copyFrom.env.clone();
    }

    public Environment() {
        this.env = new Properties();
    }

    public Environment(InputStream is) throws IOException {
        this.env = new Properties();
        this.env.load(is);
    }

    public String getProperty(String name) {
        return this.env.getProperty(Environment.handleCase(name));
    }

    public String getPropertyExactCase(String name) {
        return this.env.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.env.getProperty(Environment.handleCase(name), defaultValue);
    }

    public void setProperty(String name, String value) {
        this.env.setProperty(Environment.handleCase(name), value);
    }

    public Enumeration propertyNames() {
        return this.env.propertyNames();
    }

    public int size() {
        return this.env.size();
    }

    public void addAndExpandEnv(Environment additionalEnv) throws CfwException {
        Enumeration keys = additionalEnv.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String rawValue = additionalEnv.getPropertyExactCase(key);
            String value = this.expandEnvironmentVariable(rawValue);
            this.setProperty(key, value);
        }
    }

    public String[] toStringArray() {
        String[] result = new String[this.size()];
        int i = 0;
        Enumeration e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            result[i++] = key + "=" + this.getProperty(key);
        }
        return result;
    }

    private static String[] parseLine(String line) throws CfwException {
        CfmUtil.myAssert(line != null);
        CfmUtil.myAssert(line.trim().length() > 0);
        int index = line.indexOf(61);
        if (index < 0) {
            throw new CfwException("A non-empty environment line must contain \"=\": " + line);
        }
        String key = line.substring(0, index).trim();
        String value = line.substring(index + 1);
        if (key.length() == 0) {
            throw new CfwException("An environment line cannot have an empty variable name: " + line);
        }
        return new String[]{key, value};
    }

    private String expandEnvironmentVariable(String rawString) throws CfwException {
        StringBuffer buf = new StringBuffer();
        int currPos = 0;
        while (true) {
            int currEscapeStart;
            if ((currEscapeStart = rawString.indexOf("${", currPos)) == -1) break;
            buf.append(rawString.substring(currPos, currEscapeStart));
            int currVarNameStart = currEscapeStart + "${".length();
            int currVarNameEnd = rawString.indexOf("}", currVarNameStart);
            if (currVarNameEnd == -1) {
                throw new CfwException("Ending escape sequence \"}\" required to end variable reference: " + rawString.substring(currEscapeStart));
            }
            String variableRef = rawString.substring(currVarNameStart, currVarNameEnd);
            if (this.getProperty(variableRef) == null && logger != null) {
                logger.log(Level.INFO, "Environment variable " + variableRef + " is referenced, but not currently defined");
            }
            buf.append(this.getProperty(variableRef, ""));
            currPos = currVarNameEnd + "}".length();
        }
        buf.append(rawString.substring(currPos));
        return buf.toString();
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Linux") || osName.startsWith("Solaris")) {
            envCmd = "env";
            caseSensitive = true;
        } else if (osName.startsWith("Windows 9")) {
            envCmd = "command.com /c set";
            caseSensitive = false;
        } else if (osName.startsWith("Windows")) {
            envCmd = "cmd.exe /c set";
            caseSensitive = false;
        } else {
            if (logger != null) {
                logger.log(Level.WARNING, "Unexpected value for property os.name=" + osName + "; using \"env\" to retrieve environment variables");
            }
            envCmd = "env";
            caseSensitive = true;
        }
    }
}

