/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugIn;
import oracle.sysman.emCfg.common.IPlugInReference;
import oracle.sysman.emCfg.common.MyProgress;
import oracle.sysman.emCfg.support.Arguments;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.ExitProgramRequest;
import oracle.sysman.emCfg.support.Filer;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepStatus;

public class EmCfgActionPerform {
    private static final int PERFORM = 1;
    private static final int PERFORM_RECOMMENDED = 2;
    private static final int PERFORM_DETACHED = 3;
    private static final int LIST_TOOLS = 4;
    private static final int CHECK_STATUS = 5;
    public static final int SUCCESS = 0;
    public static final int FATAL_ERROR = 1;
    public static final int INCORRECT_USAGE = 2;
    public static final int PERFORM_RECOMMENDED_TOOL_FAILED = 3;
    public static final int PERFORM_OPTIONAL_TOOL_FAILED = 4;
    int performExitCode = 0;
    private Arguments args;
    private String oracleHome;
    private String descriptionPath;
    private String instancePath;
    private int requestType;
    private String[] aggregateID;
    private String actionID;
    private String actionType;
    private boolean debug;
    private boolean blocking;
    private boolean silent;
    private boolean retry;
    private boolean skipDetatched;
    private boolean recommended;
    private PrintStream out;
    private PrintStream err;
    private String responseFile;
    private String[] optionalTools;
    private CfwClient client;
    private CfwSession session;

    private static final String usage1() {
        return "java oracle.sysman.emCfg.common.EmCfgActionPerform\n\t\t\t\t-oracleHome <oracle home absolute path>\n\t\t\t\t-descriptionPath <description path relative to oracle home>\n\t\t\t\t-instancePath <description path relative to oracle home>\n\t\t\t\t-requestType <1-perform | 2-perform recommended | 3-perform detached | 4-list tools | 5-check status>\n\t\t\t\t-aggregateID <comma separated list of aggregate Ids>\n\t\t\t\t-actionType <action type>}\n\t\t\t\t[-options]\n";
    }

    private static final String usage2() {
        return "\t\t-actionID <an action Id within the aggreage to be perfomed>\n\t\t-responseFile <file name to set the aggregate parameters>\n\t\t-optionalTools <comma separated list of tools within curly brackets - { }; can be empty, ALL or aggregateId:plugInId>\n\t\t-out <stdout filename>\n\t\t-err <stderr filename>\n\t\t-async\n\t\t-nonSilent\n\t\t-retry\n\t\t-includeDetatched\n\t\t-help | -h\n\t\t-debug\n";
    }

    public EmCfgActionPerform(String[] args) {
        this.processArgs(args);
    }

    public void processArgs(String[] args_p) {
        if (args_p == null || args_p.length == 0) {
            EmCfgActionPerform.printSysOut("CFM-88001", EmCfgActionPerform.usage1(), EmCfgActionPerform.usage2());
            throw new ExitProgramRequest(1);
        }
        this.args = new Arguments(args_p);
        if (this.args.contains("help") || this.args.contains("h")) {
            EmCfgActionPerform.printSysOut("CFM-88001", EmCfgActionPerform.usage1(), EmCfgActionPerform.usage2());
            throw new ExitProgramRequest(0);
        }
        this.debug = this.args.contains("debug");
        this.oracleHome = this.args.getString("oracleHome");
        this.descriptionPath = this.args.getString("descriptionPath");
        this.instancePath = this.args.getString("instancePath");
        try {
            String outFile = this.args.getString("out");
            String errFile = this.args.getString("err");
            if (outFile != null && outFile.length() > 0) {
                File outF = new File(outFile);
                Filer.createParentDirectories(outF);
                this.out = new PrintStream(new FileOutputStream(outFile));
            } else {
                this.out = System.out;
            }
            if (errFile != null && errFile.length() > 0) {
                File errF = new File(errFile);
                Filer.createParentDirectories(errF);
                this.err = new PrintStream(new FileOutputStream(errFile));
            } else {
                this.err = System.err;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getLocalizedMessage());
            throw new ExitProgramRequest(1);
        }
        String strReqType = this.args.getString("requestType");
        if (strReqType == null) {
            this.print("CFM-88101");
            throw new ExitProgramRequest(1);
        }
        if (strReqType.length() == 0) {
            this.print("CFM-88102");
            throw new ExitProgramRequest(1);
        }
        try {
            this.requestType = Integer.parseInt(strReqType);
        }
        catch (NumberFormatException nfe) {
            this.print("CFM-88103", strReqType);
            throw new ExitProgramRequest(1);
        }
        if (this.requestType != 1 && this.requestType != 3 && this.requestType != 2 && this.requestType != 4 && this.requestType != 5) {
            this.print("CFM-88103", strReqType);
            throw new ExitProgramRequest(1);
        }
        String temp = this.args.getString("aggregateID");
        if (temp == null) {
            this.print("CFM-88111");
            throw new ExitProgramRequest(1);
        }
        if (temp.length() == 0) {
            this.print("CFM-88112");
            throw new ExitProgramRequest(1);
        }
        this.aggregateID = temp.split(",");
        this.actionID = this.args.getString("actionID");
        if (this.actionID != null && this.actionID.length() == 0) {
            this.print("CFM-88122");
            throw new ExitProgramRequest(1);
        }
        this.actionType = this.args.getString("actionType");
        if (this.actionType == null) {
            this.print("CFM-88131");
            throw new ExitProgramRequest(1);
        }
        if (this.actionType.length() == 0) {
            this.print("CFM-88132");
            throw new ExitProgramRequest(1);
        }
        try {
            ActionType.getType(this.actionType);
        }
        catch (CfwException e) {
            this.print("CFM-88133", this.actionType);
            throw new ExitProgramRequest(1);
        }
        this.responseFile = this.args.getString("responseFile");
        if (this.responseFile != null && this.responseFile.length() == 0) {
            this.print("CFM-88161");
            throw new ExitProgramRequest(1);
        }
        temp = this.args.getString("optionalTools");
        if (temp != null) {
            if (temp.length() == 0) {
                this.print("CFM-88171");
                throw new ExitProgramRequest(1);
            }
            if (temp.charAt(0) != '{' || temp.charAt(temp.length() - 1) != '}') {
                this.print("CFM-88172");
                throw new ExitProgramRequest(1);
            }
            temp = temp.substring(1, temp.length() - 1);
            this.optionalTools = temp.split(",");
        }
        switch (this.requestType) {
            case 1: {
                this.blocking = !this.args.contains("async");
                this.silent = !this.args.contains("nonSilent");
                this.retry = this.args.contains("retry");
                this.skipDetatched = !this.args.contains("includeDetatched");
                break;
            }
            case 2: {
                this.blocking = !this.args.contains("async");
                this.silent = !this.args.contains("nonSilent");
                this.retry = this.args.contains("retry");
                this.skipDetatched = !this.args.contains("includeDetatched");
                this.recommended = true;
                break;
            }
            case 3: {
                this.blocking = !this.args.contains("async");
                this.silent = !this.args.contains("nonSilent");
                this.retry = this.args.contains("retry");
                this.skipDetatched = false;
                break;
            }
            case 4: {
                this.silent = !this.args.contains("nonSilent");
                this.retry = this.args.contains("retry");
            }
        }
    }

    public void initialize() throws CfwException {
        ArrayList<String> aggregatesToLoad = new ArrayList<String>();
        for (int i = 0; i < this.aggregateID.length; ++i) {
            aggregatesToLoad.add(this.aggregateID[i].trim());
        }
        this.client = CfwClient.connect(this.debug, this.oracleHome, this.descriptionPath, this.instancePath, aggregatesToLoad);
        this.session = this.client.begin();
        if (this.responseFile != null) {
            this.updateParameters();
            this.session.save();
        }
    }

    public void perform() throws CfwException {
        this.initialize();
        this.session.registerStreams(this.out, this.err);
        this.updateOptionalToolsStatus();
        block14: for (int agg = 0; agg < this.aggregateID.length; ++agg) {
            IActionReference actionReference;
            IAggregateReference aggregateReference;
            CfwIdentifier ident = new CfwIdentifier(this.aggregateID[agg].trim(), "common");
            try {
                aggregateReference = this.session.getAggregateReference(ident);
            }
            catch (CfwException e) {
                this.print("CFM-88113", this.aggregateID[agg].trim());
                continue;
            }
            IAggregate aggregateProxy = this.session.getAggregate(aggregateReference);
            new MyProgress(this.session, aggregateReference, this, this.out, this.err);
            if (this.actionID == null || this.actionID.length() == 0) {
                switch (this.requestType) {
                    case 1: {
                        aggregateProxy.performAction(this.blocking, this.silent, this.retry, this.skipDetatched, ActionType.getType(this.actionType));
                        break;
                    }
                    case 2: {
                        aggregateProxy.performActionRecommended(this.blocking, this.silent, this.retry, this.skipDetatched, ActionType.getType(this.actionType));
                        break;
                    }
                    case 3: {
                        aggregateProxy.performActionDetached(this.blocking, this.silent, this.retry, ActionType.getType(this.actionType));
                    }
                }
                continue;
            }
            try {
                actionReference = aggregateProxy.getActionReference(this.actionID);
            }
            catch (CfwException e) {
                this.print("CFM-88123", this.actionID, this.aggregateID[agg].trim());
                continue;
            }
            IAction actionProxy = aggregateProxy.getAction(actionReference);
            switch (this.requestType) {
                case 1: {
                    actionProxy.perform(this.blocking, this.silent, this.retry, this.skipDetatched, ActionType.getType(this.actionType));
                    continue block14;
                }
                case 2: {
                    actionProxy.performRecommended(this.blocking, this.silent, this.retry, this.skipDetatched, ActionType.getType(this.actionType));
                    continue block14;
                }
                case 3: {
                    actionProxy.performDetached(this.blocking, this.silent, this.retry, ActionType.getType(this.actionType));
                }
            }
        }
    }

    private void updateOptionalToolsStatus() throws CfwException {
        if (this.optionalTools == null) {
            return;
        }
        this.setAllOptionalToolsActive(false);
        for (int i = 0; i < this.optionalTools.length; ++i) {
            String toolName = this.optionalTools[i].trim();
            if (toolName.length() == 0) continue;
            if (toolName.toUpperCase().equals("ALL")) {
                this.setAllOptionalToolsActive(true);
                break;
            }
            int idx = toolName.indexOf(":");
            String aggId = toolName.substring(0, idx);
            String plugInId = toolName.substring(idx + 1, toolName.length());
            this.setOptionalToolsActive(aggId, plugInId, true);
        }
    }

    private void setOptionalToolsActive(String aggId, String plugInId, boolean active) throws CfwException {
        IAggregateReference aggregateReference;
        CfwIdentifier ident = new CfwIdentifier(aggId, "common");
        try {
            aggregateReference = this.session.getAggregateReference(ident);
        }
        catch (CfwException e) {
            this.print("CFM-88113", aggId);
            throw new ExitProgramRequest(1);
        }
        boolean found = false;
        IAggregate aggregate = this.session.getAggregate(aggregateReference);
        IMicroStepStateReference[] msRefs = aggregate.listOptionalTools(this.silent, this.retry, this.skipDetatched, true, ActionType.getType(this.actionType));
        for (int lt = 0; lt < msRefs.length; ++lt) {
            IMicroStepState mstate = this.session.getMicroStepState(msRefs[lt]);
            if (!mstate.getPlugInID().equals(plugInId)) continue;
            found = true;
            mstate.getPlugInInvocationState().setActive(active);
        }
        if (!found) {
            this.print("CFM-88181", plugInId);
            throw new ExitProgramRequest(1);
        }
    }

    private void setAllOptionalToolsActive(boolean active) throws CfwException {
        for (int agg = 0; agg < this.aggregateID.length; ++agg) {
            IAggregateReference aggregateReference;
            CfwIdentifier ident = new CfwIdentifier(this.aggregateID[agg].trim(), "common");
            try {
                aggregateReference = this.session.getAggregateReference(ident);
            }
            catch (CfwException e) {
                this.print("CFM-88113", this.aggregateID[agg].trim());
                continue;
            }
            IAggregate aggregate = this.session.getAggregate(aggregateReference);
            IMicroStepStateReference[] msRefs = aggregate.listOptionalTools(this.silent, this.retry, this.skipDetatched, true, ActionType.getType(this.actionType));
            for (int lt = 0; lt < msRefs.length; ++lt) {
                IMicroStepState mstate = this.session.getMicroStepState(msRefs[lt]);
                mstate.getPlugInInvocationState().setActive(active);
            }
        }
    }

    public void listTools() throws CfwException {
        this.initialize();
        for (int agg = 0; agg < this.aggregateID.length; ++agg) {
            IMicroStepStateReference[] detachedTools;
            IMicroStepStateReference[] optionalTools;
            IMicroStepStateReference[] recommendedTools;
            IAggregateReference aggregateReference;
            CfwIdentifier ident = new CfwIdentifier(this.aggregateID[agg].trim(), "common");
            try {
                aggregateReference = this.session.getAggregateReference(ident);
            }
            catch (CfwException e) {
                this.print("CFM-88113", this.aggregateID[agg].trim());
                continue;
            }
            IAggregate aggregateProxy = this.session.getAggregate(aggregateReference);
            if (this.actionID == null || this.actionID.length() == 0) {
                recommendedTools = aggregateProxy.listTools(true, this.silent, this.retry, true, ActionType.getType(this.actionType));
                optionalTools = aggregateProxy.listOptionalTools(this.silent, this.retry, true, ActionType.getType(this.actionType));
                detachedTools = aggregateProxy.listDetachedTools(this.silent, this.retry, ActionType.getType(this.actionType));
            } else {
                IActionReference actionReference;
                try {
                    actionReference = aggregateProxy.getActionReference(this.actionID);
                }
                catch (CfwException e) {
                    this.print("CFM-88123", this.actionID, this.aggregateID[agg].trim());
                    continue;
                }
                IAction actionProxy = aggregateProxy.getAction(actionReference);
                recommendedTools = actionProxy.listTools(true, this.silent, this.retry, true, ActionType.getType(this.actionType));
                optionalTools = actionProxy.listOptionalTools(this.silent, this.retry, true, ActionType.getType(this.actionType));
                detachedTools = actionProxy.listDetachedTools(this.silent, this.retry, ActionType.getType(this.actionType));
            }
            StringBuffer toolList = new StringBuffer();
            for (int t = 0; t < recommendedTools.length; ++t) {
                IMicroStepState mstate = this.session.getMicroStepState(recommendedTools[t]);
                if (t != 0) {
                    toolList.append(", ");
                }
                toolList.append(this.getLocalizedPlugInDisplayName(mstate));
            }
            Object[] args = new String[]{"" + recommendedTools.length};
            this.printLocalized("CFM-88143", args);
            this.out.println("\t" + toolList);
            toolList = new StringBuffer();
            for (int t = 0; t < optionalTools.length; ++t) {
                IMicroStepState mstate = this.session.getMicroStepState(optionalTools[t]);
                if (t != 0) {
                    toolList.append(", ");
                }
                toolList.append(this.getLocalizedPlugInDisplayName(mstate));
            }
            Object[] args2 = new String[]{"" + optionalTools.length};
            this.printLocalized("CFM-88144", args2);
            this.out.println("\t" + toolList);
            toolList = new StringBuffer();
            for (int t = 0; t < detachedTools.length; ++t) {
                IMicroStepState mstate = this.session.getMicroStepState(detachedTools[t]);
                if (t != 0) {
                    toolList.append(", ");
                }
                toolList.append(this.getLocalizedPlugInDisplayName(mstate));
            }
            Object[] args3 = new String[]{"" + detachedTools.length};
            this.printLocalized("CFM-88145", args3);
            this.out.println("\t" + toolList);
            this.out.println();
        }
    }

    public void checkStatus() throws CfwException {
        this.initialize();
        for (int agg = 0; agg < this.aggregateID.length; ++agg) {
            IMicroStepStateReference[] tools;
            String actionStatus;
            Object[] args;
            IAction actionProxy;
            IAggregateReference aggregateReference;
            CfwIdentifier ident = new CfwIdentifier(this.aggregateID[agg].trim(), "common");
            try {
                aggregateReference = this.session.getAggregateReference(ident);
            }
            catch (CfwException e) {
                this.print("CFM-88113", this.aggregateID[agg].trim());
                continue;
            }
            IAggregate aggregateProxy = this.session.getAggregate(aggregateReference);
            Object[] args0 = new String[]{this.aggregateID[agg].trim()};
            this.printLocalized("CFM-88114", args0);
            if (this.actionID == null || this.actionID.length() == 0) {
                IActionReference[] actionReferences = aggregateProxy.getActionReferences(ActionType.getType(this.actionType));
                if (actionReferences != null && actionReferences.length > 0) {
                    actionProxy = aggregateProxy.getAction(actionReferences[0]);
                    args = new String[]{actionProxy.getSelfID()};
                    actionStatus = MessageFormat.format(((ActionStatus)actionProxy.getActionState().getStatus()).getLocalizedBriefString(), args);
                    this.out.println(actionStatus);
                }
                tools = aggregateProxy.listTools(this.recommended, this.silent, this.retry, this.skipDetatched, ActionType.getType(this.actionType));
            } else {
                IActionReference actionReference;
                try {
                    actionReference = aggregateProxy.getActionReference(this.actionID);
                }
                catch (CfwException e) {
                    this.print("CFM-88123", this.actionID, this.aggregateID[agg].trim());
                    continue;
                }
                actionProxy = aggregateProxy.getAction(actionReference);
                args = new String[]{this.actionID};
                actionStatus = MessageFormat.format(((ActionStatus)actionProxy.getActionState().getStatus()).getLocalizedBriefString(), args);
                this.out.println(actionStatus);
                tools = actionProxy.listTools(this.recommended, this.silent, this.retry, this.skipDetatched, ActionType.getType(this.actionType));
            }
            for (int t = 0; t < tools.length; ++t) {
                IMicroStepState mstate = this.session.getMicroStepState(tools[t]);
                String plugInID = mstate.getPlugInID();
                Object[] args2 = new String[]{plugInID};
                String msStatus = MessageFormat.format(((MicroStepStatus)mstate.getStatus()).getLocalizedBriefString(), args2);
                this.out.println(msStatus);
            }
            this.out.println();
        }
    }

    private void print(String resID) {
        this.printLocalized(resID, null);
    }

    private void print(String resID, String arg0) {
        Object[] args = new Object[]{arg0};
        this.printLocalized(resID, args);
    }

    private void print(String resID, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        this.printLocalized(resID, args);
    }

    private void printLocalized(String resID, Object[] args) {
        ResourceBundle rb = ResourceBundle.getBundle("oracle.sysman.emCfg.common.CfmRuntimeRes");
        this.out.println(MessageFormat.format(rb.getString(resID), args));
    }

    private static void printSysOut(String resID, String arg0) {
        Object[] args = new Object[]{arg0};
        EmCfgActionPerform.printLocalizedSysOut(resID, args);
    }

    private static void printSysOut(String resID, String arg0, String arg1) {
        Object[] args = new Object[]{arg0, arg1};
        EmCfgActionPerform.printLocalizedSysOut(resID, args);
    }

    private static void printLocalizedSysOut(String resID, Object[] args) {
        ResourceBundle rb = ResourceBundle.getBundle("oracle.sysman.emCfg.common.CfmRuntimeRes");
        System.out.println(MessageFormat.format(rb.getString(resID), args));
    }

    public static void main(String[] argv) {
        int exitCode = EmCfgActionPerform.start(argv);
        System.exit(exitCode);
    }

    public static int start(String[] argv) {
        EmCfgActionPerform emCfg;
        try {
            emCfg = new EmCfgActionPerform(argv);
        }
        catch (ExitProgramRequest e) {
            return e.getExitCode();
        }
        catch (Exception e) {
            EmCfgActionPerform.printSysOut("CFM-88150", e.getLocalizedMessage() + "\n" + CfmUtil.throwableToStackTrace(e));
            return 1;
        }
        try {
            return emCfg.serviceRequest();
        }
        catch (ExitProgramRequest e) {
            return e.getExitCode();
        }
        catch (Exception e) {
            emCfg.print("CFM-88150", e.getLocalizedMessage() + "\n" + CfmUtil.throwableToStackTrace(e));
            return 1;
        }
    }

    public int serviceRequest() throws CfwException {
        int exitCode = 0;
        switch (this.requestType) {
            case 1: 
            case 2: 
            case 3: {
                this.perform();
                exitCode = this.performExitCode;
                break;
            }
            case 4: {
                this.listTools();
                break;
            }
            case 5: {
                this.checkStatus();
                break;
            }
            default: {
                this.print("CFM-88103", Integer.toString(this.requestType));
                exitCode = 1;
            }
        }
        return exitCode;
    }

    private void updateParameters() throws CfwException {
        ArrayList<String> missingAgg = new ArrayList<String>();
        HashMap<String, IAggregateReference> aggRefs = new HashMap<String, IAggregateReference>();
        Properties params = new Properties();
        try {
            params.load(new FileInputStream(this.responseFile));
        }
        catch (IOException e) {
            this.print("CFM-88162", e.getLocalizedMessage());
            return;
        }
        Set<Object> set = params.keySet();
        for (String string : set) {
            boolean aggSpecified = true;
            int delimIndex = string.indexOf(124);
            if (delimIndex == -1 || delimIndex == 0 || delimIndex == string.length() - 1) {
                aggSpecified = false;
            }
            String aggId = null;
            String paramId = null;
            if (aggSpecified) {
                aggId = string.substring(0, delimIndex);
                paramId = string.substring(delimIndex + 1, string.length());
            } else {
                paramId = string;
            }
            String value = (String)params.get(string);
            if (value == null || value.length() == 0) {
                value = "";
            }
            if (value.trim().length() == 0) {
                value = " ";
            }
            if (null != aggId && !missingAgg.contains(aggId)) {
                IAggregateReference aggregateReference = (IAggregateReference)aggRefs.get(aggId);
                if (aggregateReference == null) {
                    CfwIdentifier ident = new CfwIdentifier(aggId, "common");
                    try {
                        aggregateReference = this.session.getAggregateReference(ident);
                        aggRefs.put(aggId, aggregateReference);
                    }
                    catch (CfwException e) {
                        this.print("CFM-88113", aggId);
                        missingAgg.add(aggId);
                        continue;
                    }
                }
                IAggregate aggregateProxy = this.session.getAggregate(aggregateReference);
                IParameterReference paramRef = aggregateProxy.getParameterReference(paramId);
                IParameter param = aggregateProxy.getParameter(paramRef);
                param.setSimplestAsString(value);
                continue;
            }
            if (null != aggId) continue;
            this.out.println("Aggregate not specified in response file");
            IAggregateReference[] aggregateRefs = this.session.getAggregateReferences("common");
            IAggregateReference aggref = null;
            IAggregate agg = null;
            this.out.println("Total number of aggrgate references are :" + aggregateRefs.length + " param = : " + paramId);
            if (aggregateRefs == null) continue;
            for (int i = 0; i < aggregateRefs.length; ++i) {
                aggref = aggregateRefs[i];
                agg = this.session.getAggregate(aggref);
                this.out.println("Checking if the parameter is present in agg : " + agg.getSelfID());
                try {
                    IParameterReference paramRef = agg.getParameterReference(paramId);
                    if (null == paramRef) continue;
                    IParameter param = agg.getParameter(paramRef);
                    this.out.println("Setting the paramter in the agg : " + agg.getSelfID());
                    param.setSimplestAsString(value);
                    continue;
                }
                catch (CfwException cfwException) {
                    // empty catch block
                }
            }
        }
    }

    private String getLocalizedPlugInDisplayName(IMicroStepState mstate) throws CfwException {
        String plugInID;
        String displayName = plugInID = mstate.getPlugInID();
        IActionState astate = mstate.getActionState();
        String aggID = astate.getOriginator().getSelfID();
        CfwIdentifier ident = new CfwIdentifier(aggID, "common");
        IAggregateReference aggregateReference = this.session.getAggregateReference(ident);
        IAggregate aggregateProxy = this.session.getAggregate(aggregateReference);
        IPlugInReference[] plugInRefs = aggregateProxy.getPlugInReferences();
        for (int i = 0; i < plugInRefs.length; ++i) {
            IPlugIn plugIn = aggregateProxy.getPlugIn(plugInRefs[i]);
            if (!plugIn.getSelfID().equals(plugInID)) continue;
            displayName = plugIn.getLocalizedDisplayName();
            break;
        }
        return displayName;
    }

    public synchronized void updateExitCode(int code) {
        this.performExitCode = this.performExitCode == 0 ? code : (code < this.performExitCode ? code : this.performExitCode);
    }
}

