/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import java.io.File;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.sysman.emCfg.logger.CfmFileHandler;
import oracle.sysman.emCfg.logger.CfmLogger;

public class CfmLoggerFactory {
    public static void createLogger(String loggerName, String oracleHome) {
        CfmLogger logger = CfmLogger.getCfmLogger(loggerName + "|" + oracleHome, true);
        String logDir = oracleHome + File.separator + CfmLogger.LOG_DIR_RELATIVE_PATH;
        logger.addCfmFileHandler(logDir, null, null, CfmLogger.TIMESTAMPED_LOG_FILES);
        logger.setParent(CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME));
        logger.setPrefix(loggerName);
    }

    public static void closeCfmFileHandlers() {
        Enumeration<String> enumLogNames = LogManager.getLogManager().getLoggerNames();
        while (enumLogNames.hasMoreElements()) {
            String loggerName = enumLogNames.nextElement();
            Logger logger = Logger.getLogger(loggerName);
            if (logger.getName().equals("CfmDefaultLogger") || !(logger instanceof CfmLogger)) continue;
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof CfmFileHandler)) continue;
                handlers[i].close();
            }
        }
    }
}

