/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import java.io.PrintStream;
import oracle.sysman.emCfg.common.Environment;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IInternalPlugIn;
import oracle.sysman.emCfg.common.IInternalPlugInContext;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

public abstract class CfmInternalPlugIn
implements IInternalPlugIn {
    protected final CfmLogger plugInLogger;
    protected final IAggregate aggregate;
    protected final PrintStream out;
    protected final PrintStream err;
    protected final Environment env;

    public CfmInternalPlugIn() {
        this.plugInLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
        this.aggregate = null;
        this.out = System.out;
        this.err = System.err;
        this.env = null;
    }

    public CfmInternalPlugIn(String plugInID) {
        this.plugInLogger = CfmLogger.getCfmLogger(plugInID, true);
        this.plugInLogger.addCfmFileHandler();
        this.plugInLogger.setParent(CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME));
        this.plugInLogger.setPrefix(plugInID);
        this.aggregate = null;
        this.out = System.out;
        this.err = System.err;
        this.env = null;
    }

    public CfmInternalPlugIn(IAggregate aggregate) {
        this.plugInLogger = CfmUtil.getCfmLogger(aggregate);
        this.aggregate = aggregate;
        this.out = System.out;
        this.err = System.err;
        this.env = null;
    }

    public CfmInternalPlugIn(IInternalPlugInContext context) {
        this.aggregate = context.getAggregate();
        this.plugInLogger = CfmUtil.getCfmLogger(this.aggregate);
        this.out = context.getOutStream();
        this.err = context.getErrStream();
        this.env = context.getEnv();
    }

    protected void reportProgress(String message) {
        this.out.println(message);
        this.out.flush();
    }

    protected void reportError(String message) {
        this.err.println(message);
        this.err.flush();
    }

    protected Environment getEnv() {
        return this.env;
    }
}

