/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.support.CfmUtil;

public class AggregateVersion
implements Comparable {
    public static final AggregateVersion LATEST = new AggregateVersion();
    public static final String LATEST_VERSION_TAG = "LATEST(unresolved_version)";
    protected static final String MINOR_VERSION_SEPARATOR_IN_FILENAME = "_";
    protected static final String MINOR_VERSION_SEPARATOR_NORMAL = ".";
    private ArrayList versionNums = new ArrayList(5);
    private int significantParts = 0;
    private static char NO_VERSION_LETTER_CHAR = '\u0000';
    private char versionLetter = NO_VERSION_LETTER_CHAR;
    private static final Comparator reverseComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            AggregateVersion v1 = (AggregateVersion)o1;
            AggregateVersion v2 = (AggregateVersion)o2;
            return v2.compareTo(v1);
        }
    };

    public static AggregateVersion versionFromFilename(String versionAsFilenameString) throws CfwException {
        AggregateVersion result = new AggregateVersion();
        result.parseVersionFromString(versionAsFilenameString, MINOR_VERSION_SEPARATOR_IN_FILENAME);
        return result;
    }

    public static AggregateVersion versionFromString(String versionAsVersionString) throws CfwException {
        if (versionAsVersionString.equals(LATEST_VERSION_TAG)) {
            return LATEST;
        }
        AggregateVersion result = new AggregateVersion();
        result.parseVersionFromString(versionAsVersionString, MINOR_VERSION_SEPARATOR_NORMAL);
        return result;
    }

    public AggregateVersion(String versionAsString) throws CfwException {
        int firstSeparatorFilename = versionAsString.indexOf(MINOR_VERSION_SEPARATOR_IN_FILENAME);
        if (firstSeparatorFilename != -1) {
            this.parseVersionFromString(versionAsString, MINOR_VERSION_SEPARATOR_IN_FILENAME);
        } else {
            this.parseVersionFromString(versionAsString, MINOR_VERSION_SEPARATOR_NORMAL);
        }
    }

    public AggregateVersion(int majorVersion, int minorVersion1) {
        this.versionNums.add(new Integer(majorVersion));
        this.versionNums.add(new Integer(minorVersion1));
    }

    public AggregateVersion(int majorVersion, int minorVersion1, char letter) {
        this(majorVersion, minorVersion1);
        this.versionLetter = letter;
    }

    public AggregateVersion(int majorVersion, int minorVersion1, int minorVersion2) {
        this(majorVersion, minorVersion1);
        this.versionNums.add(new Integer(minorVersion2));
    }

    public AggregateVersion(int majorVersion, int minorVersion1, int minorVersion2, char letter) {
        this(majorVersion, minorVersion1, minorVersion2);
        this.versionLetter = letter;
    }

    public AggregateVersion(int majorVersion, int minorVersion1, int minorVersion2, int minorVersion3) {
        this(majorVersion, minorVersion1, minorVersion2);
        this.versionNums.add(new Integer(minorVersion3));
    }

    public AggregateVersion(int majorVersion, int minorVersion1, int minorVersion2, int minorVersion3, int minorVersion4) {
        this(majorVersion, minorVersion1, minorVersion2, minorVersion3);
        this.versionNums.add(new Integer(minorVersion4));
    }

    public AggregateVersion(int majorVersion, int minorVersion1, int minorVersion2, int minorVersion3, int minorVersion4, char letter) {
        this(majorVersion, minorVersion1, minorVersion2, minorVersion3, minorVersion4);
        this.versionLetter = letter;
    }

    public String toString() {
        if (this == LATEST) {
            return LATEST_VERSION_TAG;
        }
        return this.toString(MINOR_VERSION_SEPARATOR_NORMAL);
    }

    public String toFilenameString() {
        return this.toString(MINOR_VERSION_SEPARATOR_IN_FILENAME);
    }

    public int compareTo(Object o) {
        AggregateVersion rhs = (AggregateVersion)o;
        for (int i = 0; i < this.significantParts && i < rhs.significantParts; ++i) {
            int comp = ((Integer)this.versionNums.get(i)).compareTo((Integer)rhs.versionNums.get(i));
            if (comp == 0) continue;
            return comp;
        }
        int partCompare = CfmUtil.intCompare(this.significantParts, rhs.significantParts);
        if (partCompare != 0) {
            return partCompare;
        }
        return CfmUtil.intCompare(this.getVersionLetterUpperCase(), rhs.getVersionLetterUpperCase());
    }

    public static Comparator getReverseComparator() {
        return reverseComparator;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            return this.compareTo(o) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        int result = this.getVersionLetterUpperCase();
        for (int i = 0; i < this.significantParts; ++i) {
            result = result * 31 + (Integer)this.versionNums.get(i);
        }
        return result;
    }

    private AggregateVersion() {
    }

    private char getVersionLetterUpperCase() {
        return Character.toUpperCase(this.versionLetter);
    }

    protected String toString(String separatorString) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.versionNums.iterator();
        if (i.hasNext()) {
            sb.append(((Integer)i.next()).toString());
            while (i.hasNext()) {
                sb.append(separatorString);
                sb.append(((Integer)i.next()).toString());
            }
        }
        if (this.versionLetter != NO_VERSION_LETTER_CHAR) {
            sb.append(this.versionLetter);
        }
        return sb.toString();
    }

    private void parseVersionFromString(String versionAsString, String separator) throws CfwException {
        int nextPos;
        if (versionAsString.length() < 1) {
            return;
        }
        char lastChar = versionAsString.charAt(versionAsString.length() - 1);
        if (Character.isLetter(lastChar)) {
            this.versionLetter = lastChar;
            versionAsString = versionAsString.substring(0, versionAsString.length() - 1);
        }
        int currentPos = 0;
        while ((nextPos = versionAsString.indexOf(separator, currentPos)) != -1) {
            this.extractPart(versionAsString, currentPos, nextPos);
            currentPos = nextPos + separator.length();
        }
        this.extractPart(versionAsString, currentPos, versionAsString.length());
    }

    private void extractPart(String versionAsString, int start, int end) throws CfwException {
        try {
            String subString = versionAsString.substring(start, end);
            int newValue = Integer.parseInt(subString);
            if (newValue < 0) {
                throw new CfwException("invalid version number (contained a minus sign)");
            }
            this.versionNums.add(new Integer(newValue));
            if (newValue != 0) {
                this.significantParts = this.versionNums.size();
            }
        }
        catch (NumberFormatException e) {
            throw new CfwException("invalid version number: ", e);
        }
    }
}

