/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.common;

import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwVersionedIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;

public class AggregateInstanceIdentifierWithLocation
extends AggregateFamilyIdentifier {
    private final long label;

    public AggregateInstanceIdentifierWithLocation(String aggregateID, String namespace, AggregateVersion version, String family, long label, OHAbsolute oh) {
        super(aggregateID, namespace, version, family, oh);
        this.label = label;
    }

    public AggregateInstanceIdentifierWithLocation(CfwVersionedIdentifier owner, String family, long label, OHAbsolute oh) {
        super(owner.getSelfID(), owner.getNamespace(), owner.getVersion(), family, oh);
        this.label = label;
    }

    public AggregateInstanceIdentifierWithLocation(AggregateFamilyIdentifier familyIdent, long label) {
        super(familyIdent.getSelfID(), familyIdent.getNamespace(), familyIdent.getVersion(), familyIdent.getFamily(), familyIdent.getOH());
        this.label = label;
    }

    public long getLabel() {
        return this.label;
    }

    public String toFilenameString() {
        String DELIM = ".";
        return this.getSelfID() + "." + this.getVersion().toFilenameString() + "." + this.getFamily() + "." + this.getLabel() + ".inst.xml";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AggregateInstanceIdentifierWithLocation rhs = (AggregateInstanceIdentifierWithLocation)o;
        return this.getLabel() == rhs.getLabel();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + new Long(this.getLabel()).hashCode();
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ":label=" + this.getLabel();
    }

    public AggregateFamilyIdentifier getFamilyIdentWithLocation() {
        return new AggregateFamilyIdentifier(this.getSelfID(), this.getNamespace(), this.getVersion(), this.getFamily(), this.getOH());
    }
}

