/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import java.io.PrintStream;
import java.util.logging.Level;
import oracle.sysman.emCfg.client.CfwActionState;
import oracle.sysman.emCfg.client.CfwActionStepState;
import oracle.sysman.emCfg.client.CfwAggregate;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.client.CfwLogger;
import oracle.sysman.emCfg.client.CfwMicroStepState;
import oracle.sysman.emCfg.client.Command2;
import oracle.sysman.emCfg.client.CommandType;
import oracle.sysman.emCfg.client.ICfwLogger;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStateReference;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.ICfw;
import oracle.sysman.emCfg.common.ICommand;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.common.IStateReference;
import oracle.sysman.emCfg.core.CfmFactory;
import oracle.sysman.emCfg.core.CfmSession;

public class CfwSession
implements ICfw {
    private static final boolean debug = CfwClient.isDebug();
    private static final ICfwLogger cfwLogger = new CfwLogger(CfwLogger.CFW_LOGGER_NAME);
    private String cfmSessionID;

    @Override
    public IAggregateReference[] getAggregateReferences(String nameSpace) throws CfwException {
        return (IAggregateReference[])this.cmd2(new Command2(CommandType.ICfw_getAggregateReferences, null, nameSpace));
    }

    @Override
    public IAggregateReference getAggregateReference(CfwIdentifier aggregateIdentifier) throws CfwException {
        return (IAggregateReference)this.cmd2(new Command2(CommandType.ICfw_getAggregateReference, null, aggregateIdentifier));
    }

    @Override
    public IAggregate getAggregate(IAggregateReference reference) throws CfwException {
        this.cmd2(new Command2(CommandType.ICfw_getAggregate, null, reference));
        return new CfwAggregate(this, reference);
    }

    @Override
    public String[] save() throws CfwException {
        return (String[])this.cmd2(new Command2(CommandType.ICfw_save, null));
    }

    @Override
    public void registerStreams(PrintStream out, PrintStream err) throws CfwException {
        this.cmd2void(new Command2(CommandType.ICfw_registerStreams, null, out, err));
    }

    @Override
    public void registerLogDir(String logDir) throws CfwException {
        this.cmd2void(new Command2(CommandType.ICfw_registerLogDir, null, logDir));
    }

    @Override
    public void setSessionPropertyEnvVarsFile(String newFilename) throws CfwException {
        this.cmd2void(new Command2(CommandType.ICfw_setSessionPropertyEnvVarsFile, null, newFilename));
    }

    @Override
    public void setActiveGlobal(CfwIdentifier referredAggregate, boolean isActive) throws CfwException {
        this.cmd2void(new Command2(CommandType.ICfw_setActiveGlobal, null, referredAggregate, isActive));
    }

    @Override
    public String[] purgeInstances(CfwIdentifier aggregateIdentifier, String oracleHome, String instanceBase) throws CfwException {
        return (String[])this.cmd2(new Command2(CommandType.ICfw_purgeInstances, null, aggregateIdentifier, oracleHome, instanceBase));
    }

    public IActionState getActionState(IActionStateReference actionStateReference) {
        return new CfwActionState(this, actionStateReference);
    }

    public IActionStepState getActionStepState(IActionStepStateReference actionStepStateReference) {
        return new CfwActionStepState(this, actionStepStateReference);
    }

    public IMicroStepState getMicroStepState(IMicroStepStateReference microStepStateReference) {
        return new CfwMicroStepState(this, microStepStateReference);
    }

    String getSessionID() {
        return this.cfmSessionID;
    }

    protected CfwSession(String cfmSessionID) {
        this.cfmSessionID = cfmSessionID;
    }

    static CfwSession newSession(CfmFactory cfmFactory) throws CfwException {
        if (cfmFactory == null) {
            throw new CfwException("invalid (null) Cfm Factory");
        }
        String cfmSessionID = CfmSession.newSession(cfmFactory);
        if (cfmSessionID == null) {
            throw new CfwException("unable to obtain CfmSession ID");
        }
        if (debug) {
            cfwLogger.log(Level.INFO, "CfwSession.newSession: obtained cfmSessionID = " + cfmSessionID);
        }
        return new CfwSession(cfmSessionID);
    }

    protected void endSession() {
        CfmSession.endSession(this.getSessionID());
        this.cfmSessionID = null;
    }

    protected void finalize() {
        if (this.getSessionID() != null) {
            cfwLogger.log(Level.WARNING, "CfwSession id=" + this.getSessionID() + " was destroyed without a proper call to endSession!");
            CfmSession.endSession(this.getSessionID());
        }
    }

    void cmd(IReference ref, ICommand cmd) throws CfwException {
        if (cmd == null) {
            throw new CfwException("invalid (null) cmd");
        }
        if (debug) {
            cfwLogger.log(Level.INFO, "CfwSession.cmd: passing " + this.getSessionID());
        }
        CfmSession.cmd(this.getSessionID(), ref, cmd);
    }

    void cmd2void(Command2 cmd) throws CfwException {
        if (debug) {
            cfwLogger.log(Level.INFO, "CfwSession.cmd: passing " + this.getSessionID());
        }
        CfmSession.cmd2(this.getSessionID(), cmd);
        cmd.rethrowException();
    }

    Object cmd2(Command2 cmd) throws CfwException {
        this.cmd2void(cmd);
        return cmd.getReturnValue();
    }

    int cmd2int(Command2 cmd) throws CfwException {
        return (Integer)this.cmd2(cmd);
    }

    boolean cmd2bool(Command2 cmd) throws CfwException {
        return (Boolean)this.cmd2(cmd);
    }

    void cmd(IStateReference ref, ICommand cmd) throws CfwException {
        if (cmd == null) {
            throw new CfwException("invalid (null) cmd");
        }
        if (debug) {
            cfwLogger.log(Level.INFO, "CfwSession.cmd: passing " + this.getSessionID());
        }
        CfmSession.cmd(this.getSessionID(), ref, cmd);
    }
}

