/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import java.util.logging.Level;
import oracle.sysman.emCfg.client.CfwActionStepState;
import oracle.sysman.emCfg.client.CfwLogger;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.client.ICfwLogger;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStateReference;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.common.IProgressMonitor;
import oracle.sysman.emCfg.common.macros.PlugInInvocation;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.ActionStepStatus;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.emCfg.types.StatusResourceType;

public abstract class CfwProgressMonitor
implements IProgressMonitor {
    static ICfwLogger cfwLogger = new CfwLogger(CfwLogger.CFW_LOGGER_NAME);
    private final CfwSession session;

    public CfwProgressMonitor(CfwSession session) {
        this.session = session;
    }

    public CfwSession getSession() {
        return this.session;
    }

    @Override
    public void actionStart(IActionStateReference actionStateReference, IActionStepStateReference[] items) throws CfwException {
        IActionState aState = this.getSession().getActionState(actionStateReference);
        for (int i = 0; i < items.length; ++i) {
            CfwActionStepState sState = new CfwActionStepState(this.getSession(), items[i]);
            cfwLogger.log(Level.INFO, "CfwProgressMonitor:actionStart:Will perform action=" + aState.getSelfID() + " Status=" + aState.getStatus() + " with ActionStep=" + sState.getSelfID());
        }
    }

    @Override
    public void actionEnd(IActionStateReference actionStateReference) throws CfwException {
        IActionState aState = this.getSession().getActionState(actionStateReference);
        cfwLogger.log(Level.INFO, "CfwProgressMonitor:actionEnd:Performed Action=" + aState.getSelfID() + " Status=" + aState.getStatus());
    }

    @Override
    public void actionProgress(IActionStateReference actionStateReference, IActionStepStateReference item, int stepIndex, int microIndex) throws CfwException {
        IActionState aState = this.getSession().getActionState(actionStateReference);
        IActionStepState sState = this.getSession().getActionStepState(item);
        cfwLogger.log(Level.INFO, "CfwProgressMonitor:actionProgress:About to perform Action=" + aState.getSelfID() + " Status=" + aState.getStatus() + " with ActionStep=" + sState.getSelfID() + " stepIndex=" + stepIndex + " microStep=" + microIndex);
    }

    @Override
    public void parameterChange(IParameterReference parameterID) {
        cfwLogger.log(Level.INFO, "CfwProgressMonitor:parameterChange:" + StatusResourceType.UNINMPLEMENTED_FEATURE.getStatusBriefString());
    }

    @Override
    public void plugInStart(IMicroStepStateReference microStepStateReference) throws CfwException {
        IMicroStepState state = this.getSession().getMicroStepState(microStepStateReference);
        MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
        IPlugInInvocationState pState = state.getPlugInInvocationState();
        cfwLogger.log(Level.INFO, "CfwProgressMonitor:plugInStart:" + pState.getPlugInID() + " in MicroStep=" + state.getSelfID() + ", status=" + microStatus.getStatusBriefString() + ", command=" + pState.getCommand() + ", arguments=" + pState.getArg());
    }

    @Override
    public void plugInEnd(IMicroStepStateReference microStepStateReference) throws CfwException {
        IMicroStepState state = this.getSession().getMicroStepState(microStepStateReference);
        MicroStepStatus microStatus = (MicroStepStatus)state.getStatus();
        IPlugInInvocationState pState = state.getPlugInInvocationState();
        IActionStepState aState = state.getActionStepState();
        ActionStepStatus stat = (ActionStepStatus)aState.getStatus();
        IActionState actionState = state.getActionState();
        ActionStatus actionStatus = (ActionStatus)actionState.getStatus();
        cfwLogger.log(Level.INFO, "CfwProgressMonitor:plugInEnd: PlugIn=" + pState.getPlugInID() + " in MicroStep=" + state.getSelfID() + ", type=" + state.getFlavor() + ", status=" + microStatus.getStatusBriefString() + "\nin ActionStep=" + aState.getSelfID() + ", status=" + stat + "\nin Action=" + actionState.getSelfID() + ", status=" + actionStatus + "\nexit code=" + PlugInInvocation.getExitCode(state) + ", exception=" + PlugInInvocation.getException(state) + ", stdout.length=" + pState.getStdout().length() + ", stderr.length=" + pState.getStderr().length());
    }
}

