/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;

public class CfwParameterManager {
    CfwSession cfwSession = null;

    public CfwParameterManager(CfwSession cfwSession) {
        this.cfwSession = cfwSession;
    }

    private IParameter getParameter(String aggregateID, String parameterID) {
        try {
            IAggregateReference[] aggregateReferences = this.cfwSession.getAggregateReferences("common");
            for (int i = 0; i < aggregateReferences.length; ++i) {
                IAggregateReference aggregateReference = aggregateReferences[i];
                if (!aggregateReference.getSelfID().equals(aggregateID)) continue;
                IAggregate aggregateProxy = this.cfwSession.getAggregate(aggregateReference);
                IParameterReference[] parameterReferences = aggregateProxy.getParameterReferences();
                for (int p = 0; p < parameterReferences.length; ++p) {
                    IParameterReference parameterReference = parameterReferences[p];
                    if (!parameterReference.getSelfID().equals(parameterID)) continue;
                    IParameter parameterProxy = aggregateProxy.getParameter(parameterReference);
                    return parameterProxy;
                }
            }
        }
        catch (CfwException e) {
            e.printStackTrace();
        }
        return null;
    }

    private IParameter getParameter(IAggregateReference aggRef, IParameterReference paramRef) {
        try {
            IAggregate aggregateProxy = this.cfwSession.getAggregate(aggRef);
            IParameter parameterProxy = aggregateProxy.getParameter(paramRef);
            return parameterProxy;
        }
        catch (CfwException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getParamValAsXML(IAggregateReference aggRef, IParameterReference paramRef) {
        IParameter parameterProxy = this.getParameter(aggRef, paramRef);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValue();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getParamValAsXML(String aggregateID, String parameterID) {
        IParameter parameterProxy = this.getParameter(aggregateID, parameterID);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValue();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean getParamValAsSimplestBoolean(IAggregateReference aggRef, IParameterReference paramRef) {
        IParameter parameterProxy = this.getParameter(aggRef, paramRef);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsSimplestBoolean();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean getParamValAsSimplestBoolean(String aggregateID, String parameterID) {
        IParameter parameterProxy = this.getParameter(aggregateID, parameterID);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsSimplestBoolean();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int getParamValAsSimplestInt(IAggregateReference aggRef, IParameterReference paramRef) {
        IParameter parameterProxy = this.getParameter(aggRef, paramRef);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsSimplestInt();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public int getParamValAsSimplestInt(String aggregateID, String parameterID) {
        IParameter parameterProxy = this.getParameter(aggregateID, parameterID);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsSimplestInt();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public String getParamValAsSimplestString(IAggregateReference aggRef, IParameterReference paramRef) {
        IParameter parameterProxy = this.getParameter(aggRef, paramRef);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsSimplestString();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getParamValAsSimplestString(String aggregateID, String parameterID) {
        IParameter parameterProxy = this.getParameter(aggregateID, parameterID);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsSimplestString();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getParamValAsSimplestXmlDoc(IAggregateReference aggRef, IParameterReference paramRef) {
        IParameter parameterProxy = this.getParameter(aggRef, paramRef);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsXmlDocument();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getParamValAsSimplestXmlDoc(String aggregateID, String parameterID) {
        IParameter parameterProxy = this.getParameter(aggregateID, parameterID);
        if (parameterProxy != null) {
            try {
                return parameterProxy.getValueAsXmlDocument();
            }
            catch (CfwException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

