/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import java.io.Serializable;
import oracle.sysman.emCfg.client.CfwObject;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Command;
import oracle.sysman.emCfg.common.ICommand;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.types.ParameterStatus;
import oracle.sysman.emCfg.types.ParameterType;
import oracle.xml.parser.v2.XMLDocument;

class CfwParameter
extends CfwObject
implements IParameter {
    public CfwParameter(CfwSession session, IParameterReference ref) {
        super(session, ref);
    }

    @Override
    public void setValue(String valueAsXmlString) throws CfwException {
        try {
            Command cmd = Command.setValueFromXmlString();
            cmd.setFirstParam(valueAsXmlString);
            this.getSession().cmd(this.getReference(), (ICommand)cmd);
            cmd.clear();
        }
        catch (CfwException e) {
            throw new CfwException("CfwParameter.setValue: could not set value with xml string=" + valueAsXmlString, e);
        }
    }

    @Override
    public void setValue(XMLDocument valueAsXmlDocument) throws CfwException {
        Command cmd = Command.setValueFromXmlDocument();
        cmd.setFirstParam(valueAsXmlDocument);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public String getValue() throws CfwException {
        Command cmd = Command.getValueAsXmlString();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        String res = (String)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public String getValueAsXmlDocument() throws CfwException {
        Command cmd = Command.getValueAsXmlDocument();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        String res = (String)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    public boolean isValidValue(String valueAsXmlString) throws CfwException {
        Command cmd = Command.isValidValueAsXmlString();
        cmd.setFirstParam(valueAsXmlString);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        boolean res = (Boolean)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    public boolean isValidValue(XMLDocument valueAsXmlDocument) throws CfwException {
        Command cmd = Command.isValidValueAsXmlDocument();
        cmd.setFirstParam(valueAsXmlDocument);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        boolean res = (Boolean)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public boolean isSettable() throws CfwException {
        Command cmd = Command.isSettable();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        boolean res = (Boolean)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public boolean isEncrypted() throws CfwException {
        Command cmd = Command.isEncrypted();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        boolean res = (Boolean)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public ParameterType getType() throws CfwException {
        Command cmd = Command.getTypeOfParameter();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        ParameterType res = (ParameterType)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public boolean isType(ParameterType type) throws CfwException {
        Command cmd = Command.isTypeOfParameter();
        cmd.setFirstParam(type);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        boolean res = (Boolean)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    public int[] getDimensions() throws CfwException {
        Command cmd = Command.getDimensions();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        int[] res = (int[])cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    public void setDimensions(int[] dimensions) throws CfwException {
        Command cmd = Command.setDimensions();
        cmd.setFirstParam(dimensions);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public void setSimplestAsStringArray(String[] valueAsStringArray) throws CfwException {
        Command cmd = Command.setSimplestAsStringArray();
        cmd.setFirstParam(valueAsStringArray);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public void setSimplestAsString(String valueAsString) throws CfwException {
        Command cmd = Command.setSimplestAsString();
        cmd.setFirstParam(valueAsString);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public void setSimplestAsInt(int valueAsInt) throws CfwException {
        Command cmd = Command.setSimplestAsInt();
        cmd.setFirstParam(new Integer(valueAsInt));
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public void setSimplestAsBoolean(boolean valueAsBoolean) throws CfwException {
        Command cmd = Command.setSimplestAsBoolean();
        cmd.setFirstParam(valueAsBoolean);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public String[] getValueAsSimplestStringArray() throws CfwException {
        Command cmd = Command.getValueAsSimplestStringArray();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        String[] res = (String[])cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public String getValueAsSimplestString() throws CfwException {
        Command cmd = Command.getValueAsSimplestString();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        String res = (String)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public int getValueAsSimplestInt() throws CfwException {
        Command cmd = Command.getValueAsSimplestInt();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        int res = (Integer)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public boolean getValueAsSimplestBoolean() throws CfwException {
        Command cmd = Command.getValueAsSimplestBoolean();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        boolean res = (Boolean)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public ParameterStatus getParameterStatus() throws CfwException {
        Command cmd = Command.getParameterStatus();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        ParameterStatus res = (ParameterStatus)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    public String getHexedValue() throws CfwException {
        Command cmd = Command.getHexedValue();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        String res = (String)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public void setValueAsSerializable(Serializable valueAsSerializable) throws CfwException {
        Command cmd = Command.setSimplestAsSerializable();
        cmd.setFirstParam(valueAsSerializable);
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        cmd.clear();
    }

    @Override
    public Serializable getValueAsSerializable() throws CfwException {
        Command cmd = Command.getValueAsSerializable();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        Serializable res = (Serializable)cmd.getReturnValue();
        cmd.clear();
        return res;
    }
}

