/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import oracle.sysman.emCfg.client.CfwObject;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Command;
import oracle.sysman.emCfg.common.ICommand;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IObjectState;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.common.IStateReference;
import oracle.sysman.emCfg.types.IStatus;

class CfwObjectState
implements IObjectState {
    private CfwSession session;
    private IStateReference selfRef;

    public CfwObjectState(CfwSession session, IStateReference ref) {
        this.session = session;
        this.selfRef = ref;
    }

    @Override
    public IObjectState getParent() throws CfwException {
        Command cmd = Command.getParentOfState();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        IStateReference ref = (IStateReference)res;
        CfwObjectState cfwObjectState = new CfwObjectState(this.getSession(), ref);
        cmd.clear();
        return cfwObjectState;
    }

    @Override
    public String getSummary() throws CfwException {
        Command cmd = Command.getSummary();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        String summary = (String)res;
        cmd.clear();
        return summary;
    }

    @Override
    public IStatus getStatus() throws CfwException {
        Command cmd = Command.getStatus();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        IStatus status = (IStatus)res;
        cmd.clear();
        return status;
    }

    @Override
    public IObject getOriginator() throws CfwException {
        Command cmd = Command.getOriginator();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        IReference ref = (IReference)res;
        CfwObject cfwObject = new CfwObject(this.getSession(), ref);
        cmd.clear();
        return cfwObject;
    }

    @Override
    public IStateReference getReference() {
        return this.selfRef;
    }

    @Override
    public String getSelfID() {
        return this.selfRef.getSelfID();
    }

    public CfwSession getSession() {
        return this.session;
    }

    public String toString() {
        return this.selfRef.toString();
    }
}

