/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Command;
import oracle.sysman.emCfg.common.ICommand;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.StatusOrType;

class CfwObject
implements IObject {
    private final CfwSession session;
    private final IReference selfRef;

    public CfwObject(CfwSession session, IReference reference) {
        CfmUtil.preconditionNotNull(session, "session");
        CfmUtil.preconditionNotNull(reference, "reference");
        this.session = session;
        this.selfRef = reference;
    }

    @Override
    public IObject getParent() throws CfwException {
        Command cmd = Command.getParent();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        IReference ref = (IReference)res;
        CfwObject cfwObject = new CfwObject(this.getSession(), ref);
        cmd.clear();
        return cfwObject;
    }

    @Override
    public IObject getOriginator() throws CfwException {
        Command cmd = Command.getOriginator();
        cmd.setFirstParam(this.getParent().getReference());
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        IReference ref = (IReference)res;
        CfwObject cfwObject = new CfwObject(this.getSession(), ref);
        cmd.clear();
        return cfwObject;
    }

    @Override
    public String getDesc() throws CfwException {
        Command cmd = Command.getDesc();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        Object res = cmd.getReturnValue();
        String desc = (String)res;
        cmd.clear();
        return desc;
    }

    @Override
    public String getSummary() throws CfwException {
        Command cmd = Command.getSummary();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        String res = (String)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public StatusOrType getStatus() throws CfwException {
        Command cmd = Command.getStatus();
        this.getSession().cmd(this.getReference(), (ICommand)cmd);
        StatusOrType res = (StatusOrType)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public String getOracleHome() throws CfwException {
        Command cmd = Command.getOracleHome();
        this.getSession().cmd(this.selfRef, (ICommand)cmd);
        String res = (String)cmd.getReturnValue();
        cmd.clear();
        return res;
    }

    @Override
    public IReference getReference() {
        return this.selfRef;
    }

    @Override
    public String getSelfID() {
        return this.selfRef.getSelfID();
    }

    CfwSession getSession() {
        return this.session;
    }

    public String toString() {
        return this.selfRef.toString();
    }
}

