/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.client;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import oracle.sysman.emCfg.client.CfwLogger;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.client.ClientConstants;
import oracle.sysman.emCfg.client.ICfwLogger;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.core.CfmFactory;

public class CfwClient {
    private static final ICfwLogger cfwLogger = new CfwLogger(CfwLogger.CFW_LOGGER_NAME);
    private boolean isDisconnected = false;
    public static boolean debug = false;
    private static CfwClient _singleton = null;
    private final Hashtable sessionHash = new Hashtable();
    private final CfmFactory cfmFactory;

    public static boolean isDebug() {
        return debug;
    }

    public static CfwClient connect(List aggregateIDsAsList) throws CfwException {
        return CfwClient.connect(Constants.VERBOSE_OUTPUT, aggregateIDsAsList);
    }

    public static CfwClient connect(boolean debugB, List aggregateIDsAsList) throws CfwException {
        return CfwClient.connect(debugB, null, null, null, aggregateIDsAsList);
    }

    public static CfwClient connect(String oracleHome, String descriptionsBase, String instanceBase, List aggregateIDsAsList) throws CfwException {
        return CfwClient.connect(Constants.VERBOSE_OUTPUT, oracleHome, descriptionsBase, instanceBase, aggregateIDsAsList);
    }

    public static CfwClient connect(boolean verbose, String oracleHome, String descriptionsBase, String instanceBase, List aggregateIDsAsList) throws CfwException {
        if (ClientConstants.SINGLETON_CLIENT) {
            if (_singleton == null) {
                _singleton = new CfwClient(verbose, oracleHome, descriptionsBase, instanceBase, aggregateIDsAsList);
            }
            CfwClient._singleton.isDisconnected = false;
            return _singleton;
        }
        return new CfwClient(verbose, oracleHome, descriptionsBase, instanceBase, aggregateIDsAsList);
    }

    public CfwSession begin() throws CfwException {
        if (this.isDisconnected) {
            throw new CfwException("The client is not connected.");
        }
        CfwSession session = CfwSession.newSession(this.cfmFactory);
        this.sessionHash.put(session.getSessionID(), session);
        return session;
    }

    public void end(CfwSession session) throws CfwException {
        if (session == null) {
            return;
        }
        String sessionID = session.getSessionID();
        if (sessionID == null) {
            return;
        }
        session.endSession();
        this.sessionHash.remove(sessionID);
    }

    public static void resetCfw() {
        if (ClientConstants.SINGLETON_CLIENT) {
            _singleton = null;
        }
    }

    protected CfwClient(boolean debugB, List aggregateIDsAsList) throws CfwException {
        this(debugB, null, null, null, aggregateIDsAsList);
    }

    protected CfwClient(boolean debugB, String oracleHome, String descriptionsBase, String instanceBase, List aggregateIDsAsList) throws CfwException {
        debug = debugB;
        this.cfmFactory = CfmFactory.connect(debugB, oracleHome, descriptionsBase, instanceBase, aggregateIDsAsList);
    }

    public void disconnect() {
        if (this.isDisconnected) {
            return;
        }
        Enumeration e = this.sessionHash.elements();
        while (e.hasMoreElements()) {
            CfwSession session = (CfwSession)e.nextElement();
            session.endSession();
        }
        CfmFactory.disconnect();
        this.isDisconnected = true;
    }

    protected void finalize() {
        if (!this.isDisconnected) {
            cfwLogger.log(Level.WARNING, "A CfwClient was destroyed without a proper call to disconnect!");
            this.disconnect();
        }
    }
}

