/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class Utils {
    private static Hashtable<String, InetAddress> m_nodeIPAddressMap = new Hashtable();
    public static final String EXADATA_CHECK_FILE = "/etc/oracle/cell/network-config/cellip.ora";
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private static MessageBundle m_msgBundle_prku = MessageBundle.getMessageBundle("Prku");
    private static boolean m_isODAEnvChecked = false;
    private static boolean m_isODAEnv = false;
    private static final String YODA_IN_BMC_COMMAND = "/bin/cat /proc/cmdline";
    private static boolean m_isYodaInBMCEnvChecked = false;
    private static boolean m_isYodaInBMCEnv = false;
    private static final String[] ODA_FILE_ARR = new String[]{"/opt/oracle/oak", "/opt/oracle/extapi/64/liboak.*.so", "/opt/oracle/extapi/64/oak/liboak.*.so"};
    private static final int CLOUD_URL_TIME_OUT = 5000;
    private static final String EXADATA_CLOUD_URL = "http://169.254.169.254/opc/v1/instance/";
    private static final String EXADATA_CLOUD_ID_STR = "ocid1.instance.";
    private static boolean m_exadataOnCloudChecked = false;
    private static boolean m_exadataOnCloud = false;

    private Utils() {
    }

    public static synchronized String getString(String[] sArray, String separator) {
        if (sArray == null) {
            return null;
        }
        StringBuffer sb = null;
        if (sArray.length > 0) {
            for (int i = 0; i < sArray.length; ++i) {
                if (i > 0) {
                    sb.append(separator + sArray[i]);
                    continue;
                }
                sb = new StringBuffer(sArray[i]);
            }
        } else {
            sb = new StringBuffer();
        }
        return sb.toString();
    }

    public static synchronized String getString(Collection strList, String separator) {
        int i = 0;
        if (null == strList) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String str : strList) {
            Trace.out("==========Str is " + str);
            if (0 == i++) {
                sb.append(str);
                continue;
            }
            sb.append(separator + str);
        }
        return sb.toString();
    }

    public static synchronized String[] getStringArray(String mString, String separator) {
        if (mString == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(mString, separator);
        String[] sArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            sArray[i++] = st.nextToken();
        }
        return sArray;
    }

    public static synchronized String getPropertyValue(String fileName, String propName, boolean ignoreCase) throws FileNotFoundException, IOException {
        String propValue;
        block7: {
            propValue = null;
            BufferedReader reader = null;
            try {
                String keyName;
                String line;
                Properties props = Utils.loadProperties(fileName);
                reader = new BufferedReader(new FileReader(fileName));
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf(File.separator) == -1) continue;
                    StringTokenizer st = new StringTokenizer(line, "=");
                    keyName = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    propValue = st.nextToken().trim();
                    Trace.out("keyName=" + keyName + " props.val=" + props.getProperty(keyName) + " propValue=" + propValue);
                    props.setProperty(keyName, propValue);
                }
                propValue = null;
                StringTokenizer st1 = new StringTokenizer(propName);
                if (!ignoreCase && st1.countTokens() == 1) {
                    propValue = props.getProperty(propName);
                    break block7;
                }
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    keyName = (String)e.nextElement();
                    st1 = new StringTokenizer(propName);
                    StringTokenizer st2 = new StringTokenizer(keyName);
                    if (st1.countTokens() != st2.countTokens()) continue;
                    boolean propMatched = true;
                    while (st1.hasMoreTokens()) {
                        String token1 = st1.nextToken().trim();
                        String token2 = st2.nextToken().trim();
                        propMatched &= ignoreCase ? token1.equalsIgnoreCase(token2) : token1.equals(token2);
                    }
                    if (!propMatched) continue;
                    propValue = props.getProperty(keyName);
                    break;
                }
            }
            catch (FileNotFoundException e) {
                Trace.out(e);
                throw e;
            }
            catch (IOException e) {
                Trace.out(e);
                throw e;
            }
        }
        Trace.out("propName=" + propName + " propValue=" + propValue);
        return propValue;
    }

    public static Properties loadProperties(String filePathname) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        Utils.extractPropertiesFromFile(properties, filePathname);
        return properties;
    }

    private static void extractPropertiesFromFile(Properties properties, String filePathname) throws FileNotFoundException, IOException {
        String currLine;
        int BUFFER_SIZE = 1024;
        Object END_OF_STREAM = null;
        String COMMENT_IDENTIFIER = "#";
        BufferedInputStream bufInStream = new BufferedInputStream(new FileInputStream(filePathname), 1024);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufInStream));
        while ((currLine = bufferedReader.readLine()) != END_OF_STREAM) {
            int indexOfEqualsSymbol;
            if ((currLine = currLine.trim()).equals("") || currLine.startsWith("#") || (indexOfEqualsSymbol = currLine.indexOf("=")) == -1) continue;
            String propertyName = currLine.substring(0, indexOfEqualsSymbol).trim();
            String propertyValue = currLine.substring(indexOfEqualsSymbol + 1).trim();
            properties.setProperty(propertyName, propertyValue);
        }
        bufInStream.close();
        bufferedReader.close();
    }

    public static String getLocalHost() throws UnknownHostException {
        String hostName = null;
        String longHostName = InetAddress.getLocalHost().getHostName();
        int dotIdx = longHostName.indexOf(".");
        hostName = dotIdx != -1 ? longHostName.substring(0, dotIdx) : longHostName;
        Trace.out("Hostname retrieved: " + longHostName + ", returned: " + hostName);
        return hostName;
    }

    public static boolean isODAEnvironment() {
        if (!m_isODAEnvChecked) {
            m_isODAEnvChecked = true;
            for (String file : ODA_FILE_ARR) {
                File oDAFile = new File(file);
                m_isODAEnv = oDAFile.exists();
                if (!m_isODAEnv) {
                    String fileName = oDAFile.getName();
                    File directory = new File(oDAFile.getParent());
                    if (directory.exists()) {
                        Pattern p = Pattern.compile(fileName);
                        File[] fileList = directory.listFiles();
                        if (fileList != null && fileList.length > 0) {
                            for (File f : fileList) {
                                String name = f.getName();
                                Trace.out("Checking File (" + name + ")");
                                Matcher matcher = p.matcher(name);
                                if (!matcher.find()) continue;
                                Trace.out("ODA file (" + file + ") exists. This is an ODA env.");
                                m_isODAEnv = true;
                                break;
                            }
                        }
                    }
                }
                if (!m_isODAEnv) continue;
                Trace.out("This is an ODA environment. Returning true.");
                break;
            }
            if (!m_isODAEnv) {
                Trace.out("This is not an ODA environment. Returning false.");
            }
        } else {
            Trace.out("Already checked if an ODA environment. Returning from cache.");
        }
        return m_isODAEnv;
    }

    public static synchronized boolean isBareMetalCloud() {
        NativeSystem system = new SystemFactory().CreateSystem();
        if (system.isUnixSystem() && !m_exadataOnCloudChecked) {
            m_exadataOnCloudChecked = true;
            try {
                URL exadataOnCloudURL = new URL(EXADATA_CLOUD_URL);
                URLConnection exadataURLConn = exadataOnCloudURL.openConnection();
                exadataURLConn.setConnectTimeout(5000);
                exadataURLConn.setReadTimeout(5000);
                BufferedReader inStream = new BufferedReader(new InputStreamReader(exadataURLConn.getInputStream()));
                String lineStr = null;
                LinkedList<String> outPutLines = new LinkedList<String>();
                while ((lineStr = inStream.readLine()) != null) {
                    outPutLines.add(lineStr);
                }
                for (String line : outPutLines) {
                    String[] split;
                    Trace.out("Processing line (" + line + ")");
                    if (!line.contains(":") || (split = line.split(":")).length <= 1) continue;
                    String key = split[0].trim();
                    String value = split[1].trim();
                    if (key.startsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    if (value.startsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if (!key.equals("id") || !value.startsWith(EXADATA_CLOUD_ID_STR)) continue;
                    Trace.out("Matching pattern found with Key (" + key + ")" + " Value (" + value + ")");
                    Trace.out("Detected Exadata on cloud. Returning true.");
                    m_exadataOnCloud = true;
                    return m_exadataOnCloud;
                }
            }
            catch (MalformedURLException mue) {
                Trace.out("Caught MalformedURLException " + mue.getMessage());
            }
            catch (IOException ioe) {
                Trace.out("Caught IOException " + ioe.getMessage());
                Trace.out("Expected the IOException in non an exadata cloud environment. Returning false.");
            }
        }
        return m_exadataOnCloud;
    }

    public static synchronized boolean isYodaInBMCEnvironment() {
        NativeSystem system = new SystemFactory().CreateSystem();
        if (system.isUnixSystem() && !m_isYodaInBMCEnvChecked) {
            String cmd = YODA_IN_BMC_COMMAND;
            RuntimeExec runtime = new RuntimeExec(NativeSystem.getCmdArr(cmd), null, null);
            int retVal = runtime.runCommand();
            String[] cmdOut = runtime.getOutput();
            StringBuffer msgBuf = new StringBuffer();
            for (int i = 0; i < cmdOut.length; ++i) {
                msgBuf.append(cmdOut[i] + "\n");
            }
            Trace.out("Command " + cmd + " output : " + msgBuf.toString());
            m_isYodaInBMCEnv = msgBuf.indexOf("ODA_IAAS") != -1 ? true : msgBuf.indexOf("LITE_IAAS") != -1;
            m_isYodaInBMCEnvChecked = true;
        }
        Trace.out("is YODA in BMC env: " + m_isYodaInBMCEnv);
        return m_isYodaInBMCEnv;
    }

    public static boolean isDevelopmentEnv() {
        try {
            return "TRUE".equalsIgnoreCase(System.getenv("_SCLS_DEVELOPMENT"));
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isHasInstallLRGEnv() {
        try {
            return "TRUE".equalsIgnoreCase(System.getenv("HAS_INSTALL_LRG_ENV"));
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getShortHostname(String longHostname) {
        if (longHostname == null) {
            return null;
        }
        int dotIdx = longHostname.indexOf(".");
        String hostName = dotIdx != -1 ? longHostname.substring(0, dotIdx) : longHostname;
        return hostName;
    }

    public static Set<String> getLocalHostAliasesFromNodeList(String[] nodeList) throws UnknownHostException {
        HashSet<String> aliasList = new HashSet<String>();
        String localHost = InetAddress.getLocalHost().getHostName();
        Trace.out("Local host name is (" + localHost + ")");
        InetAddress localNodeIP = Utils.getIPOfNode(localHost);
        for (String node : nodeList) {
            InetAddress nodeIP = Utils.getIPOfNode(node);
            Trace.out("IP of the node (" + node + ") is (" + nodeIP.getHostAddress() + ")");
            if (!nodeIP.equals(localNodeIP) || localHost.equalsIgnoreCase(node)) continue;
            Trace.out("The host (" + node + ") with IP " + nodeIP.getHostAddress() + " is pointing to local host " + localHost);
            aliasList.add(Utils.getShortHostname(node).toLowerCase());
        }
        return aliasList;
    }

    public static InetAddress getIPOfNode(String node) throws UnknownHostException {
        if (!m_nodeIPAddressMap.containsKey(node.toLowerCase())) {
            m_nodeIPAddressMap.put(node.toLowerCase(), InetAddress.getByName(node));
        }
        return m_nodeIPAddressMap.get(node.toLowerCase());
    }

    public static String getNodeName(String hostName) throws UnknownHostException {
        String nodeName = null;
        nodeName = Utils.getShortHostname(hostName).toLowerCase();
        Trace.out("Hostname : " + hostName + " is converted to nodeName : " + nodeName);
        return nodeName;
    }

    public static String getLocalNodeName() throws UnknownHostException {
        return Utils.getNodeName(Utils.getLocalHost());
    }

    public static boolean isSRVCTLInterruptTest() {
        StackTraceElement[] stack;
        for (StackTraceElement elem : stack = Thread.currentThread().getStackTrace()) {
            if (!elem.getClassName().contains("OPSCTLDriver")) continue;
            return Utils.isDevelopmentEnv() && "true".equalsIgnoreCase(System.getProperty("TEST_SRVCTL_CTRLC_PROPERTY"));
        }
        return false;
    }

    public static boolean isExadataEnv() throws ClusterUtilException, ClusterOperationException, ClusterException {
        ClusterCmd clusterCmd;
        boolean isPath = false;
        String[] nodeList = null;
        nodeList = new ClusterUtil().getActiveNodes();
        if (nodeList.length > 0 && (clusterCmd = new ClusterCmd()).pathExists(nodeList, EXADATA_CHECK_FILE, 2)) {
            isPath = true;
        }
        return isPath;
    }

    public static void assertInputNotNull(Object input, String argName) throws ClusterException {
        if (input == null) {
            Trace.out("Exception thrown because " + argName + " was null.");
            throw new ClusterException(s_msgBundle.getMessage("1179", true, new String[]{argName}));
        }
    }

    public static void assertInput(String input, String argName) throws ClusterException {
        if (input == null || input.isEmpty()) {
            Trace.out("Exception thrown because " + argName + " was null or empty.");
            throw new ClusterException(s_msgBundle.getMessage("1179", true, new String[]{argName}));
        }
    }

    public static String[] getRemoteNodes(String[] nodeList) throws ClusterException, UnknownHostException {
        Utils.assertInputNotNull(nodeList, "nodeList");
        Vector<String> remoteNodes = new Vector<String>();
        InetAddress localHost = InetAddress.getLocalHost();
        for (String nodeName : nodeList) {
            InetAddress node = InetAddress.getByName(nodeName);
            if (localHost.equals(node)) continue;
            remoteNodes.add(nodeName);
        }
        return remoteNodes.toArray(new String[0]);
    }

    public static void validateHostNames(List<String> hosts) throws ClusterException {
        Utils.assertInputNotNull(hosts, "Utils-validateHostNames-1");
        ArrayList<String> invalidHosts = new ArrayList<String>();
        for (String host : hosts) {
            Trace.out((Object)"validating host %s ...", host);
            try {
                InetAddress.getByName(host);
            }
            catch (UnknownHostException uhe) {
                Trace.out(uhe);
                invalidHosts.add(host);
                continue;
            }
            Trace.out("host was resolvable");
            if (!host.contains(String.valueOf('_'))) continue;
            Trace.out("hostname contained underscore");
            invalidHosts.add(host);
        }
        if (!invalidHosts.isEmpty()) {
            String errStr = ((Object)invalidHosts).toString();
            Trace.out((Object)"invalid hosts are %s", errStr);
            throw new ClusterException(m_msgBundle_prku.getMessage("1064", true, new String[]{errStr.substring(1, errStr.length() - 1)}));
        }
    }

    public static boolean useTomcat() {
        String useTomcat = System.getenv("SRVM_USE_TOMCAT");
        return useTomcat == null ? true : useTomcat.equalsIgnoreCase("true");
    }

    public static boolean validateGroupValue(String val) {
        return val.matches("[A-Za-z0-9_]+");
    }

    public static boolean isHostLocal(String nodeName) throws ClusterException, UnknownHostException {
        Utils.assertInputNotNull(nodeName, "nodeName");
        InetAddress localHost = InetAddress.getLocalHost();
        InetAddress node = InetAddress.getByName(nodeName);
        return localHost.equals(node);
    }
}

