/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.util.resource.PrkuMsgID;

public class NestedException
extends Exception
implements PrkuMsgID {
    private Exception m_e;
    private int m_code;
    private String m_debugMsg;

    public NestedException(String facility, String key) {
        this(facility, key, (String[])null);
    }

    public NestedException(String facility, String key, Object[] args) {
        this(facility, key, args, (Exception)null);
    }

    public NestedException(String facility, String key, Object arg) {
        this(facility, key, NestedException.args(arg), (Exception)null);
    }

    public NestedException(String facility, String key, Exception causedBy) {
        this(facility, key, null, causedBy);
    }

    public NestedException(String facility, String key, Object arg, Exception causedBy) {
        this(facility, key, NestedException.args(arg), causedBy);
    }

    public NestedException(String facility, String key, Object[] args, Exception causedBy) {
        super(MessageBundle.getMessageBundle(facility).getMessage(key, true, args));
        this.m_e = causedBy;
    }

    public NestedException(String[] msgs) {
        super(Utils.getString(msgs, " "));
    }

    public NestedException(String msg) {
        super(msg);
    }

    public NestedException(String msg, Exception causedBy) {
        super(msg);
        this.m_e = causedBy;
    }

    public NestedException(String facility, String key, String[] msgs) {
        super(NestedException.compositeMsg(MessageBundle.getMessageBundle(facility).getMessage(key, true), msgs));
    }

    public NestedException(String facility, String key, Object[] args, String[] msgs) {
        super(NestedException.compositeMsg(MessageBundle.getMessageBundle(facility).getMessage(key, true, args), msgs));
    }

    private static Object[] args(Object argument) {
        Object[] args = new Object[]{argument};
        return args;
    }

    public void setDebugMessage(String debugMsg) {
        this.m_debugMsg = debugMsg;
    }

    public String getDebugMessage() {
        return this.m_debugMsg;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public int getCode() {
        return this.m_code;
    }

    private String getCompleteMessage() {
        String msg = super.getMessage();
        if (Trace.isLevelEnabled(16) && this.getDebugMessage() != null) {
            return msg + "(" + this.getDebugMessage() + ":[" + this.m_code + "])";
        }
        return msg;
    }

    public static String createSingleMsg(String[] msgs) {
        return Utils.getString(msgs, " ");
    }

    @Override
    public String getMessage() {
        if (this.m_e == null) {
            return this.getCompleteMessage();
        }
        return this.getCompleteMessage() + "\n" + this.m_e.getMessage();
    }

    public static String compositeMsg(String mainMsg, String[] moreMsgs) {
        if (moreMsgs != null) {
            return mainMsg + Utils.getString(moreMsgs, System.getProperty("line.separator"));
        }
        return mainMsg;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private String getCausedByString() {
        return MessageBundle.getMessageBundle("Prku").getMessage("1000", false);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.m_e != null) {
            out.println(this.getCausedByString());
            this.m_e.printStackTrace(out);
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.m_e != null) {
            out.println(this.getCausedByString());
            this.m_e.printStackTrace(out);
        }
    }
}

