/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;

public class CmdLineParser {
    Hashtable m_flags = new Hashtable();
    Hashtable m_params = new Hashtable();
    Vector m_args = new Vector();
    String m_optionChar;
    Vector m_flagList = new Vector();
    Vector m_reqParamList;
    Vector m_optParamList;
    String[] m_parseArgs;
    int m_idx;

    public CmdLineParser(String optionChar, String[] flags, String[] requiredParams) {
        this(optionChar, flags, requiredParams, null);
    }

    public CmdLineParser(String optionChar, String[] flags, String[] requiredParams, String[] optionalParams) {
        int i;
        this.m_optionChar = optionChar;
        if (flags == null) {
            flags = new String[]{};
        }
        this.m_flagList = new Vector(flags.length);
        for (i = 0; i < flags.length; ++i) {
            this.m_flagList.addElement(flags[i]);
        }
        if (requiredParams == null) {
            requiredParams = new String[]{};
        }
        this.m_reqParamList = new Vector();
        for (i = 0; i < requiredParams.length; ++i) {
            this.m_reqParamList.addElement(requiredParams[i]);
        }
        if (optionalParams == null) {
            optionalParams = new String[]{};
        }
        this.m_optParamList = new Vector();
        for (i = 0; i < optionalParams.length; ++i) {
            this.m_optParamList.addElement(optionalParams[i]);
        }
    }

    private boolean isAnOption(String token) {
        return token.startsWith(this.m_optionChar);
    }

    private boolean isAFlag(String flag) {
        return this.m_flagList.indexOf(flag) != -1;
    }

    private boolean isAParam(String param) {
        return this.m_reqParamList.indexOf(param) != -1 || this.m_optParamList.indexOf(param) != -1;
    }

    private void throwOptionMustHaveArgument(String option) throws ParamMissingArgumentException {
        throw new ParamMissingArgumentException(option);
    }

    private void startParse(String[] args) {
        this.m_parseArgs = args;
        this.m_idx = 0;
    }

    private boolean hasMoreTokens() {
        return this.m_idx < this.m_parseArgs.length;
    }

    private String nextToken() {
        return this.m_parseArgs[this.m_idx++];
    }

    public void parse(String[] args) throws UnexpectedArgumentException, MissingArgumentException, ParamMissingArgumentException {
        this.parseAllArgs(args, false);
    }

    public void parseAllArgs(String[] args, boolean okUAEArgs) throws UnexpectedArgumentException, MissingArgumentException, ParamMissingArgumentException {
        this.startParse(args);
        while (this.hasMoreTokens()) {
            String token = this.nextToken();
            String option = token.substring(1);
            if (!this.isAnOption(token)) {
                this.m_args.addElement(token);
                continue;
            }
            if (this.isAFlag(option)) {
                this.m_flags.put(option, new Boolean(true));
                continue;
            }
            if (this.isAParam(option)) {
                if (this.hasMoreTokens()) {
                    String arg = this.nextToken();
                    if (this.isAnOption(arg)) {
                        this.throwOptionMustHaveArgument(token);
                        continue;
                    }
                    this.m_params.put(token.substring(1), arg);
                    continue;
                }
                this.throwOptionMustHaveArgument(token);
                continue;
            }
            if (okUAEArgs) continue;
            throw new UnexpectedArgumentException(token);
        }
        for (int i = 0; i < this.m_reqParamList.size(); ++i) {
            if (this.m_params.get(this.m_reqParamList.elementAt(i)) != null) continue;
            throw new MissingArgumentException((String)this.m_reqParamList.elementAt(i));
        }
    }

    public boolean getFlag(String flag) {
        return this.m_flags.get(flag) == null ? false : (Boolean)this.m_flags.get(flag);
    }

    public String getParam(String param) {
        return (String)this.m_params.get(param);
    }

    public int getNumberOfArguments() {
        return this.m_args.size();
    }

    public String[] getArguments() {
        int len = this.m_args.size();
        String[] args = new String[len];
        for (int i = 0; i < len; ++i) {
            args[i] = (String)this.m_args.elementAt(i);
        }
        return args;
    }
}

