/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import oracle.cluster.checkpoints.CheckPoint;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.checkpoints.CheckPointFactory;
import oracle.cluster.checkpoints.CheckPointIndexSession;
import oracle.cluster.checkpoints.CheckPointProperty;
import oracle.cluster.checkpoints.CheckPointSession;
import oracle.cluster.impl.checkpoints.CheckPointSessionImpl;
import oracle.cluster.impl.checkpoints.CheckPointUtil;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.ClusterwareCkptException;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;
import oracle.ops.util.Utils;

public class ClusterwareCkpt {
    static final String HELP_H = "h";
    static final String HELP = "help";
    static final String OPT_CKPT = "ckpt";
    static final String OPT_OBASE = "oraclebase";
    static final String OPT_NODELIST = "nodelist";
    static final String OPT_CHECK = "chkckpt";
    static final String OPT_WRITE = "writeckpt";
    static final String OPT_LIST = "listckpt";
    static final String OPT_NAME = "name";
    static final String OPT_DESC = "desc";
    static final String OPT_LEVEL = "level";
    static final String OPT_STATE = "state";
    static final String OPT_PNAME = "pname";
    static final String OPT_PVALUE = "pvalue";
    static final String OPT_PFILE = "pfile";
    static final String OPT_STATUS = "status";
    static final String OPT_GLOBAL = "global";
    static final String OPT_TRANSFER_FILE = "transferfile";
    static final String OPT = "-";
    private final String CRS_CKPT_MODULE_NAME = "crsconfig";
    private final String CRS_CKPT_CRSDATA = "crsdata";
    private final String CRS_CKPT_GLOBAL_DIR = "@global";
    private final String CRS_CKPT_FILE_NAME = "ckptGridHA";
    private final String CRS_CKPT_FILE_EXT = ".xml";
    private final String NOT_EXISTS = "NOT_EXISTS";
    private static final String[] FLAGS = new String[]{"h", "help", "ckpt", "chkckpt", "listckpt", "writeckpt", "status", "global", "transferfile"};
    private static final String[] REQ_PARAMS = new String[]{"oraclebase"};
    private static final String[] OPT_PARAMS = new String[]{"nodelist", "name", "desc", "state", "level", "pname", "pvalue", "pfile", "global", "transferfile"};
    private static final String[] REQ_CHECK_PARAMS = new String[]{"oraclebase", "name"};
    private static final String[] REQ_CHECK_OPT_PARAMS = new String[]{"nodelist", "pname", "global"};
    private static final String[] REQ_WRITE_PARAMS = new String[]{"oraclebase", "name"};
    private static final String[] REQ_WRITE_OPT_PARAMS = new String[]{"nodelist", "desc", "state", "global", "level", "pname", "pvalue", "pfile"};
    public static final String ROLLBACK = "rollback";
    private static String fileSeparator = System.getProperty("file.separator");
    private static String lineSeparator = System.getProperty("line.separator");
    private String m_ckptBase = null;
    private boolean m_ckptGlobal = false;
    private String m_nodeList = null;
    private String m_localhost = null;
    private String m_ckptFilePath = null;
    private String m_ckptFileName = null;
    private boolean m_transferFile = false;
    private static MessageBundle m_msgUBundle = MessageBundle.getMessageBundle("Prku");

    public ClusterwareCkpt() throws ClusterwareCkptException {
        try {
            this.m_localhost = Utils.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out("UnknownHostException caught");
            throw new ClusterwareCkptException(uhe.getMessage(), uhe);
        }
        this.m_ckptFileName = "ckptGridHA_" + this.m_localhost.toLowerCase() + ".xml";
        this.m_ckptFilePath = "crsdata" + fileSeparator + this.m_localhost.toLowerCase() + fileSeparator + "crsconfig";
    }

    public ClusterwareCkpt(String ckptBase, String ckptFilePath, String ckptFileName) throws ClusterwareCkptException {
        this(ckptBase, ckptFilePath, ckptFileName, false);
    }

    public ClusterwareCkpt(String ckptBase, String ckptFilePath, String ckptFileName, boolean ckptGlobal) throws ClusterwareCkptException {
        Trace.out("Entering new ckpt init");
        try {
            this.m_localhost = Utils.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out("UnknownHostException caught");
            throw new ClusterwareCkptException(uhe.getMessage(), uhe);
        }
        this.m_ckptBase = ckptBase;
        this.m_ckptFileName = ckptFileName;
        this.m_ckptFilePath = ckptFilePath;
        this.m_ckptGlobal = ckptGlobal;
    }

    public void setCkptBase(String ckptBase) {
        this.m_ckptBase = ckptBase;
    }

    public String getCkptBase() {
        return this.m_ckptBase;
    }

    public void setCkptGlobal(boolean ckptGlobal) {
        this.m_ckptGlobal = ckptGlobal;
    }

    public boolean getCkptGlobal() {
        return this.m_ckptGlobal;
    }

    public void setNodeList(String nodeList) {
        this.m_nodeList = nodeList;
    }

    public String getNodeList() {
        return this.m_nodeList;
    }

    public String getCkptIdxSessionBase() {
        String ckptIdxSessionBase = CheckPointUtil.concatPath(this.m_ckptBase, this.m_localhost.toLowerCase());
        if (this.m_ckptGlobal) {
            ckptIdxSessionBase = this.m_ckptBase;
        }
        return ckptIdxSessionBase;
    }

    public String getCkptFileLoc() {
        String ckptFileName = this.m_ckptFileName;
        String ckptFilePath = this.m_ckptFilePath;
        if (this.m_ckptGlobal) {
            ckptFileName = "ckptGridHA_global.xml";
            ckptFilePath = "crsdata" + fileSeparator + "@global" + fileSeparator + "crsconfig";
        }
        String ckptFileLoc = this.m_ckptBase + fileSeparator + ckptFilePath + fileSeparator + ckptFileName;
        Trace.out("ckpt file location is " + ckptFileLoc);
        return ckptFileLoc;
    }

    private CmdLineParser parseArgs(String opt, String[] flags, String[] reqParams, String[] optParams, String[] args) throws ClusterwareCkptException {
        Trace.out("args = " + Utils.getString(args, ","));
        try {
            CmdLineParser parser = new CmdLineParser(opt, flags, reqParams, optParams);
            parser.parse(args);
            return parser;
        }
        catch (MissingArgumentException mae) {
            throw new ClusterwareCkptException(mae.getMessage(), mae);
        }
        catch (ParamMissingArgumentException pmae) {
            throw new ClusterwareCkptException(pmae.getMessage(), pmae);
        }
        catch (UnexpectedArgumentException uae) {
            throw new ClusterwareCkptException(uae.getMessage(), uae);
        }
    }

    public boolean isCkptExists(String ckptName) {
        Trace.out("Checking if checkpoint:" + ckptName + " exists");
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        CheckPoint ckpt = cps.getCheckPoint(ckptName.toUpperCase());
        Trace.out("ckpt = " + ckpt);
        return ckpt != null;
    }

    public String getCkptStatus(String ckptName) {
        Trace.out("Checking to see if checkpoint:" + ckptName + "has successfuly completed");
        try {
            ClusterwareCkpt.assertCkptName(ckptName);
        }
        catch (ClusterwareCkptException ckpte) {
            Trace.out(ckpte);
            return "NOT_EXISTS";
        }
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        StringBuffer outBuffer = new StringBuffer();
        Trace.out("Reading data for checkpoint: " + ckptName);
        CheckPoint ckpt = cps.getCheckPoint(ckptName);
        if (null != ckpt) {
            int state = ckpt.getCheckPointState();
            if (state == 3) {
                return "SUCCESS";
            }
            if (state == 2) {
                return "FAIL";
            }
            if (state == 1) {
                return "START";
            }
        }
        return "NOT_EXISTS";
    }

    public boolean isPropertyExists(String ckptName, String ckptPropertyName) {
        Trace.out("Checking checkpoint property:" + ckptPropertyName + " exists for checkpoint: " + ckptName);
        try {
            ClusterwareCkpt.assertCkptName(ckptName);
        }
        catch (ClusterwareCkptException ckpte) {
            Trace.out(ckpte);
            return false;
        }
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        CheckPoint ckpt = cps.getCheckPoint(ckptName.toUpperCase());
        if (ckpt == null) {
            return false;
        }
        CheckPointProperty ckptProp = ckpt.getCheckPointProperty(ckptPropertyName);
        if (Trace.isLevelEnabled(1)) {
            Trace.out("ckptProp = " + ckptProp);
        }
        if (ckptProp != null && ckptProp.getName().equals(ckptPropertyName)) {
            Trace.out("Checkpoint property: " + ckptPropertyName + " found");
            return true;
        }
        return false;
    }

    public String showCheckPoints(String ckptName, String ckptPropertyName) {
        Trace.out("Reading existing checkpoints data");
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        StringBuffer outBuffer = new StringBuffer();
        if (ckptName == null) {
            Trace.out("Reading all checkpoints");
            List ckpts = cps.getAllCheckPoints();
            if (ckpts != null) {
                CheckPoint ckpt = null;
                outBuffer.append("Checkpoints ---------->" + lineSeparator);
                ListIterator ckptIterator = ckpts.listIterator();
                while (ckptIterator.hasNext()) {
                    ckpt = (CheckPoint)ckptIterator.next();
                    outBuffer.append("Name=" + ckpt.getCheckPointName() + " ");
                    outBuffer.append("Desc=\"" + ckpt.getCheckPointDesc() + "\" ");
                    int state = ckpt.getCheckPointState();
                    if (state == 1) {
                        outBuffer.append("State=START");
                    } else if (state == 3) {
                        outBuffer.append("State=SUCCESS");
                    } else if (state == 2) {
                        outBuffer.append("State=FAIL");
                    }
                    outBuffer.append(lineSeparator);
                    ckpt = null;
                }
                Trace.out("Finished reading all checkpoints");
            } else {
                Trace.out("No checkpoints exists right now");
            }
        } else if (ckptName != null) {
            Trace.out("Reading data for checkpoint: " + ckptName);
            CheckPoint ckpt = cps.getCheckPoint(ckptName);
            if (ckptPropertyName == null && ckpt != null) {
                List ckptProps = ckpt.getAllCheckPointProperties();
                if (ckptProps != null) {
                    Trace.out("Reading all properties data for checkpoint: " + ckptName);
                    CheckPointProperty ckptProp = null;
                    outBuffer.append("Checkpoint properties for checkpoint name:" + ckptName + lineSeparator);
                    ListIterator propIterator = ckptProps.listIterator();
                    while (propIterator.hasNext()) {
                        ckptProp = (CheckPointProperty)propIterator.next();
                        outBuffer.append(ckptProp.getName() + "=");
                        outBuffer.append(ckptProp.getValue());
                        outBuffer.append(lineSeparator);
                        ckptProp = null;
                    }
                    Trace.out("Finished reading properties data for checkpoint: " + ckptName);
                }
            } else if (ckptPropertyName != null && ckpt != null) {
                Trace.out("Reading data for checkpoint: " + ckptName + " and checkpoint property: " + ckptPropertyName);
                CheckPointProperty ckptProp = ckpt.getCheckPointProperty(ckptPropertyName);
                if (ckptProp != null) {
                    Trace.out("Checkpoint properties for checkpoint name:<" + ckptName + "> and checkpoint property name: <" + ckptPropertyName + ">" + lineSeparator);
                    outBuffer.append(ckptProp.getName() + "=");
                    outBuffer.append(ckptProp.getValue());
                    outBuffer.append(lineSeparator);
                }
            }
        }
        Trace.out("Checkpoint data :" + lineSeparator + outBuffer.toString());
        return outBuffer.toString();
    }

    public void writeCheckPoint(String ckptName, String ckptDesc, String ckptLevelStr, String ckptStateStr) throws ClusterwareCkptException {
        Trace.out("Writing checkpoint");
        Trace.out("Ckpt Name: " + ckptName);
        Trace.out("Ckpt Desc: " + ckptDesc);
        Trace.out("Ckpt Level: " + ckptLevelStr);
        Trace.out("Ckpt State: " + ckptStateStr);
        ClusterwareCkpt.assertCkptName(ckptName);
        Trace.out("after assert of checkpoint name");
        if (ckptDesc == null || ckptDesc.length() == 0) {
            ckptDesc = ckptName;
        }
        int ckptLevel = this.getCkptLevel(ckptLevelStr);
        int ckptState = this.getCkptState(ckptStateStr);
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        Trace.out("ckpt debug 1");
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        Trace.out("ckpt debug 2");
        CheckPoint ckpt = cps.getCheckPoint(ckptName);
        Trace.out("ckpt debug 3");
        if (ckpt == null) {
            Trace.out("inside create new ckpt");
            ckpt = CheckPointFactory.constructCheckPoint(ckptLevel, ckptName, ckptDesc);
        } else {
            Trace.out("Setting checkpoint state to: " + ckptState);
            ckpt.setCheckPointState(ckptState);
        }
        Trace.out("ckpt debug 4");
        cps.addCheckPoint(ckpt);
        Trace.out("ckpt debug 5");
        cps.saveCheckPointSession();
        Trace.out("ckpt debug 6");
        this.propagateGlobalCheckpoint(cps);
    }

    private int getCkptLevel(String ckptLevel) {
        if (ckptLevel == null || ckptLevel.length() == 0 || ckptLevel.equalsIgnoreCase("MAJOR")) {
            return 1;
        }
        return 2;
    }

    private int getCkptState(String ckptState) {
        if (ckptState == null || ckptState.length() == 0 || ckptState.equalsIgnoreCase("START")) {
            return 1;
        }
        if (ckptState.equalsIgnoreCase("SUCCESS")) {
            return 3;
        }
        return 2;
    }

    public void writeCheckPointProperty(String ckptName, String propertyName, String propertyValue) throws ClusterwareCkptException {
        Trace.out("Writing property: " + propertyName + " with value: " + propertyValue);
        ClusterwareCkpt.assertCkptName(ckptName);
        ClusterwareCkpt.assertCkptName(propertyName);
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        CheckPointProperty ckptProperty = null;
        int ckptType = this.getPropertyType(propertyValue);
        String string = propertyValue = propertyValue == null ? "" : propertyValue;
        if (ckptType == 1) {
            ckptProperty = CheckPointFactory.constructStringProperty(propertyName, propertyValue);
        } else if (ckptType == 2) {
            ckptProperty = CheckPointFactory.constructNumericProperty(propertyName, new Integer(propertyValue));
        } else if (ckptType == 3) {
            ckptProperty = CheckPointFactory.constructStringProperty(propertyName, propertyValue);
        } else if (ckptType == 4) {
            ckptProperty = CheckPointFactory.constructStringProperty(propertyName, propertyValue);
        }
        CheckPoint ckpt = cps.getCheckPoint(ckptName);
        if (ckpt == null) {
            ckpt = CheckPointFactory.constructCheckPoint(1, ckptName, ckptName);
        }
        if (ckptProperty != null) {
            ckpt.addCheckPointProperty(ckptProperty);
        }
        cps.addCheckPoint(ckpt);
        cps.saveCheckPointSession();
        this.propagateGlobalCheckpoint(cps);
    }

    public void writeCheckPointProperty(String ckptName, String propertyFile) throws ClusterwareCkptException {
        Trace.out("Writing property file:" + propertyFile);
        ClusterwareCkpt.assertCkptName(ckptName);
        ClusterwareCkpt.assertFile(propertyFile);
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(this.getCkptFileLoc());
        CheckPoint ckpt = cps.getCheckPoint(ckptName);
        if (ckpt == null) {
            ckpt = CheckPointFactory.constructCheckPoint(1, ckptName, ckptName);
        }
        CheckPointProperty ckptProperty = null;
        BufferedReader bin = null;
        try {
            bin = new BufferedReader(new FileReader(propertyFile));
        }
        catch (FileNotFoundException fnfe) {
            throw new ClusterwareCkptException(fnfe.getMessage(), fnfe);
        }
        try {
            String propString;
            while ((propString = bin.readLine()) != null) {
                String[] property = Utils.getStringArray(propString, "=");
                if (Trace.isLevelEnabled(1)) {
                    Trace.out("Writing property: " + propString);
                }
                if (property.length != 2 || property[0].startsWith("#")) continue;
                String propertyName = property[0];
                String propertyValue = property[1];
                if (Trace.isLevelEnabled(1)) {
                    Trace.out("Writing property (" + propertyName + "=" + propertyValue);
                }
                if (propertyValue != null) {
                    int ckptType = this.getPropertyType(propertyValue);
                    if (ckptType == 1) {
                        ckptProperty = CheckPointFactory.constructStringProperty(propertyName, propertyValue);
                    } else if (ckptType == 2) {
                        ckptProperty = CheckPointFactory.constructNumericProperty(propertyName, new Integer(propertyValue));
                    } else if (ckptType == 3) {
                        ckptProperty = CheckPointFactory.constructStringProperty(propertyName, propertyValue);
                    } else if (ckptType == 4) {
                        ckptProperty = CheckPointFactory.constructStringProperty(propertyName, propertyValue);
                    }
                }
                if (ckptProperty == null) continue;
                ckpt.addCheckPointProperty(ckptProperty);
            }
        }
        catch (IOException ie) {
            throw new ClusterwareCkptException(ie.getMessage(), ie);
        }
        cps.addCheckPoint(ckpt);
        cps.saveCheckPointSession();
    }

    private int getPropertyType(String propertyValue) {
        if (propertyValue == null || propertyValue.length() == 0) {
            return 1;
        }
        StringTokenizer tokens = new StringTokenizer(propertyValue, ",");
        if (tokens.countTokens() > 1) {
            return 4;
        }
        if (propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false")) {
            return 3;
        }
        try {
            Integer oInt = new Integer(propertyValue);
            return 2;
        }
        catch (NumberFormatException nfe) {
            return 1;
        }
    }

    private void propagateGlobalCheckpoint(CheckPointSession ckptSession) throws ClusterwareCkptException {
        if (this.getCkptGlobal() && null != this.getNodeList() && this.getTransferFile()) {
            Trace.out("Propagating global checkpoints to nodes: " + this.getNodeList());
            ((CheckPointSessionImpl)ckptSession).setNodeList(this.getNodeList());
            try {
                Trace.out("Closing global checkpoint session");
                ckptSession.closeCheckPointSession();
            }
            catch (CheckPointException ckpte) {
                Trace.out(ckpte);
                throw new ClusterwareCkptException(ckpte.getMessage(), ckpte);
            }
        }
    }

    private String[] covertToStringArray(Object propertyValue) {
        StringTokenizer tokens = new StringTokenizer((String)propertyValue, ",");
        String[] strArray = new String[tokens.countTokens()];
        for (int i = 0; i < tokens.countTokens(); ++i) {
            strArray[i] = tokens.nextToken();
        }
        return strArray;
    }

    public void endCkptSession() throws ClusterwareCkptException {
        Trace.out("Closing Oracle Clusterware checkpoint session");
        String ckptFileLoc = this.getCkptFileLoc();
        File f = new File(ckptFileLoc);
        if (!f.exists()) {
            Trace.out("ckpt file does not exist");
            throw new ClusterwareCkptException(m_msgUBundle.getMessage("1062", true, new Object[]{ckptFileLoc}));
        }
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        CheckPointSession cps = cpis.initCheckPointSession(ckptFileLoc);
        try {
            cps.closeCheckPointSession();
        }
        catch (CheckPointException ckpte) {
            Trace.out(ckpte);
            throw new ClusterwareCkptException(ckpte.getMessage(), ckpte);
        }
        try {
            cpis.closeCheckPointIndexSession();
        }
        catch (CheckPointException ckpte) {
            Trace.out(ckpte);
            throw new ClusterwareCkptException(ckpte.getMessage(), ckpte);
        }
    }

    public void clearCkptCache() {
        String ckptfname = this.getCkptFileLoc();
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        Trace.out("Clearing checkpoint session cache for" + ckptfname);
        cpis.cleanCheckPointSession(ckptfname);
    }

    protected boolean hasFailedCkpts() {
        Trace.out("Checking for existence of failed checkpoints");
        CheckPointIndexSession cpis = CheckPointFactory.getIndexSession(this.getCkptIdxSessionBase(), "crsconfig", this.getCkptGlobal());
        Boolean bIndexFileExists = cpis.isIndexFileExists();
        Trace.out("Index file exists = " + bIndexFileExists);
        return bIndexFileExists;
    }

    protected String askResumeOrRollback() {
        Trace.out("Ask users intention of rollback or resume configuration");
        InputStreamReader isrStdin = new InputStreamReader(System.in);
        BufferedReader stdin = new BufferedReader(isrStdin);
        String mesg = "Oracle clusterware configuration on this node exists in failed state";
        String qtn = "Do you want to (Resume) or (Rollback)?";
        System.out.print(mesg);
        System.out.print(qtn);
        String response = ROLLBACK;
        try {
            response = stdin.readLine();
        }
        catch (IOException ie) {
            Trace.out("Error reading response");
        }
        Trace.out("User response = " + response);
        return response.toLowerCase();
    }

    static final void assertCkptName(String ckptName) throws ClusterwareCkptException {
        if (ckptName == null || ckptName.length() == 0) {
            throw new ClusterwareCkptException(m_msgUBundle.getMessage("1040", false));
        }
    }

    static final void assertFile(String file) throws ClusterwareCkptException {
        if (file == null || file.trim().length() == 0) {
            throw new ClusterwareCkptException(m_msgUBundle.getMessage("1041", false));
        }
    }

    public boolean getTransferFile() {
        return this.m_transferFile;
    }

    public void setTransferFile(boolean transferFile) {
        this.m_transferFile = transferFile;
    }

    public int executeCkpt(String[] args) {
        CmdLineParser parser = null;
        CmdLineParser parser2 = null;
        boolean ckptCheck = false;
        boolean ckptWrite = false;
        boolean ckptList = false;
        try {
            parser = this.parseArgs(OPT, FLAGS, REQ_PARAMS, OPT_PARAMS, args);
        }
        catch (ClusterwareCkptException cce) {
            if (parser != null && (parser.getFlag(HELP) || parser.getFlag(HELP_H))) {
                ClusterwareCkpt.showUsage();
                return 0;
            }
            System.err.println(cce);
            return 1;
        }
        if (parser.getFlag(HELP) || parser.getFlag(HELP_H)) {
            ClusterwareCkpt.showUsage();
            return 0;
        }
        String ckptBase = parser.getParam(OPT_OBASE);
        this.setCkptBase(ckptBase);
        String ckptName = parser.getParam(OPT_NAME);
        boolean ckptGlobal = parser.getFlag(OPT_GLOBAL);
        String ckptNodelist = parser.getParam(OPT_NODELIST);
        this.setTransferFile(parser.getFlag(OPT_TRANSFER_FILE));
        Trace.out("Parsed Arguments");
        if (Trace.isLevelEnabled(1)) {
            Trace.out("ckptBase = " + ckptBase);
            Trace.out("ckptName = " + ckptName);
            Trace.out("ckptGlobal = " + ckptGlobal);
            Trace.out("ckptNodelist = " + ckptNodelist);
        }
        if (ckptGlobal) {
            this.setCkptGlobal(true);
        }
        if (ckptNodelist != null) {
            this.setNodeList(ckptNodelist);
        }
        if (parser.getFlag(OPT_CHECK)) {
            ckptCheck = true;
            try {
                Trace.out("Processing chkckpt command line arguments");
                this.parseArgs(OPT, FLAGS, REQ_CHECK_PARAMS, REQ_CHECK_OPT_PARAMS, args);
            }
            catch (ClusterwareCkptException cce) {
                System.err.println(cce);
                return 1;
            }
        } else if (parser.getFlag(OPT_WRITE)) {
            ckptWrite = true;
            try {
                Trace.out("Processing writeckpt command line arguments");
                parser2 = this.parseArgs(OPT, FLAGS, REQ_WRITE_PARAMS, REQ_WRITE_OPT_PARAMS, args);
            }
            catch (ClusterwareCkptException cce) {
                Trace.out(cce);
                System.err.println(cce);
                return 1;
            }
        } else if (parser.getFlag(OPT_LIST)) {
            ckptList = true;
        }
        String ckptDesc = parser.getParam(OPT_DESC);
        String ckptLevel = parser.getParam(OPT_LEVEL);
        String ckptState = parser.getParam(OPT_STATE);
        String ckptPropName = parser.getParam(OPT_PNAME);
        String ckptPropValue = parser.getParam(OPT_PVALUE);
        String ckptPropFile = parser.getParam(OPT_PFILE);
        boolean ckptStatus = parser.getFlag(OPT_STATUS);
        if (Trace.isLevelEnabled(1)) {
            Trace.out("ckptDesc = " + ckptDesc);
            Trace.out("ckptLevel = " + ckptLevel);
            Trace.out("ckptState = " + ckptState);
            Trace.out("ckptPropName = " + ckptPropName);
            Trace.out("CkptPropValue = " + ckptPropValue);
            Trace.out("CkptPropFile = " + ckptPropFile);
            Trace.out("CkptStatus = " + ckptStatus);
        }
        if (ckptList) {
            System.out.print(this.showCheckPoints(ckptName, ckptPropName));
        } else if (ckptCheck) {
            if (ckptStatus) {
                System.out.println(this.getCkptStatus(ckptName).toUpperCase());
            } else if (ckptPropName != null) {
                System.out.println(this.isPropertyExists(ckptName, ckptPropName) ? "TRUE" : "FALSE");
            } else {
                System.out.println(this.isCkptExists(ckptName) ? "TRUE" : "FALSE");
            }
        } else if (ckptWrite) {
            if (ckptPropName != null) {
                try {
                    this.writeCheckPointProperty(ckptName, ckptPropName, ckptPropValue);
                }
                catch (ClusterwareCkptException ckpte) {
                    Trace.out(ckpte);
                    return 1;
                }
            }
            if (ckptPropFile != null) {
                try {
                    this.writeCheckPointProperty(ckptName, ckptPropFile);
                }
                catch (ClusterwareCkptException ckpte) {
                    Trace.out(ckpte);
                    return 1;
                }
            }
            try {
                this.writeCheckPoint(ckptName, ckptDesc, ckptLevel, ckptState);
            }
            catch (ClusterwareCkptException ckpte) {
                Trace.out(ckpte);
                return 1;
            }
        }
        return 0;
    }

    public static void showUsage() {
        System.out.println("\nckpt args:\n\t-oraclebase <oracle_base> [ -global ]\n\t[ -listckpt [ -name <name> [ -pname <property_name> ] ] ] |\n\t[ -chkckpt -name <name> [ -pname <property_name> | -status ] ] |\n\t[ -writeckpt -name <name> { ( -pname <property_name> -pvalue <property_value> ) | -pfile <property_file> | ( [ -desc <description> ] [ -level <MAJOR | MINOR> ] [ -state <START | SUCCESS | FAIL> ] ) } ]");
    }
}

