/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.ClusterCheckUtil;
import oracle.ops.util.ClusterExecUtil;
import oracle.ops.util.ClusterFileUtil;
import oracle.ops.util.ClusterwareCkpt;
import oracle.ops.util.ClusterwareCkptException;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;

public class ClusterUtil {
    public static final String OPT = "-";
    public static final String COPY = "copy";
    public static final String CKPT = "ckpt";
    public static final String ISSHR = "chkshare";
    public static final String EXEC = "exec";
    public static final String H = "h";
    public static final String HELP = "help";
    public static final String RM_FILE = "rmfile";
    public static final String IS_IPV6 = "isipv6";
    public static final String[] PARAMS = new String[0];
    public static final String[] OPTIONAL = new String[]{"copy", "ckpt", "chkshare", "exec", "h", "help", "rmfile", "isipv6"};
    public static final String[] FLAGS = new String[]{"copy", "ckpt", "chkshare", "exec", "h", "help", "rmfile", "isipv6"};
    static final String COMMA = ",";
    private static final String TRACE_FILE_VAR = "ORA_CLUUTIL_TRACE_FILE";
    private static final String TRACE_NATIVE_VAR = "SRVM_NATIVE_TRACE";
    private static final String TRACE_JNI_VAR = "SRVM_JNI_TRACE";
    private static final String TRACE_FILE_DEFAULT = "clusterExecUtil.log";
    private static final String TMPDIR_VAR = "TMPDIR";
    private static final String TMPDIR_PROPERTY = "java.io.tmpdir";
    private static final String FALSE = "false";
    private boolean m_copy;
    private boolean m_ckpt;
    private boolean m_isshared;
    private boolean m_exec;
    private boolean m_rmFile;
    private boolean m_help;
    private boolean m_isIPv6;
    private String m_destFileLocation = null;
    private String[] m_destNodeList = null;

    public void parseArgs(String[] args) throws ClusterException {
        CmdLineParser cmdParser = new CmdLineParser(OPT, FLAGS, PARAMS, OPTIONAL);
        try {
            cmdParser.parseAllArgs(args, true);
        }
        catch (MissingArgumentException mae) {
            throw new ClusterException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new ClusterException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            Trace.out(uae.getMessage());
        }
        this.m_ckpt = cmdParser.getFlag(CKPT);
        this.m_copy = cmdParser.getFlag(COPY);
        this.m_isshared = cmdParser.getFlag(ISSHR);
        this.m_exec = cmdParser.getFlag(EXEC);
        this.m_rmFile = cmdParser.getFlag(RM_FILE);
        this.m_isIPv6 = cmdParser.getFlag(IS_IPV6);
        this.m_help = cmdParser.getFlag(H) || cmdParser.getFlag(HELP);
        Trace.out("m_ckpt=" + this.m_ckpt);
        Trace.out("m_copy=" + this.m_copy);
        Trace.out("m_isshared=" + this.m_isshared);
        Trace.out("m_exec=" + this.m_exec);
        Trace.out("m_rmFile=" + this.m_rmFile);
        Trace.out("m_help=" + this.m_help);
    }

    public int execute(String[] args) throws ClusterwareCkptException {
        if (!this.m_help) {
            if (this.m_isshared) {
                ClusterCheckUtil ClusterCheckUtil2 = new ClusterCheckUtil();
                return ClusterCheckUtil2.executeChkShare(args);
            }
            if (this.m_ckpt) {
                ClusterwareCkpt ClusterwareCkpt2 = new ClusterwareCkpt();
                return ClusterwareCkpt2.executeCkpt(args);
            }
            if (this.m_exec) {
                ClusterExecUtil ClusterExecUtil2 = new ClusterExecUtil();
                return ClusterExecUtil2.executeCmd(args);
            }
            if (this.m_rmFile) {
                ClusterFileUtil ClusterFileUtil2 = new ClusterFileUtil();
                return ClusterFileUtil2.executeRmFile(args);
            }
            if (this.m_copy) {
                ClusterFileUtil ClusterFileUtil3 = new ClusterFileUtil();
                return ClusterFileUtil3.executeCopy(args);
            }
            if (this.m_isIPv6) {
                ClusterCheckUtil ClusterCheckUtil3 = new ClusterCheckUtil();
                return ClusterCheckUtil3.executeChkIPv6(args);
            }
            Trace.out("No verb passed");
        }
        this.usage();
        return 0;
    }

    static String[] getNodeListArray(String nodes) throws ClusterException {
        StringTokenizer tokenizer = new StringTokenizer(nodes, COMMA);
        String[] nodeList = new String[tokenizer.countTokens()];
        int i = 0;
        try {
            while (tokenizer.hasMoreElements()) {
                nodeList[i++] = tokenizer.nextToken();
            }
        }
        catch (NoSuchElementException nex) {
            throw new ClusterException("Error in parsing nodelist: " + nodes + nex.toString());
        }
        return nodeList;
    }

    public static String[] findLiveNodes(String[] nodeList) {
        boolean ret = false;
        String[] liveNodeList = null;
        ClusterCmd clsCmd = new ClusterCmd();
        try {
            Trace.out("Attempt to find live nodes");
            ret = clsCmd.areNodesAlive(nodeList, 10, null);
        }
        catch (ClusterException ce) {
            Trace.out("All nodes are down: " + ce.getMessage());
        }
        catch (RemoteFileOperationException re) {
            ArrayList<String> liveNodes = new ArrayList<String>();
            for (int i = 0; i < nodeList.length; ++i) {
                try {
                    NativeResult nr = re.getNativeResult(nodeList[i]);
                    if (nr.getBooleanResult()) {
                        Trace.out(nodeList[i] + " can be reached from local node");
                        liveNodes.add(nodeList[i]);
                        continue;
                    }
                    Trace.out(nodeList[i] + " unreachable from local node");
                    continue;
                }
                catch (NoSuchNodeException ne) {
                    Trace.out("NOSUCHNODEEXCEPTION: " + ne.getMessage() + "\n" + Trace.getStackTrace(ne));
                }
            }
            liveNodeList = new String[liveNodes.size()];
            liveNodes.toArray(liveNodeList);
        }
        if (ret) {
            Trace.out("All nodes are up");
            liveNodeList = nodeList;
        }
        return liveNodeList;
    }

    public static void main(String[] args) {
        if (Trace.isTraceEnabled()) {
            String jniTrace;
            String traceFileName = System.getenv(TRACE_FILE_VAR);
            if (traceFileName != null && traceFileName.length() != 0) {
                Trace.enableLogging(traceFileName, true);
            } else {
                Trace.enableLogging(TRACE_FILE_DEFAULT, true);
            }
            String nativeTrace = System.getenv(TRACE_NATIVE_VAR);
            if (nativeTrace != null && !nativeTrace.isEmpty() && !nativeTrace.equalsIgnoreCase(FALSE)) {
                Trace.nativeTraceEnabled(true);
            }
            if ((jniTrace = System.getenv(TRACE_JNI_VAR)) != null && !jniTrace.isEmpty() && !jniTrace.equalsIgnoreCase(FALSE)) {
                Trace.JNITraceEnabled(true);
            }
        }
        Trace.out("Trace enabled");
        try {
            SRVMContext srvmContext = SRVMContext.getInstance();
            srvmContext.init();
        }
        catch (SRVMContextException srce) {
            Trace.out(srce);
            ClusterUtil.exit(1);
        }
        ClusterUtil clusterUtil = new ClusterUtil();
        String tmpDir = System.getenv(TMPDIR_VAR);
        if (null != tmpDir) {
            System.setProperty(TMPDIR_PROPERTY, tmpDir);
        }
        try {
            clusterUtil.parseArgs(args);
        }
        catch (ClusterException cex) {
            Trace.out(cex);
            System.out.println(cex.toString());
            clusterUtil.usage();
            ClusterUtil.exit(1);
        }
        try {
            int rc = clusterUtil.execute(args);
            Trace.out("ClusterUtil.execute rc: " + rc);
            ClusterUtil.exit(rc);
        }
        catch (ClusterwareCkptException cpx) {
            Trace.out(cpx);
            ClusterUtil.exit(1);
        }
    }

    private static void exit(int exitValue) {
        Trace.close();
        System.exit(exitValue);
    }

    public void usage() {
        System.out.println("usage: cluutil { -copy <args> | -ckpt <args> | -chkshare <args> | -exec <args> | -rmfile <args>  | -isipv6 <ip> } ");
        if (this.m_isshared) {
            ClusterCheckUtil.usageChkShare();
        } else if (this.m_ckpt) {
            ClusterwareCkpt.showUsage();
        } else if (this.m_exec) {
            ClusterExecUtil.usage();
        } else if (this.m_rmFile) {
            ClusterFileUtil.usageRmFile();
        } else if (this.m_copy) {
            ClusterFileUtil.usageCopyFile();
        } else if (this.m_isIPv6) {
            ClusterCheckUtil.usageChkIPv6();
        } else {
            Trace.out("No verb passed");
        }
    }
}

