/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;
import oracle.ops.util.Utils;

public class ClusterCheckUtil {
    public static final String OPT = "-";
    public static final String OHOME = "oh";
    public static final String LOCALNODE = "localnode";
    public static final String NODELIST = "nodelist";
    public static final String OPT_SHR = "chkshare";
    public static final String OPT_IPV6 = "isipv6";
    public static final String[] SHR_PARAMS = new String[]{"oh", "nodelist", "localnode"};
    public static final String[] SHR_OPTIONAL = new String[0];
    public static final String[] FLAGS = new String[]{"chkshare"};
    static final String COMMA = ",";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private String m_localNode = null;
    private String[] m_NodeList = null;
    private String m_ohome = null;
    private String m_ip = null;

    private void parseChkShareArgs(String[] args) throws ClusterException {
        Trace.out("args = " + Utils.getString(args, COMMA));
        CmdLineParser cmdParser = new CmdLineParser(OPT, FLAGS, SHR_PARAMS, SHR_OPTIONAL);
        try {
            cmdParser.parse(args);
        }
        catch (MissingArgumentException mae) {
            throw new ClusterException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new ClusterException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            throw new ClusterException(uae.getMessage());
        }
        this.m_localNode = cmdParser.getParam(LOCALNODE);
        this.m_ohome = cmdParser.getParam(OHOME);
        String nodeList = cmdParser.getParam(NODELIST);
        StringTokenizer tokenizer = new StringTokenizer(nodeList, COMMA);
        this.m_NodeList = new String[tokenizer.countTokens()];
        int i = 0;
        try {
            while (tokenizer.hasMoreElements()) {
                this.m_NodeList[i++] = tokenizer.nextToken();
            }
        }
        catch (NoSuchElementException nex) {
            throw new ClusterException("Error in parsing nodelist" + nex.toString());
        }
    }

    private void checkSharedness() throws SharedDeviceException, InvalidNodeListException {
        boolean isShared = false;
        isShared = Cluster.isShared(this.m_ohome, this.m_NodeList, this.m_localNode);
        if (isShared) {
            System.out.println(TRUE);
        } else {
            System.out.println(FALSE);
        }
    }

    private void checkIPv6() {
        boolean isIPv6 = false;
        isIPv6 = IPAddressUtil.isIPv6AddressString(this.m_ip);
        if (isIPv6) {
            System.out.println(TRUE);
        } else {
            System.out.println(FALSE);
        }
    }

    public int executeChkShare(String[] args) {
        try {
            this.parseChkShareArgs(args);
        }
        catch (ClusterException cex) {
            Trace.out(cex);
            System.out.println(cex.toString());
            ClusterCheckUtil.usageChkShare();
            return 1;
        }
        try {
            this.checkSharedness();
            return 0;
        }
        catch (SharedDeviceException sde) {
            Trace.out(sde);
            return 1;
        }
        catch (InvalidNodeListException ine) {
            Trace.out(ine);
            return 1;
        }
    }

    public int executeChkIPv6(String[] args) {
        Trace.out("args = " + Utils.getString(args, COMMA));
        if (args == null || args.length != 2 || args[0] == null || args[1] == null || !args[0].equals("-isipv6")) {
            ClusterCheckUtil.usageChkIPv6();
            return 1;
        }
        this.m_ip = args[1];
        this.checkIPv6();
        return 0;
    }

    public static void usageChkShare() {
        System.out.println("\nchkshare args:\n\t-oh <oracle_home>\n\t-localnode <local_node>\n\t-nodelist <node1[,node2,..]>");
    }

    public static void usageChkIPv6() {
        System.out.println("\nisipv6 args:\n\t<ip_address>");
    }
}

