/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.deployment.ClientClusterComponent;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.common.sConstants;
import oracle.cluster.install.ConfigException;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.ConfigurationSetupFactory;
import oracle.cluster.install.InstallException;
import oracle.cluster.install.NodeStatus;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.OCRInfo;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.FatalException;
import oracle.ops.util.Utils;

public class CRSDeconfig {
    private static final int TWO_FIFTY_FIVE = 255;
    private static final String LOCAL_HOST_START = "127.";
    private static final String WIN_CRS_CMD = "oclean";
    private static final String SCRIPTS_DIR = "scripts";
    private static final String TEMPLATES_DIR = "templates";
    private static final String CRS_CMD_FILE = "crsdeconfig";
    private static final String DC_HOME_PROPERTY = "DC_HOME";
    private static final String TNSLSNR_SUBPATH = "bin" + File.separator + "tnslsnr";
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String ROOT_DEINSTALL_SH = "rootdeinstall.sh";
    private static final String ROOT_DEINSTALL_BAT = "rootdeinstall.bat";
    private static String m_crsHome;
    private static String m_oracleHome;
    private static String m_oracleBase;
    private static String m_homeType;
    private static String m_oracleUser;
    private static String m_oracleGroup;
    private static String m_oracleASMGroup;
    private static String m_localNode;
    private static String[] ma_nodes;
    private static String m_crsdcTraceFile;
    private static String[] ma_activeNodes;
    private static String[] ma_inActiveNodes;
    private static String m_crsconfigParamFile;
    private static String m_crsCmdFileName;
    private static String m_haCmdFileName;
    private static String m_dcToolPath;
    private static String m_tmpDir;
    private static boolean m_silent;
    private static boolean m_localDC;
    private static boolean m_localDCInvalid;
    private static boolean m_sihaStack;
    private static boolean m_execAutoScript;
    private static boolean m_isUnlock;
    private static ArrayList<String> m_summaryTextList;
    private static String m_silentRunCmd;
    private static Hashtable m_dcFailedNodes;
    private static List<VIPAddress> m_clusterVIPs;
    private static MessageBundle m_msgVBundle;
    private static MessageBundle m_msgUBundle;
    private static NativeSystem s_nativeSystem;

    public static List checkConfig(Properties props) throws FatalException {
        boolean dcFlag = false;
        try {
            dcFlag = ClusterCmd.getDeconfigNonClusterMode();
            Trace.out("Setting DC flag to true");
            ClusterCmd.setDeconfigNonClusterMode(true);
            List list = CRSDeconfig.checkConfig(props, dcFlag);
            return list;
        }
        finally {
            Trace.out("Setting DC flag back to " + dcFlag);
            ClusterCmd.setDeconfigNonClusterMode(dcFlag);
        }
    }

    private static List checkConfig(Properties props, boolean dcFlag) throws FatalException {
        CRSDeconfig.setTraceLog(props, false);
        CRSDeconfig.readPropertyValues(props, true);
        CRSDeconfig.copyCRSConfigFile(props);
        CRSDeconfig.readCRSConfigParamfile(props);
        if (!CRSDeconfig.isThisConfiguredCRSHome()) {
            m_summaryTextList = new ArrayList(1);
            Object[] args = new String[]{""};
            try {
                args[0] = new ClusterwareInfo().getConfiguredCRSHome(m_oracleHome);
                Trace.out("The home being deconfigured is NOT a configured Grid Infrastructure home (" + args[0] + ")");
            }
            catch (InstallException ie) {
                Trace.out("Cannot determine the configured CRS home. Details: " + ie.getMessage());
                Trace.out("The home being deconfigured is NOT a configured Grid Infrastructure home");
            }
            m_summaryTextList.add(m_msgUBundle.getMessage("1057", false, args));
            return m_summaryTextList;
        }
        Trace.out("CRS Home = " + m_crsHome);
        Trace.out("Oracle home = " + m_oracleHome);
        if (m_localDCInvalid) {
            throw new FatalException(m_msgUBundle.getMessage("1060", false));
        }
        boolean isRim = false;
        ClusterwareInfo clsInfo = null;
        try {
            clsInfo = new ClusterwareInfo();
            NodeRole nRole = clsInfo.getActiveNodeRole(m_crsHome, m_localNode);
            Trace.out("Node role is " + nRole.toString());
            if (NodeRole.RIM == nRole) {
                isRim = true;
            }
        }
        catch (InstallException ie) {
            Trace.out(ie.getMessage());
        }
        m_summaryTextList = new ArrayList(6);
        CRSDeconfig.getOracleUserGroup(props);
        CRSDeconfig.verifyRACDatabases();
        try {
            if (!m_sihaStack && clsInfo.getClusterClassification() == ClusterClassification.DOMAIN_CLUSTER) {
                CRSDeconfig.verifyMemberClusters();
            }
        }
        catch (InstallException ie) {
            Trace.out(ie.getMessage());
        }
        CRSDeconfig.savePropertyValues(props);
        return m_summaryTextList;
    }

    public static List cleanConfig(Properties props) throws FatalException {
        boolean dcFlag = false;
        try {
            dcFlag = ClusterCmd.getDeconfigNonClusterMode();
            Trace.out("Setting DC flag to true");
            ClusterCmd.setDeconfigNonClusterMode(true);
            List<String> list = CRSDeconfig.cleanConfig(props, dcFlag);
            return list;
        }
        finally {
            Trace.out("Setting DC flag back to " + dcFlag);
            ClusterCmd.setDeconfigNonClusterMode(dcFlag);
        }
    }

    private static boolean isThisConfiguredCRSHome() {
        String oracleHome;
        String configuredCRSHome;
        if (m_oracleHome == null) {
            Trace.out("The oracle home is null");
            return true;
        }
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        try {
            configuredCRSHome = clusterwareInfo.getConfiguredCRSHome(m_oracleHome);
        }
        catch (InstallException ie) {
            Trace.out("Install exception encountered while retrieving the configured CRS home. Details: " + ie.getMessage());
            return true;
        }
        if (configuredCRSHome.endsWith(File.separator)) {
            configuredCRSHome = configuredCRSHome.substring(0, configuredCRSHome.length() - 1);
        }
        if ((oracleHome = m_oracleHome).endsWith(File.separator)) {
            oracleHome = oracleHome.substring(0, oracleHome.length() - 1);
        }
        if (s_nativeSystem.isUnixSystem()) {
            try {
                String oracleHomeCanonicalPath = new File(oracleHome).getCanonicalPath();
                String configuredCRSHomeCanonicalPath = new File(configuredCRSHome).getCanonicalPath();
                return oracleHomeCanonicalPath.equals(configuredCRSHomeCanonicalPath);
            }
            catch (IOException ioe) {
                Trace.out("IOException encountered while retrieving the canonical path. Details: " + ioe.getMessage());
                return true;
            }
            catch (SecurityException se) {
                Trace.out("SecurityException encountered while retrieving the canonical path. Details: " + se.getMessage());
                return true;
            }
        }
        return oracleHome.equalsIgnoreCase(configuredCRSHome);
    }

    private static void stopServices() throws FatalException {
        boolean retValue;
        ClusterWindows clusterWindows;
        try {
            clusterWindows = new ClusterWindows();
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            throw new FatalException(ce.getMessage(), ce);
        }
        boolean mustThrowException = false;
        Exception[] clusterException = new Exception[4];
        int exceptionIndex = 0;
        StringBuffer concatExceptionMsgs = new StringBuffer();
        String nodeNames = ma_activeNodes[0];
        if (ma_activeNodes.length > 1) {
            for (int i = 1; i < ma_activeNodes.length; ++i) {
                nodeNames = nodeNames + ", " + ma_activeNodes[i];
            }
        }
        Trace.out("=======> About to first stop and then delete the \"OracleClusterVolumeService\" and the \"Oracle Object Service\" service.");
        try {
            retValue = clusterWindows.stopServiceOnNodes("OracleClusterVolumeService", ma_activeNodes, true, true);
            Trace.out("=======> Attempt to stop service \"OracleClusterVolumeService\" on nodes \"" + nodeNames + "\" was successful: " + retValue);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            mustThrowException = true;
            clusterException[exceptionIndex] = ce;
            concatExceptionMsgs.append(ce.getMessage());
            ++exceptionIndex;
        }
        try {
            retValue = clusterWindows.stopServiceOnNodes("Oracle Object Service", ma_activeNodes, true, true);
            Trace.out("=======> Attempt to stop service \"Oracle Object Service\" on nodes \"" + nodeNames + "\" was successful: " + retValue);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            if (mustThrowException) {
                clusterException[exceptionIndex] = ce;
                concatExceptionMsgs.append(System.getProperty("line.separator"));
            } else {
                mustThrowException = true;
            }
            concatExceptionMsgs.append(ce.getMessage());
            ++exceptionIndex;
        }
        try {
            retValue = clusterWindows.deleteServiceOnNodes("OracleClusterVolumeService", ma_activeNodes, true, true);
            Trace.out("=======> Attempt to delete service \"OracleClusterVolumeService\" on nodes \"" + nodeNames + "\" was successful: " + retValue);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            if (mustThrowException) {
                clusterException[exceptionIndex] = ce;
                concatExceptionMsgs.append(System.getProperty("line.separator"));
            } else {
                mustThrowException = true;
            }
            concatExceptionMsgs.append(ce.getMessage());
            ++exceptionIndex;
        }
        try {
            retValue = clusterWindows.deleteServiceOnNodes("Oracle Object Service", ma_activeNodes, true, true);
            Trace.out("=======> Attempt to delete service \"Oracle Object Service\" on nodes \"" + nodeNames + "\" was successful: " + retValue);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            if (mustThrowException) {
                clusterException[exceptionIndex] = ce;
                concatExceptionMsgs.append(System.getProperty("line.separator"));
            } else {
                mustThrowException = true;
            }
            concatExceptionMsgs.append(ce.getMessage());
            ++exceptionIndex;
        }
        String imagePath = m_crsHome.endsWith(File.separator) ? m_crsHome + TNSLSNR_SUBPATH : m_crsHome + File.separator + TNSLSNR_SUBPATH;
        HashMap tnsListenerServiceMapByService = null;
        try {
            Map<String, List<String>> tnsListenerServiceMapByNode = clusterWindows.getServices4ImagePath(ma_activeNodes, imagePath);
            Set<String> nodes = tnsListenerServiceMapByNode.keySet();
            tnsListenerServiceMapByService = new HashMap();
            List<String> tnsListenerNodeNames = new ArrayList();
            for (String curr_node : nodes) {
                List<String> tnsListenerServices = tnsListenerServiceMapByNode.get(curr_node);
                if (tnsListenerServices == null) continue;
                for (String curr_serviceName : tnsListenerServices) {
                    tnsListenerNodeNames = (List)tnsListenerServiceMapByService.get(curr_serviceName);
                    if (tnsListenerNodeNames == null) {
                        tnsListenerNodeNames = new ArrayList();
                    }
                    tnsListenerNodeNames.add(curr_node);
                    tnsListenerServiceMapByService.put(curr_serviceName, tnsListenerNodeNames);
                }
            }
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            if (mustThrowException) {
                clusterException[exceptionIndex] = ce;
                concatExceptionMsgs.append(System.getProperty("line.separator"));
            } else {
                mustThrowException = true;
            }
            concatExceptionMsgs.append(ce.getMessage());
            ++exceptionIndex;
        }
        catch (ClusterOperationException coe) {
            if (mustThrowException) {
                clusterException[exceptionIndex] = coe;
                concatExceptionMsgs.append(System.getProperty("line.separator"));
            } else {
                mustThrowException = true;
            }
            concatExceptionMsgs.append(coe.getMessage());
            ++exceptionIndex;
        }
        if (tnsListenerServiceMapByService != null && tnsListenerServiceMapByService.size() > 0) {
            Set tnsListenerServiceNames = tnsListenerServiceMapByService.keySet();
            for (String currServiceName : tnsListenerServiceNames) {
                String[] node_names = ((List)tnsListenerServiceMapByService.get(currServiceName)).toArray(new String[0]);
                if (node_names == null || node_names.length <= 0) continue;
                String nodeNamesStr = node_names[0];
                if (node_names.length > 1) {
                    for (int i = 1; i < node_names.length; ++i) {
                        nodeNamesStr = nodeNamesStr + ", " + node_names[i];
                    }
                }
                try {
                    retValue = clusterWindows.stopServiceOnNodes(currServiceName, node_names, true, true);
                    Trace.out("=======> Attempt to stop service \"" + currServiceName + "\" on nodes \"" + nodeNamesStr + "\" was successful: " + retValue);
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    if (mustThrowException) {
                        clusterException[exceptionIndex] = ce;
                        concatExceptionMsgs.append(System.getProperty("line.separator"));
                    } else {
                        mustThrowException = true;
                    }
                    concatExceptionMsgs.append(ce.getMessage());
                    ++exceptionIndex;
                }
                try {
                    retValue = clusterWindows.deleteServiceOnNodes(currServiceName, node_names, true, true);
                    Trace.out("=======> Attempt to delete service \"" + currServiceName + "\" on node \"" + nodeNamesStr + "\" was successful: " + retValue);
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    if (mustThrowException) {
                        clusterException[exceptionIndex] = ce;
                        concatExceptionMsgs.append(System.getProperty("line.separator"));
                    } else {
                        mustThrowException = true;
                    }
                    concatExceptionMsgs.append(ce.getMessage());
                    ++exceptionIndex;
                }
            }
        }
        if (mustThrowException) {
            m_summaryTextList.add(concatExceptionMsgs.toString());
            throw new FatalException(concatExceptionMsgs.toString(), clusterException[exceptionIndex - 1]);
        }
    }

    private static List<String> cleanConfig(Properties props, boolean dcFlag) throws FatalException {
        CRSDeconfig.readPropertyValues(props, true);
        CRSDeconfig.updateCRSParamFile();
        Trace.out("Cleaning the confguration");
        if (!CRSDeconfig.isThisConfiguredCRSHome()) {
            m_summaryTextList = new ArrayList(1);
            Object[] args = new String[]{""};
            try {
                args[0] = new ClusterwareInfo().getConfiguredCRSHome(m_oracleHome);
                Trace.out("The home being deconfigured is NOT a configured Grid Infrastructure home (" + args[0] + ")");
            }
            catch (InstallException ie) {
                Trace.out("Cannot determine the configured CRS home. Details: " + ie.getMessage());
                Trace.out("The home being deconfigured is NOT a configured Grid Infrastructure home");
            }
            m_summaryTextList.add(m_msgUBundle.getMessage("1057", false, args));
            m_isUnlock = true;
            if (s_nativeSystem.isUnixSystem()) {
                if (m_sihaStack) {
                    CRSDeconfig.unlockHAHome(props);
                    Trace.out("HA home is unlocked successfully");
                } else {
                    CRSDeconfig.unlockHome(props);
                    Trace.out("GI home is unlocked successfully");
                }
            }
            return m_summaryTextList;
        }
        m_summaryTextList = new ArrayList(10);
        Trace.out("Asking user to run rootcrs.pl or roothas.pl");
        if (m_sihaStack) {
            CRSDeconfig.runHARootScripts(props);
            Trace.out("HA stack is stopped and cleaned up successfully");
        } else {
            CRSDeconfig.runRootScripts(props);
            Trace.out("CRS stack is stopped and cleaned up successfully");
        }
        if (!m_execAutoScript && m_silent) {
            String mesg;
            Object[] args;
            if (m_sihaStack) {
                args = new String[1];
                if (s_nativeSystem.isUnixSystem()) {
                    args[0] = m_dcToolPath + Constants.FILE_SEPARATOR + ROOT_DEINSTALL_SH;
                }
                mesg = m_msgUBundle.getMessage("1037", false, args);
            } else {
                args = new String[2];
                args[0] = m_silentRunCmd;
                if (s_nativeSystem.isUnixSystem()) {
                    args[1] = m_dcToolPath + Constants.FILE_SEPARATOR + ROOT_DEINSTALL_SH;
                }
                mesg = m_localDC ? m_msgUBundle.getMessage("1061", false, args) : m_msgUBundle.getMessage("1021", false, args);
            }
            m_summaryTextList.add(mesg);
            CRSDeconfig.showMessage("<----------------------------------------");
            CRSDeconfig.showMessage(mesg);
            CRSDeconfig.showMessage("<----------------------------------------");
        }
        if (!s_nativeSystem.isUnixSystem()) {
            CRSDeconfig.stopServices();
        }
        if (m_dcFailedNodes.size() != 0) {
            String retMsg = "";
            Enumeration nodeKeys = m_dcFailedNodes.keys();
            while (nodeKeys.hasMoreElements()) {
                String node = (String)nodeKeys.nextElement();
                Object[] args = new String[]{node, (String)m_dcFailedNodes.get(node)};
                String mesg = m_msgUBundle.getMessage("1023", false, args);
                retMsg = retMsg + NEW_LINE + mesg;
            }
            retMsg = retMsg + NEW_LINE + m_msgUBundle.getMessage("1024", false);
            m_summaryTextList.add(retMsg);
            throw new FatalException(retMsg);
        }
        String msg = m_sihaStack ? m_msgUBundle.getMessage("1038", false) : m_msgUBundle.getMessage("1017", false);
        m_summaryTextList.add(msg);
        return m_summaryTextList;
    }

    private static void readPropertyValues(Properties props, boolean append) {
        CRSDeconfig.setTraceLog(props, append);
        m_crsHome = props.getProperty("ORA_CRS_HOME");
        Trace.out("ORA_CRS_HOME = " + m_crsHome);
        m_oracleHome = props.getProperty("ORACLE_HOME");
        Trace.out("ORACLE_HOME = " + m_oracleHome);
        boolean bl = m_localDC = props.getProperty("local", "false").equalsIgnoreCase("true");
        if (m_localDC) {
            Trace.out("Local flag is set");
        }
        m_oracleBase = props.getProperty("ORACLE_BASE");
        Trace.out("ORACLE_BASE = " + m_oracleBase);
        if (m_oracleBase == null || m_oracleBase.length() == 0) {
            m_oracleBase = m_oracleHome;
            props.setProperty("ORACLE_BASE", m_oracleBase);
            Trace.out("ORACLE_BASE is set to same value as ORACLE_HOME");
            Trace.out("m_oracleBase=" + m_oracleBase);
        }
        m_homeType = props.getProperty("HOME_TYPE");
        Trace.out("Home Type is " + m_homeType);
        if (m_homeType.equalsIgnoreCase("SIHA")) {
            m_sihaStack = true;
        }
        m_localNode = (m_localNode = props.getProperty("LOCAL_NODE")) == null || m_localNode.length() == 0 ? CRSDeconfig.getLocalNode() : CRSDeconfig.getClusterNodeName(m_localNode);
        Trace.out("m_localNode = " + m_localNode);
        String nodeNames = props.getProperty("CLUSTER_NODES");
        Trace.out("CLUSTER_NODES = " + nodeNames);
        if (nodeNames != null && nodeNames.length() > 0) {
            Trace.out("Cluster node names are supplied by the tool");
            CRSDeconfig.setClusterNodes(nodeNames);
        } else {
            Trace.out("Retrieving node names from clusterware stack");
            try {
                ma_nodes = CRSDeconfig.getClusterNodes();
            }
            catch (ClusterInfoException ce) {
                Trace.out("Cannot get the node list since local stack is down");
                Trace.out("Setting nodelist to the local node");
                ma_nodes = new String[1];
                CRSDeconfig.ma_nodes[0] = m_localNode;
            }
        }
        if (m_localDC) {
            String[] clNodes;
            try {
                clNodes = CRSDeconfig.getClusterNodes();
            }
            catch (ClusterInfoException ce) {
                Trace.out("Cannot get the node list since local stack is down");
                Trace.out("Allow 'deinstall -local' to proceed without checking if this is the last node.");
                clNodes = null;
            }
            if (clNodes != null && clNodes.length == 1) {
                m_localDCInvalid = true;
            }
        }
        Vector<String> activeNodeList = new Vector<String>(ma_nodes.length);
        Vector<String> inActiveNodeList = new Vector<String>(ma_nodes.length);
        if (!s_nativeSystem.isUnixSystem()) {
            m_execAutoScript = true;
        }
        for (int i = 0; i < ma_nodes.length; ++i) {
            if (ma_nodes[i].equals(m_localNode)) continue;
            try {
                CRSDeconfig.isNodeAlive(ma_nodes[i]);
                activeNodeList.add(ma_nodes[i]);
                continue;
            }
            catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                inActiveNodeList.add(ma_nodes[i]);
            }
        }
        activeNodeList.add(m_localNode);
        if (m_localDC) {
            ma_activeNodes = new String[1];
            CRSDeconfig.ma_activeNodes[0] = m_localNode;
        } else {
            ma_activeNodes = new String[activeNodeList.size()];
            activeNodeList.copyInto(ma_activeNodes);
        }
        Trace.out("activeNodes.length = " + ma_activeNodes.length);
        ma_inActiveNodes = new String[inActiveNodeList.size()];
        inActiveNodeList.copyInto(ma_inActiveNodes);
        Trace.out("inActiveNodes.length = " + ma_inActiveNodes.length);
        m_dcToolPath = System.getProperty(DC_HOME_PROPERTY);
        if (!IS_UNIX_SYSTEM && m_dcToolPath.endsWith(File.separator)) {
            m_dcToolPath = m_dcToolPath.substring(0, m_dcToolPath.length() - 1);
        }
        if (m_dcToolPath == null) {
            m_dcToolPath = System.getProperty("user.dir");
        }
        Trace.out("Tool Home = " + m_dcToolPath);
        String crsconfigFileName = System.getProperty("PARAM_FILE_NAME", m_crsconfigParamFile);
        m_crsconfigParamFile = props.getProperty("PARAM_FILE_NAME", crsconfigFileName);
        Trace.out("Parameter file Name = " + m_crsconfigParamFile);
        boolean bl2 = m_silent = props.getProperty("silent", "false").equalsIgnoreCase("true");
        if (m_silent) {
            Trace.out("Silent mode is enabled");
        }
        m_clusterVIPs = new ArrayList<VIPAddress>(0);
    }

    private static String getClusterNodeName(String nodeName) {
        Trace.out("nodeName = " + nodeName);
        try {
            Node node = ServerFactory.getInstance().getNode(nodeName);
            return node.getName();
        }
        catch (ServerException se) {
            Trace.out("Failed to process node name \"" + nodeName + "\" Details:" + se.getMessage());
            return nodeName.toLowerCase();
        }
        catch (NodeException ne) {
            Trace.out("Failed to process node name \"" + nodeName + "\" Details:" + ne.getMessage());
            return nodeName.toLowerCase();
        }
    }

    private static void setClusterNodes(String nodeNames) {
        Trace.out("nodeNames = " + nodeNames);
        StringTokenizer tokens = new StringTokenizer(nodeNames, ",");
        ma_nodes = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String nodeName = tokens.nextToken();
            CRSDeconfig.ma_nodes[i] = CRSDeconfig.getClusterNodeName(nodeName);
            ++i;
        }
    }

    private static void updateCRSParamFile() {
        Trace.out("PARAM_FILE_NAME = " + m_crsconfigParamFile);
        FileOutputStream fos = null;
        try {
            Properties rspProps = Utils.loadProperties(m_crsconfigParamFile);
            if (rspProps.containsKey("CRS_STORAGE_OPTION")) {
                Trace.out("CRS_STORAGE_OPTION exists in PARAM_FILE_PATH");
            } else {
                fos = new FileOutputStream(new File(m_crsconfigParamFile));
                String asmDiskGroup = (String)rspProps.get("ASM_DISK_GROUP");
                if (asmDiskGroup != null && asmDiskGroup.trim().length() != 0) {
                    Trace.out("ASM_DISK_GROUP is set. So setting CRS_STORAGE_OPTION=1");
                    rspProps.setProperty("CRS_STORAGE_OPTION", "1");
                } else {
                    Trace.out("ASM_DISK_GROUP is not set. So setting CRS_STORAGE_OPTION=2");
                    rspProps.setProperty("CRS_STORAGE_OPTION", "2");
                }
                Trace.out("Saving PARAM_FILE_PATH: " + m_crsconfigParamFile);
                rspProps.store(fos, "Written by CRSDC");
            }
        }
        catch (IOException ie) {
            Trace.out("Failed to save properties files : " + ie.getMessage());
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ie) {
                    Trace.out(ie);
                }
            }
        }
        Trace.out("Done processing PARAM_FILE_PATH: " + m_crsconfigParamFile);
    }

    private static void setTraceLog(Properties props, boolean append) {
        m_tmpDir = props.getProperty("TMPDIR");
        if (m_tmpDir == null || m_tmpDir.length() == 0) {
            m_tmpDir = s_nativeSystem.isUnixSystem() ? "/tmp" : System.getProperty("java.io.tmpdir", "c:\temp");
        }
        String traceLogDir = props.getProperty("LOGDIR", m_tmpDir);
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss-a").format(new Date());
        m_crsdcTraceFile = traceLogDir + Constants.FILE_SEPARATOR + "crsdc_" + timeStamp + ".log";
        Trace.out("File is " + m_crsdcTraceFile);
        Trace.enableDebugTracing();
        Trace.traceEnabled(true);
        if (!append) {
            System.out.println("Traces log file: " + m_crsdcTraceFile);
            Trace.configure(false, false, true, true, m_crsdcTraceFile, true);
        } else {
            Trace.enableLogging(m_crsdcTraceFile, append);
        }
    }

    private static String[] getClusterNodes() throws ClusterInfoException {
        ClusterInfo clusterInfo = new ClusterInfo(m_oracleHome);
        String[] nodes = clusterInfo.getNodeNames();
        return nodes;
    }

    private static String getLocalNode() {
        String node;
        try {
            ClusterInfo clusterInfo = new ClusterInfo(m_oracleHome);
            node = clusterInfo.getLocalNodeName();
        }
        catch (ClusterInfoException ce) {
            Trace.out(ce.getMessage());
            try {
                Trace.out("Failed to get local host name from cluster");
                node = InetAddress.getLocalHost().getHostName();
                Trace.out("Local host name = " + node);
                int dotIndex = node.indexOf(".");
                if (dotIndex != -1) {
                    node = node.substring(0, dotIndex);
                }
                Trace.out("node = " + node);
            }
            catch (UnknownHostException uhe) {
                Trace.out(uhe);
                node = null;
            }
        }
        return node;
    }

    private static boolean retrieveOracleVIPs(Properties props) {
        Trace.out("Retrieving Oracle VIP details from Oracle clusterware");
        NodeAppsFactory naf = null;
        boolean bStatus = true;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Failed to retrieve node applications");
            Trace.out(sme);
            bStatus = false;
        }
        if (!bStatus) {
            return bStatus;
        }
        List<Network> netList = null;
        try {
            netList = naf.getNetworks();
        }
        catch (NotExistsException nee) {
            Trace.out("Oracle clusterware does not have any networks configured");
            Trace.out(nee);
            return true;
        }
        catch (NetworkException ne) {
            Trace.out("Failed to retrieve networks configured with CRS");
            Trace.out(ne);
            bStatus = false;
        }
        if (!bStatus) {
            return bStatus;
        }
        if (netList == null || netList.isEmpty()) {
            return true;
        }
        int netNumber = -1;
        String subnetMask = "255.255.255.0";
        List<NetworkAdapter> netIFList = null;
        NetworkAdapter[] netIFs = null;
        for (Network network : netList) {
            String[] interfaces = null;
            try {
                netNumber = network.getNumber();
                Subnet subnet = network.subnet();
                subnetMask = subnet != null ? subnet.subnetMaskAsStr() : "255.255.255.0";
                netIFList = network.networkAdapters();
                netIFs = new NetworkAdapter[netIFList.size()];
                netIFs = netIFList.toArray(netIFs);
                interfaces = new String[netIFs.length];
                for (int i = 0; i < netIFs.length; ++i) {
                    interfaces[i] = netIFs[i].getAdapterName();
                }
            }
            catch (NotExistsException nee) {
                Trace.out("Failed to retrieve subnet and network adapter details for network: " + netNumber);
                Trace.out(nee);
                bStatus = false;
            }
            catch (NetworkException ne) {
                Trace.out("Failed to retrieve Oracle network configuration data for network: " + netNumber);
                Trace.out(ne);
                bStatus = false;
            }
            try {
                List<VIP> vipList = naf.getVIPs(netNumber);
                for (VIP vip : vipList) {
                    String ipName = vip.address().getHostName();
                    String ipAddress = vip.address().getHostAddress();
                    VIPAddress vipAddress = new VIPAddress(ipName, ipAddress, subnetMask, interfaces);
                    m_clusterVIPs.add(vipAddress);
                }
            }
            catch (VIPException ve) {
                Trace.out("Failed to retrieve Oracle VIP configuration data");
                Trace.out(ve);
                bStatus = false;
            }
            catch (VirtualIPException vipe) {
                Trace.out("Failed to create VIPAddres object for Oracle VIP");
                Trace.out(vipe);
                bStatus = false;
            }
        }
        int vipIndex = 1;
        for (VIPAddress vipAddr : m_clusterVIPs) {
            props.setProperty("VIP" + vipIndex + "_IP", vipAddr.getAddressAsString());
            props.setProperty("VIP" + vipIndex + "_MASK", vipAddr.getNetmask());
            props.setProperty("VIP" + vipIndex + "_IF", Utils.getString(vipAddr.getInterfaces(), ","));
            ++vipIndex;
        }
        return bStatus;
    }

    private static void getOracleUserGroup(Properties props) {
        Trace.out("Reading Oracle user and group name property values");
        m_oracleUser = props.getProperty("ORACLE_OWNER");
        if (m_oracleUser == null || m_oracleUser.startsWith("%") && m_oracleUser.endsWith("%")) {
            m_oracleUser = System.getProperty("user.name");
        }
        props.setProperty("ORACLE_OWNER", m_oracleUser);
        Trace.out("ORACLE_OWNER = " + m_oracleUser);
        m_oracleGroup = props.getProperty("ORA_DBA_GROUP");
        m_oracleASMGroup = props.getProperty("ORA_ASM_GROUP");
        if (m_oracleGroup == null || m_oracleGroup.startsWith("%") && m_oracleGroup.endsWith("%")) {
            NativeSystem system = new SystemFactory().CreateSystem();
            if (system.isUnixSystem()) {
                String osdbagrpCmd = m_dcToolPath + Constants.FILE_SEPARATOR + "bin" + Constants.FILE_SEPARATOR + "osdbagrp";
                String cmdOutput = system.runCmd(osdbagrpCmd, null, null, "localnode");
                NativeResult result = new NativeResult(cmdOutput);
                String dbaGroup = null;
                if (result.getStatus()) {
                    String[] resultStr = result.getResultString();
                    String[] resultArr = Utils.getStringArray(resultStr[0], " ");
                    dbaGroup = resultArr[0];
                }
                if (dbaGroup != null) {
                    m_oracleGroup = dbaGroup;
                    props.setProperty("ORA_DBA_GROUP", m_oracleGroup);
                }
            } else {
                m_oracleGroup = "";
                props.setProperty("ORA_DBA_GROUP", m_oracleGroup);
            }
        }
        Trace.out("ORA_DBA_GROUP = " + m_oracleGroup);
        if (m_oracleASMGroup == null || m_oracleASMGroup.startsWith("%") && m_oracleASMGroup.endsWith("%")) {
            m_oracleASMGroup = m_oracleGroup;
            props.setProperty("ORA_ASM_GROUP", m_oracleASMGroup);
        }
    }

    private static void readVIPDetailsFromUser(Properties props) {
        block26: {
            String ipAddress = null;
            String ipNetmask = null;
            String ipNetIFs = null;
            DataInputStream din = new DataInputStream(System.in);
            Object[] args = new String[1];
            String mesg = "";
            String defIPAddress = props.getProperty("VIP1_IP");
            String defaultMask = props.getProperty("VIP1_MASK", "255.255.255.0");
            String defaultIFs = props.getProperty("VIP1_IF");
            Trace.out("defaultMask = " + defaultMask);
            Trace.out("defaultIFs = " + defaultIFs);
            try {
                for (int i = 0; i < ma_nodes.length; ++i) {
                    defIPAddress = ma_nodes[i].trim() + "-vip";
                    if (CRSDeconfig.isIPExists(defIPAddress)) {
                        ipAddress = defIPAddress;
                    }
                    args[0] = ma_nodes[i];
                    mesg = m_msgUBundle.getMessage("1010", false, args);
                    System.out.print(mesg + "[" + ipAddress + "]");
                    CRSDeconfig.showMessage(" > ");
                    ipAddress = din.readLine();
                    if (ipAddress.trim().length() != 0) {
                        if (!CRSDeconfig.isIPExists(ipAddress)) {
                            args[0] = ipAddress;
                            mesg = m_msgUBundle.getMessage("1013", false, args);
                            CRSDeconfig.showMessage(mesg);
                            ipAddress = null;
                        }
                    } else if (defIPAddress != null && defIPAddress.trim().length() != 0) {
                        ipAddress = defIPAddress;
                        Trace.out("Using the default IP address: " + ipAddress);
                    } else {
                        ipAddress = null;
                    }
                    if (ipAddress != null) {
                        ipAddress = CRSDeconfig.getIPAddress(ipAddress);
                        props.setProperty("VIP" + (i + 1) + "_IP", ipAddress);
                        Trace.out("VIP" + (i + 1) + "_IP = " + ipAddress);
                    }
                    defaultMask = ipNetmask != null ? ipNetmask : defaultMask;
                    ipNetmask = null;
                    if (ipAddress != null) {
                        block25: {
                            args = new String[]{s_nativeSystem.getIPAddrCommand(), ma_nodes[i]};
                            mesg = m_msgUBundle.getMessage("1031", false, args);
                            System.out.println(mesg);
                            while (true) {
                                args = new String[]{ipAddress, ma_nodes[i]};
                                mesg = m_msgUBundle.getMessage("1011", false, args);
                                System.out.print(mesg + "[" + defaultMask + "]");
                                CRSDeconfig.showMessage(" > ");
                                ipNetmask = din.readLine();
                                if (ipNetmask.trim().length() == 0) break;
                                if (!CRSDeconfig.isValidFormat(ipNetmask)) {
                                    args = new String[]{ipNetmask};
                                    mesg = m_msgVBundle.getMessage("1019", false, args);
                                    CRSDeconfig.showMessage(mesg);
                                    continue;
                                }
                                break block25;
                                break;
                            }
                            ipNetmask = defaultMask;
                        }
                        props.setProperty("VIP" + (i + 1) + "_MASK", ipNetmask);
                        Trace.out("VIP" + (i + 1) + "_MASK = " + ipNetmask);
                    }
                    defaultIFs = ipNetIFs != null ? ipNetIFs : defaultIFs;
                    ipNetIFs = null;
                    if (ipAddress == null || ipNetIFs != null) continue;
                    args = new String[]{ipAddress};
                    mesg = m_msgUBundle.getMessage("1012", false, args);
                    if (defaultIFs != null && defaultIFs.trim().length() != 0) {
                        System.out.print(mesg + "[" + defaultIFs + "]");
                    } else {
                        System.out.print(mesg);
                    }
                    CRSDeconfig.showMessage(" > ");
                    ipNetIFs = din.readLine();
                    if (ipNetIFs.trim().length() == 0) {
                        ipNetIFs = defaultIFs;
                    }
                    if (ipNetIFs == null || ipNetIFs.trim().length() == 0) continue;
                    props.setProperty("VIP" + (i + 1) + "_IF", ipNetIFs);
                    Trace.out("VIP" + (i + 1) + "_IF = " + ipNetIFs);
                }
            }
            catch (IOException ie) {
                Trace.out(ie);
                ipAddress = null;
            }
            Trace.out("Query for other ip addresses used for Oracle clusterware");
            int ipCtr = ma_nodes.length;
            try {
                ipNetmask = "";
                ipNetIFs = "";
                while (true) {
                    block27: {
                        ++ipCtr;
                        ipAddress = "";
                        defaultMask = props.getProperty("VIP1_MASK", "255.255.255.0");
                        defaultIFs = props.getProperty("VIP1_IF");
                        mesg = m_msgUBundle.getMessage("1032", false);
                        System.out.print(mesg + "[" + ipAddress + "]");
                        CRSDeconfig.showMessage(" > ");
                        ipAddress = din.readLine();
                        if (ipAddress == null || ipAddress.trim().length() == 0) break block26;
                        if (!CRSDeconfig.isIPExists(ipAddress)) {
                            args[0] = ipAddress;
                            mesg = m_msgUBundle.getMessage("1013", false, args);
                            CRSDeconfig.showMessage(mesg);
                            ipAddress = null;
                            continue;
                        }
                        props.setProperty("VIP" + ipCtr + "_IP", ipAddress);
                        Trace.out("VIP" + ipCtr + "_IP = " + ipAddress);
                        defaultMask = ipNetmask != null ? ipNetmask : defaultMask;
                        ipNetmask = null;
                        if (ipAddress == null || ipNetmask != null) continue;
                        args = new String[]{s_nativeSystem.getIPAddrCommand(), m_localNode};
                        mesg = m_msgUBundle.getMessage("1031", false, args);
                        System.out.println(mesg);
                        while (true) {
                            args = new String[2];
                            args[0] = ipAddress;
                            mesg = m_msgUBundle.getMessage("1033", false, args);
                            System.out.print(mesg + "[" + defaultMask + "]");
                            CRSDeconfig.showMessage(" > ");
                            ipNetmask = din.readLine();
                            if (ipNetmask == null || ipNetmask.trim().length() == 0) break;
                            if (!CRSDeconfig.isValidFormat(ipNetmask)) {
                                args = new String[]{ipNetmask};
                                mesg = m_msgVBundle.getMessage("1019", false, args);
                                CRSDeconfig.showMessage(mesg);
                                continue;
                            }
                            break block27;
                            break;
                        }
                        ipNetmask = defaultMask != null ? defaultMask : "255.255.255.0";
                    }
                    props.setProperty("VIP" + ipCtr + "_MASK", ipNetmask);
                    Trace.out("VIP" + ipCtr + "_MASK = " + ipNetmask);
                    defaultIFs = ipNetIFs != null ? ipNetIFs : defaultIFs;
                    ipNetIFs = null;
                    if (ipAddress == null || ipNetIFs != null) continue;
                    args = new String[]{ipAddress};
                    mesg = m_msgUBundle.getMessage("1012", false, args);
                    if (defaultIFs != null && defaultIFs.trim().length() != 0) {
                        System.out.print(mesg + "[" + defaultIFs + "]");
                    } else {
                        System.out.print(mesg);
                    }
                    CRSDeconfig.showMessage(" > ");
                    ipNetIFs = din.readLine();
                    if (ipNetIFs != null && ipNetIFs.trim().length() == 0) {
                        ipNetIFs = defaultIFs;
                    }
                    if (ipNetIFs == null || ipNetIFs.trim().length() == 0) continue;
                    props.setProperty("VIP" + ipCtr + "_IF", ipNetIFs);
                    Trace.out("VIP" + ipCtr + "_IF = " + ipNetIFs);
                }
            }
            catch (IOException ie) {
                Trace.out(ie);
            }
        }
    }

    private static boolean isIPExists(String ipAddress) {
        boolean bIPAddrOK;
        Trace.out("Checking if the ip address is configured in network");
        try {
            Trace.out("checking IP address: " + ipAddress);
            String host = InetAddress.getByName(ipAddress).getHostName();
            bIPAddrOK = true;
        }
        catch (UnknownHostException e) {
            Trace.out("UnknownHostException: " + e.getMessage());
            bIPAddrOK = false;
        }
        return bIPAddrOK;
    }

    private static String getIPAddress(String ipHost) {
        String ipAddress;
        Trace.out("Getting IP address for an IP or host name entered");
        try {
            Trace.out("Getting IP address for vip host: " + ipHost);
            ipAddress = InetAddress.getByName(ipHost).getHostAddress();
        }
        catch (UnknownHostException e) {
            Trace.out("UnknownHostException: " + e.getMessage());
            ipAddress = ipHost;
        }
        return ipAddress;
    }

    private static int[] getIPBytes(String str) throws NumberFormatException {
        Trace.out("Converting address:'" + str + "' into bytes");
        if (str == null || str.startsWith(LOCAL_HOST_START)) {
            return new int[0];
        }
        StringTokenizer tokens = new StringTokenizer(str, ".");
        int[] ipBytes = new int[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            ipBytes[i] = Integer.parseInt(tokens.nextToken());
            ++i;
        }
        return ipBytes;
    }

    private static String generatePerlCommand(Properties props) {
        String runCmd = null;
        String cmdCRSDC = m_oracleHome + Constants.FILE_SEPARATOR + "crs" + Constants.FILE_SEPARATOR + "install" + Constants.FILE_SEPARATOR + m_haCmdFileName;
        String cmdOptions = "";
        if (m_isUnlock) {
            cmdOptions = cmdOptions + " -unlock -hahome " + m_oracleHome;
            runCmd = cmdCRSDC + cmdOptions + " -paramfile " + "\"" + m_crsconfigParamFile + "\"";
        } else {
            cmdOptions = cmdOptions + " -deconfig";
            runCmd = cmdCRSDC + " -force " + cmdOptions + " -paramfile " + "\"" + m_crsconfigParamFile + "\"";
        }
        return runCmd;
    }

    private static boolean isValidFormat(String ipAddress) {
        boolean bIPFormatOK = true;
        Trace.out("Validating format: " + ipAddress);
        try {
            int[] ipBytes = CRSDeconfig.getIPBytes(ipAddress);
            if (ipBytes.length != 4) {
                bIPFormatOK = false;
            }
            for (int i = 0; i < ipBytes.length; ++i) {
                if (ipBytes[i] <= 255 && ipBytes[i] >= 0) continue;
                bIPFormatOK = false;
                break;
            }
        }
        catch (NumberFormatException e) {
            Trace.out("NumberFormatException: " + e.getMessage());
            bIPFormatOK = false;
        }
        return bIPFormatOK;
    }

    private static boolean verifyHACommand(Properties props, String runCmd, boolean bHADeconfigured) {
        if (!m_silent || m_execAutoScript) {
            if (m_isUnlock) {
                Object[] args = new String[]{m_localNode};
                String mesg = m_msgUBundle.getMessage("1065", false, args);
                m_summaryTextList.add(mesg);
                try {
                    ClusterCmd cmd = new ClusterCmd();
                    if (cmd.isDirWritable(m_localNode, m_oracleHome)) {
                        bHADeconfigured = true;
                    }
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    Trace.out(ce);
                    bHADeconfigured = true;
                }
            } else {
                try {
                    if (CRSDeconfig.isHAStoppedAndCleaned(runCmd, m_localNode, true)) {
                        Object[] args = new String[]{m_localNode};
                        String mesg = m_msgUBundle.getMessage("1034", false, args);
                        m_summaryTextList.add(mesg);
                        bHADeconfigured = true;
                    } else {
                        String mesg = m_msgUBundle.getMessage("1035", false);
                        m_summaryTextList.add(mesg);
                    }
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    Trace.out(ce.getMessage());
                }
            }
        }
        return bHADeconfigured;
    }

    private static boolean runHACommand(Properties props, String runCmd) throws FatalException {
        String mesg;
        DataInputStream din = null;
        boolean bHADeconfigured = false;
        Object silent_runCmd = null;
        if (!m_silent || m_execAutoScript) {
            din = new DataInputStream(System.in);
        }
        try {
            if (m_isUnlock || !CRSDeconfig.isHAStoppedAndCleaned(runCmd, m_localNode, true)) {
                Object[] args = new String[]{m_localNode};
                if (m_silent && !m_execAutoScript) {
                    m_silentRunCmd = runCmd;
                    bHADeconfigured = true;
                } else {
                    mesg = m_msgUBundle.getMessage("1014", false, args);
                    Trace.out(mesg);
                    if (!m_execAutoScript) {
                        CRSDeconfig.showMessage(mesg);
                        CRSDeconfig.showMessage(runCmd);
                    }
                }
            } else {
                Object[] args = new String[]{m_localNode};
                mesg = m_msgUBundle.getMessage("1034", false, args);
                m_summaryTextList.add(mesg);
                bHADeconfigured = true;
            }
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            Trace.out("Node:" + m_localNode + " is not active");
            String string = ce.getMessage();
        }
        if (!bHADeconfigured) {
            if (m_execAutoScript) {
                if (!CRSDeconfig.execRootScriptAuto(null, props)) {
                    System.exit(1);
                }
            } else {
                mesg = m_msgUBundle.getMessage("1028", false);
                CRSDeconfig.showMessage(mesg);
                CRSDeconfig.showMessage("<----------------------------------------");
                Trace.out("Wating for user...");
                try {
                    String string = din.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bHADeconfigured;
    }

    private static void runRootScripts(Properties props) throws FatalException {
        if (ma_activeNodes != null && ma_activeNodes.length != 0) {
            String runCmd = null;
            Object silent_runCmd = null;
            runCmd = CRSDeconfig.generateGIperlCommand(props);
            ArrayList sucNodes = new ArrayList(ma_activeNodes.length);
            m_dcFailedNodes = new Hashtable(ma_activeNodes.length);
            Hashtable cmdTable = new Hashtable(ma_activeNodes.length);
            boolean isSharedDCHome = CRSDeconfig.isSharedDcHome();
            CRSDeconfig.copyDeinstallTool(runCmd, cmdTable, isSharedDCHome);
            Trace.out("Run rootcrs.pl -deconfig command");
            do {
                Enumeration nodeKeys = cmdTable.keys();
                CRSDeconfig.prepareGICommand(runCmd, cmdTable, nodeKeys);
                CRSDeconfig.runGICommand(props, cmdTable);
                Trace.out("Verifying the command status...");
                CRSDeconfig.verifyGICommand(cmdTable, runCmd);
            } while (cmdTable.size() != 0);
            CRSDeconfig.closeGIOutputFile();
        }
    }

    private static String generateGIperlCommand(Properties props) {
        if (m_silent) {
            String crsconfigFileName = System.getProperty("PARAM_FILE_NAME", m_crsconfigParamFile);
            m_crsconfigParamFile = props.getProperty("PARAM_FILE_NAME", crsconfigFileName);
        }
        String runCmd = null;
        String cmdCRSDC = m_oracleHome + Constants.FILE_SEPARATOR + "crs" + Constants.FILE_SEPARATOR + "install" + Constants.FILE_SEPARATOR + m_crsCmdFileName;
        String cmdOptions = "";
        if (m_isUnlock) {
            cmdOptions = cmdOptions + " -unlock -crshome " + m_oracleHome;
            runCmd = cmdCRSDC + cmdOptions + " -paramfile " + "\"" + m_crsconfigParamFile + "\"";
        } else {
            cmdOptions = cmdOptions + " -deconfig";
            runCmd = cmdCRSDC + " -force " + cmdOptions + " -paramfile " + "\"" + m_crsconfigParamFile + "\"";
        }
        return runCmd;
    }

    private static void copyDeinstallTool(String runCmd, Hashtable cmdTable, boolean isSharedDCHome) throws FatalException {
        boolean bLastNodeSelctd = false;
        for (int i = 0; i < ma_activeNodes.length; ++i) {
            boolean bcrsStatus = false;
            if (!ma_activeNodes[i].equals(m_localNode)) {
                try {
                    bcrsStatus = CRSDeconfig.isCRSStoppedAndCleaned(runCmd, ma_activeNodes[i], false);
                    Trace.out("CRS stack is already shutdown on node:" + ma_activeNodes[i]);
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    bcrsStatus = false;
                    Trace.out("CRS stack on node: " + ma_activeNodes[i] + " needs cleanup");
                    Trace.out(ce);
                }
                if (!bcrsStatus && !isSharedDCHome) {
                    Trace.out("Copying DC tool to \"" + m_dcToolPath + "\" on node:" + ma_activeNodes[i]);
                    CRSDeconfig.copyDCToolToNode(ma_activeNodes[i]);
                }
            }
            if (!(m_dcFailedNodes.size() != 0 || ma_activeNodes.length != 1 && (i + 1 != ma_activeNodes.length || bLastNodeSelctd) || m_localDC || m_isUnlock)) {
                runCmd = runCmd + " -lastnode";
                bLastNodeSelctd = true;
            }
            if (bcrsStatus) continue;
            Trace.out("Adding command: " + runCmd + " to run on node: " + ma_activeNodes[i]);
            cmdTable.put(ma_activeNodes[i], runCmd);
            if (m_crsconfigParamFile == null || m_crsconfigParamFile.equals("crsconfig_params") || ma_activeNodes[i].equals(m_localNode)) continue;
            String destFile = m_crsconfigParamFile;
            try {
                ClusterCmd cmd = new ClusterCmd();
                Trace.out("copying response file, " + m_crsconfigParamFile + " to " + ma_activeNodes[i]);
                cmd.copyFileToNode(m_crsconfigParamFile, ma_activeNodes[i], destFile);
                continue;
            }
            catch (oracle.ops.mgmt.cluster.ClusterException e) {
                Trace.out(e);
                throw new FatalException(e.getMessage());
            }
        }
    }

    private static void prepareGICommand(String runCmd, Hashtable cmdTable, Enumeration nodeKeys) throws FatalException {
        boolean deconfigMsgFlag = true;
        boolean allDone = false;
        while (!allDone) {
            String node;
            if (!nodeKeys.hasMoreElements()) {
                node = m_localNode;
                Trace.out("Process local node at the end" + node);
                allDone = true;
            } else {
                node = (String)nodeKeys.nextElement();
                Trace.out("Processing remote node" + node);
                if (node.equals(m_localNode)) continue;
            }
            Trace.out("Checking the status for node: " + node);
            try {
                String mesg;
                Object[] args;
                if (!CRSDeconfig.isCRSStoppedAndCleaned(runCmd, node, true)) {
                    args = new String[]{node};
                    if (m_silent && !m_execAutoScript) {
                        m_silentRunCmd = runCmd;
                        cmdTable.remove(node);
                        continue;
                    }
                    if (!m_dcFailedNodes.containsKey(node)) {
                        if (!m_localDC && !m_execAutoScript && deconfigMsgFlag) {
                            CRSDeconfig.showMessage("---------------------------------------->");
                            mesg = m_msgUBundle.getMessage("1056", false);
                            CRSDeconfig.showMessage(mesg);
                            deconfigMsgFlag = false;
                        }
                        mesg = m_msgUBundle.getMessage("1014", false, args);
                        Trace.out(mesg);
                        if (m_execAutoScript) continue;
                        CRSDeconfig.showMessage(mesg);
                        CRSDeconfig.showMessage((String)cmdTable.get(node));
                        continue;
                    }
                    Trace.out("Node: " + node + " has failure: " + m_dcFailedNodes.get(node));
                    cmdTable.remove(node);
                    continue;
                }
                args = new String[]{node};
                mesg = m_msgUBundle.getMessage("1027", false, args);
                Trace.out("Node:" + node + " Mesg: " + mesg);
                m_summaryTextList.add(mesg);
                cmdTable.remove(node);
                if (!m_dcFailedNodes.containsKey(node)) continue;
                m_dcFailedNodes.remove(node);
            }
            catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                Trace.out("Node:" + node + " is not active");
                String failMsg = ce.getMessage();
                if (m_dcFailedNodes.containsKey(node)) {
                    failMsg = failMsg + m_dcFailedNodes.get(node);
                }
                m_dcFailedNodes.put(node, ce.getMessage());
                cmdTable.remove(node);
            }
        }
    }

    private static void verifyGICommand(Hashtable cmdTable, String runCmd) throws FatalException {
        if (!m_silent || m_execAutoScript) {
            String mesg;
            Object[] args;
            String node;
            Enumeration nodeKeys = cmdTable.keys();
            ClusterCmd cmd = new ClusterCmd();
            while (nodeKeys.hasMoreElements()) {
                node = (String)nodeKeys.nextElement();
                try {
                    if (m_isUnlock) {
                        if (!cmd.isDirWritable(node, m_oracleHome)) continue;
                        cmdTable.remove(node);
                        args = new String[]{node};
                        mesg = m_msgUBundle.getMessage("1066", false, args);
                        Trace.out("Node:" + node + " Mesg: " + mesg);
                        m_summaryTextList.add(mesg);
                        continue;
                    }
                    if (!CRSDeconfig.isCRSStoppedAndCleaned(runCmd, node, true)) continue;
                    cmdTable.remove(node);
                    args = new String[]{node};
                    mesg = m_msgUBundle.getMessage("1022", false, args);
                    Trace.out("Node:" + node + " Mesg: " + mesg);
                    m_summaryTextList.add(mesg);
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    String failMsg = ce.getMessage();
                    if (m_dcFailedNodes.containsKey(node)) {
                        failMsg = failMsg + m_dcFailedNodes.get(node);
                    }
                    m_dcFailedNodes.put(node, ce.getMessage());
                    cmdTable.remove(node);
                    Trace.out("Node: " + node + " is not accessible");
                    Trace.out(ce.getMessage());
                }
            }
            if (m_dcFailedNodes.size() > 0) {
                nodeKeys = m_dcFailedNodes.keys();
                while (nodeKeys.hasMoreElements()) {
                    node = (String)nodeKeys.nextElement();
                    args = new String[]{node, (String)m_dcFailedNodes.get(node)};
                    mesg = m_msgUBundle.getMessage("1023", false, args);
                    m_summaryTextList.add(mesg);
                }
            }
        }
    }

    private static void closeGIOutputFile() throws FatalException {
        boolean isSharedDCHome = CRSDeconfig.isSharedDcHome();
        for (int i = 0; i < ma_inActiveNodes.length; ++i) {
            Object[] args = new String[]{ma_inActiveNodes[i]};
            String mesg = m_msgUBundle.getMessage("1029", false, args);
            if (m_dcFailedNodes.contains(ma_inActiveNodes[i])) continue;
            m_dcFailedNodes.put(ma_inActiveNodes[i], mesg);
        }
        ClusterCmd cmd = new ClusterCmd();
        Vector<String> rnodes = new Vector<String>(0);
        for (int i = 0; i < ma_activeNodes.length; ++i) {
            if (ma_activeNodes[i].equals(m_localNode) || m_dcFailedNodes.containsKey(ma_activeNodes[i])) continue;
            rnodes.add(ma_activeNodes[i]);
        }
        Object[] remoteNodes = new String[rnodes.size()];
        rnodes.copyInto(remoteNodes);
        if ((!m_silent || m_execAutoScript) && rnodes.size() > 0) {
            Trace.out("Removing dc files copied to remote nodes");
            remoteNodes = new String[rnodes.size()];
            rnodes.copyInto(remoteNodes);
            Trace.out("Removing \"" + m_dcToolPath + "\" from remote nodes: " + Utils.getString((String[])remoteNodes, ","));
            if (!isSharedDCHome) {
                try {
                    cmd.removeDirectory((String[])remoteNodes, m_dcToolPath, true);
                }
                catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                    System.out.println("Remove the directory: " + m_dcToolPath + " on node: " + Utils.getString((String[])remoteNodes, ","));
                    Trace.out(ce);
                }
            }
        }
    }

    private static void runGICommand(Properties props, Hashtable cmdTable) throws FatalException {
        DataInputStream din = new DataInputStream(System.in);
        if (cmdTable.size() > 0) {
            if (m_execAutoScript) {
                Trace.out("Automated execution for windows");
                ArrayList<String> nonLocalNodes = new ArrayList<String>();
                String[] nonLocalNodesArr = null;
                Enumeration nodeKeys = cmdTable.keys();
                while (nodeKeys.hasMoreElements()) {
                    String node = (String)nodeKeys.nextElement();
                    if (!node.equals(m_localNode)) {
                        nonLocalNodes.add(node);
                    }
                    Trace.out("deinstall on node " + node);
                }
                if (!nonLocalNodes.isEmpty()) {
                    nonLocalNodesArr = new String[nonLocalNodes.size()];
                    nonLocalNodes.toArray(nonLocalNodesArr);
                }
                if (!CRSDeconfig.execRootScriptAuto(nonLocalNodesArr, props)) {
                    System.exit(1);
                }
            } else {
                String mesg = m_msgUBundle.getMessage("1028", false);
                CRSDeconfig.showMessage(mesg);
                CRSDeconfig.showMessage("<----------------------------------------");
                Trace.out("Wating for user...");
                try {
                    String string = din.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isSharedDcHome() {
        boolean isSharedDCHome;
        try {
            isSharedDCHome = Cluster.isSharedPath(m_dcToolPath, ma_activeNodes, m_localNode);
        }
        catch (SharedDeviceException sde) {
            Trace.out(sde);
            isSharedDCHome = false;
        }
        catch (InvalidNodeListException inle) {
            Trace.out(inle);
            isSharedDCHome = false;
        }
        return isSharedDCHome;
    }

    private static void unlockHome(Properties props) throws FatalException {
        if (ma_activeNodes != null && ma_activeNodes.length != 0) {
            String runCmd = null;
            Object silent_runCmd = null;
            runCmd = CRSDeconfig.generateGIperlCommand(props);
            ArrayList sucNodes = new ArrayList(ma_activeNodes.length);
            m_dcFailedNodes = new Hashtable(ma_activeNodes.length);
            Hashtable cmdTable = new Hashtable(ma_activeNodes.length);
            boolean isSharedDCHome = CRSDeconfig.isSharedDcHome();
            CRSDeconfig.copyDeinstallTool(runCmd, cmdTable, isSharedDCHome);
            Trace.out("Run rootcrs.pl -unlock -crshome <ORACLE_HOME> command on cluster nodes");
            boolean isCRSHomeUnlocked = CRSDeconfig.isCRSHomeUnlocked(cmdTable);
            if (isCRSHomeUnlocked) {
                Trace.out("Oracle homes on all active nodes are already unlocked");
            }
            while (!isCRSHomeUnlocked) {
                Enumeration nodeKeys = cmdTable.keys();
                CRSDeconfig.prepareGICommand(runCmd, cmdTable, nodeKeys);
                CRSDeconfig.runGICommand(props, cmdTable);
                Trace.out("Verifying the command status...");
                CRSDeconfig.verifyGICommand(cmdTable, runCmd);
                if (cmdTable.size() != 0) continue;
            }
            CRSDeconfig.closeGIOutputFile();
        }
    }

    private static boolean isCRSHomeUnlocked(Hashtable cmdTable) {
        Enumeration nodeKeys = cmdTable.keys();
        ClusterCmd cmd = new ClusterCmd();
        while (nodeKeys.hasMoreElements()) {
            String node = (String)nodeKeys.nextElement();
            try {
                if (!cmd.isDirWritable(node, m_oracleHome)) continue;
                cmdTable.remove(node);
                Object[] args = new String[]{node};
                String mesg = m_msgUBundle.getMessage("1066", false, args);
                Trace.out("Node:" + node + " Mesg: " + mesg);
                m_summaryTextList.add(mesg);
            }
            catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                Trace.out(ce.getMessage());
            }
        }
        return cmdTable.size() == 0;
    }

    private static boolean isHAHomeUnlocked() {
        boolean isUnlockedHome = false;
        try {
            ClusterCmd cmd = new ClusterCmd();
            if (cmd.isDirWritable(m_localNode, m_oracleHome)) {
                isUnlockedHome = true;
                Object[] args = new String[]{m_localNode};
                String mesg = m_msgUBundle.getMessage("1065", false, args);
                m_summaryTextList.add(mesg);
            }
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            Trace.out(ce.getMessage());
        }
        return isUnlockedHome;
    }

    private static void unlockHAHome(Properties props) throws FatalException {
        boolean bHAUnlocked;
        String runCmd = null;
        runCmd = CRSDeconfig.generatePerlCommand(props);
        Trace.out("Run roothas.pl -unlock -hahome <ORACLE_HOME> command");
        if (!m_execAutoScript) {
            CRSDeconfig.showMessage("---------------------------------------->");
        }
        if (bHAUnlocked = CRSDeconfig.isHAHomeUnlocked()) {
            Trace.out("Oracle siha home was already unlocked");
        }
        while (!bHAUnlocked) {
            bHAUnlocked = CRSDeconfig.runHACommand(props, runCmd);
            Trace.out("Verifying the command status...");
            bHAUnlocked = CRSDeconfig.verifyHACommand(props, runCmd, bHAUnlocked);
        }
    }

    private static void runHARootScripts(Properties props) throws FatalException {
        boolean bcrsStatus;
        String runCmd = null;
        m_dcFailedNodes = new Hashtable(ma_activeNodes.length);
        runCmd = CRSDeconfig.generatePerlCommand(props);
        try {
            bcrsStatus = CRSDeconfig.isHAStoppedAndCleaned(runCmd, m_localNode, false);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            bcrsStatus = false;
            Trace.out(ce);
        }
        if (!bcrsStatus) {
            Trace.out("Run roothas.pl -deconfig command");
            if (!m_execAutoScript) {
                CRSDeconfig.showMessage("---------------------------------------->");
            }
            boolean bHADeconfigured = false;
            while (!bHADeconfigured) {
                bHADeconfigured = CRSDeconfig.runHACommand(props, runCmd);
                Trace.out("Verifying the command status...");
                bHADeconfigured = CRSDeconfig.verifyHACommand(props, runCmd, bHADeconfigured);
            }
        }
    }

    private static void copyDCToolToNode(String node) {
        String failMsg;
        Trace.out("Copying DC tool to cluster remote nodes");
        String srcDir = m_dcToolPath;
        String destDir = m_tmpDir;
        ClusterCmd cmd = new ClusterCmd();
        String[] nodes = new String[]{node};
        try {
            cmd.removeDirectory(nodes, m_dcToolPath, true);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            Trace.out("Failed to remove " + m_dcToolPath + " from " + node + ":" + m_dcToolPath);
            Trace.out(ce);
            failMsg = ce.getMessage();
            if (m_dcFailedNodes.containsKey(node)) {
                failMsg = failMsg + m_dcFailedNodes.get(node);
            }
            m_dcFailedNodes.put(node, failMsg);
        }
        try {
            String exclFileList = m_dcToolPath + Constants.FILE_SEPARATOR + "crs" + Constants.FILE_SEPARATOR + "install" + Constants.FILE_SEPARATOR + "install.excl";
            cmd.transferDirToNodes(nodes, m_dcToolPath, exclFileList);
            Trace.out("The directory \"" + m_dcToolPath + "\" is transfered to node:" + node + " successfully");
            if (m_dcFailedNodes.containsKey(node)) {
                m_dcFailedNodes.remove(node);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            Trace.out("Failed to transfer " + m_dcToolPath + " to " + node + ":" + m_dcToolPath);
            Trace.out(rfoe);
            failMsg = rfoe.getMessage();
            if (m_dcFailedNodes.containsKey(node)) {
                failMsg = failMsg + m_dcFailedNodes.get(node);
            }
            m_dcFailedNodes.put(node, failMsg);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            Trace.out("Failed to transfer " + m_dcToolPath + " to " + node + ":" + m_dcToolPath);
            Trace.out(ce);
            failMsg = ce.getMessage();
            if (m_dcFailedNodes.containsKey(node)) {
                failMsg = failMsg + m_dcFailedNodes.get(node);
            }
            m_dcFailedNodes.put(node, failMsg);
        }
    }

    private static void copyCRSConfigFile(Properties props) {
        Trace.out("Copying crsconfig_params file if exists in CRS home");
        String crsConfigFile = "crs" + Constants.FILE_SEPARATOR + "install" + Constants.FILE_SEPARATOR + "crsconfig_params";
        String oracleHome = props.getProperty("ORACLE_HOME");
        Trace.out("ORACLE_HOME = " + oracleHome);
        String dcToolPath = System.getProperty("LOGDIR");
        if (dcToolPath == null) {
            dcToolPath = System.getProperty("user.dir");
        }
        String srcCRSConfigFile = oracleHome + Constants.FILE_SEPARATOR + crsConfigFile;
        String destCRSConfigFile = dcToolPath + Constants.FILE_SEPARATOR + "crsconfig_params";
        Trace.out("srcCRSConfigFile = " + srcCRSConfigFile);
        Trace.out("destCRSConfigFile = " + destCRSConfigFile);
        ClusterCmd cmd = new ClusterCmd();
        try {
            if (new File(srcCRSConfigFile).exists()) {
                Trace.out("Copying " + srcCRSConfigFile + " to " + destCRSConfigFile);
                cmd.copyFileToNode(srcCRSConfigFile, "localnode", destCRSConfigFile);
            } else {
                String destCRSConfigSBSFile = destCRSConfigFile + ".sbs";
                Trace.out("Copying " + destCRSConfigSBSFile + " to " + destCRSConfigFile);
                cmd.copyFileToNode(destCRSConfigSBSFile, "localnode", destCRSConfigFile);
            }
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            Trace.out(ce.getMessage());
        }
    }

    private static boolean isCRSStoppedAndCleaned(String scriptName, String node, boolean bShow) throws oracle.ops.mgmt.cluster.ClusterException {
        Trace.out("Checking if CRS stack is stopped and cleaned on node: " + node);
        ClusterwareInfo cwi = new ClusterwareInfo();
        try {
            if (cwi.isCRSConfigured(m_crsHome, node) && cwi.isCRSRunning(m_crsHome, node)) {
                return false;
            }
        }
        catch (InstallException ie) {
            Trace.out(ie);
        }
        StringBuffer pathsChecked = new StringBuffer();
        boolean bFilesExists = false;
        Trace.out("Checking if node: " + node + " is accessible");
        CRSDeconfig.isNodeAlive(node);
        Trace.out("The node: " + node + " is accessible");
        if (s_nativeSystem.isUnixSystem()) {
            String[] filesToCheck = new String[]{"init.ohasd"};
            String[] dirsToCheck = new String[]{"scls_scr"};
            String initBase = "/etc/init.d";
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("HP-UX") || osName.equalsIgnoreCase("OSF1")) {
                initBase = "/sbin/init.d";
            } else if (osName.equalsIgnoreCase("AIX")) {
                initBase = "/etc";
            }
            try {
                String pathToCheck;
                for (int i = 0; i < filesToCheck.length; ++i) {
                    pathToCheck = initBase + Constants.FILE_SEPARATOR + filesToCheck[i];
                    if (!s_nativeSystem.pathExists(node, pathToCheck, 2)) continue;
                    pathsChecked.append(pathToCheck);
                    Trace.out("Path " + pathToCheck + " exists");
                    bFilesExists |= true;
                }
                String sclsBase = "/var/opt/oracle";
                for (int i = 0; i < dirsToCheck.length; ++i) {
                    pathToCheck = sclsBase + Constants.FILE_SEPARATOR + dirsToCheck[i];
                    if (!s_nativeSystem.pathExists(node, pathToCheck, 1)) continue;
                    pathsChecked.append(pathToCheck);
                    Trace.out("Path " + pathToCheck + " exists");
                    bFilesExists |= true;
                }
                int dotIdx = node.indexOf(".");
                String host = dotIdx != -1 ? node.substring(0, dotIdx) : node;
                String olrLoc = m_crsHome + Constants.FILE_SEPARATOR + "cdata" + Constants.FILE_SEPARATOR + host.toLowerCase() + ".olr";
                Trace.out("Olr path is " + olrLoc);
                if (s_nativeSystem.pathExists(node, olrLoc, 2)) {
                    pathsChecked.append(olrLoc);
                    Trace.out("OLR location " + olrLoc + " exists");
                    bFilesExists |= true;
                }
            }
            catch (Exception e) {
                Trace.out(e);
            }
        } else {
            String OLRLocationKey = s_nativeSystem.getOLRConfigLocation(node, new Version());
            String OCRLocationKey = s_nativeSystem.getConfigLocation(new Version());
            String SCRLocationKey = "HKEY_LOCAL_MACHINE\\Software\\Oracle\\Scr";
            ClusterWindows cw = new ClusterWindows();
            if (cw.regKeyExistsOnNode(OLRLocationKey, node) || cw.regKeyExistsOnNode(OCRLocationKey, node) || cw.regKeyExistsOnNode(SCRLocationKey, node)) {
                Trace.out("Registry keys exist");
                bFilesExists = true;
            } else {
                bFilesExists = false;
            }
        }
        if (bFilesExists) {
            if (bShow) {
                Object[] args = new String[]{scriptName, pathsChecked.toString()};
                String string = m_msgUBundle.getMessage("1015", false, args);
            }
            Trace.out("CRS is NOT stopped and cleaned on node " + node);
            return false;
        }
        Trace.out("CRS is stopped and cleaned on node " + node);
        return true;
    }

    private static boolean isHAStoppedAndCleaned(String scriptName, String node, boolean bShow) throws oracle.ops.mgmt.cluster.ClusterException {
        Trace.out("Checking if SIHA stack is stopped and cleaned up properly");
        ClusterwareInfo cwi = new ClusterwareInfo();
        try {
            if (cwi.isHARunning(m_crsHome, node)) {
                return false;
            }
        }
        catch (InstallException ie) {
            Trace.out(ie);
        }
        NativeSystem s_nativeSystem = new SystemFactory().CreateSystem();
        StringBuffer pathsChecked = new StringBuffer();
        boolean bFilesExists = false;
        Trace.out("Checking if node: " + node + " is accessible");
        CRSDeconfig.isNodeAlive(node);
        Trace.out("The node: " + node + " is accessible");
        if (s_nativeSystem.isUnixSystem()) {
            String[] filesToCheck = new String[]{"init.ohasd"};
            String[] dirsToCheck = new String[]{"scls_scr"};
            String initBase = "/etc/init.d";
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("HP_UX") || osName.equalsIgnoreCase("OSF1")) {
                initBase = "/sbin/init.d";
            } else if (osName.equalsIgnoreCase("AIX")) {
                initBase = "/etc";
            }
            try {
                String pathToCheck;
                for (int i = 0; i < filesToCheck.length; ++i) {
                    pathToCheck = initBase + Constants.FILE_SEPARATOR + filesToCheck[i];
                    if (!s_nativeSystem.pathExists(node, pathToCheck, 2)) continue;
                    pathsChecked.append(pathToCheck);
                    bFilesExists |= true;
                }
                String sclsBase = "/var/opt/oracle";
                for (int i = 0; i < dirsToCheck.length; ++i) {
                    pathToCheck = sclsBase + Constants.FILE_SEPARATOR + dirsToCheck[i];
                    if (!s_nativeSystem.pathExists(node, pathToCheck, 1)) continue;
                    pathsChecked.append(pathToCheck);
                    bFilesExists |= true;
                }
            }
            catch (Exception e) {
                Trace.out(e);
            }
        } else {
            bFilesExists = false;
        }
        if (bFilesExists) {
            if (bShow) {
                Object[] args = new String[]{scriptName, pathsChecked.toString()};
                String string = m_msgUBundle.getMessage("1015", false, args);
            }
            return false;
        }
        return true;
    }

    private static boolean isOCRDDed(String scriptName, String node) {
        String pathToCheck;
        boolean bCleanOCR;
        block19: {
            Trace.out("Checking if OCR is dd'ed to remove Oracledata");
            NativeSystem s_nativeSystem = new SystemFactory().CreateSystem();
            bCleanOCR = true;
            pathToCheck = null;
            String ocrSaveFile = null;
            if (s_nativeSystem.isUnixSystem()) {
                String ocrBase = "/etc/oracle";
                String osName = System.getProperty("os.name");
                if (osName.equalsIgnoreCase("HP_UX") || osName.equalsIgnoreCase("SunOS") || osName.equalsIgnoreCase("OSF1")) {
                    ocrBase = "/var/opt/oracle";
                }
                pathToCheck = ocrBase + Constants.FILE_SEPARATOR + "ocr.loc";
                ocrSaveFile = "/tmp/install/ocr.loc";
                try {
                    OCRInfo ocrInfo;
                    String olsNodesPath;
                    if (!s_nativeSystem.pathExists(node, pathToCheck, 2)) {
                        bCleanOCR = !s_nativeSystem.pathExists(node, ocrSaveFile, 2);
                        break block19;
                    }
                    Trace.out("Checking the OCR cleanup");
                    String crsbin = m_oracleHome + Constants.FILE_SEPARATOR + "bin";
                    File ohFile = new File(crsbin);
                    if (!ohFile.exists()) {
                        Trace.out("Creating directory: " + crsbin);
                        ohFile.mkdirs();
                    }
                    if (!(ohFile = new File(olsNodesPath = crsbin + Constants.FILE_SEPARATOR + "olsnodes")).exists()) {
                        Trace.out("Creating file: " + olsNodesPath);
                        try {
                            ohFile.createNewFile();
                        }
                        catch (IOException ie) {
                            Trace.out(ie.getMessage());
                        }
                    }
                    try {
                        Trace.out("Oracle home = " + m_oracleHome);
                        ClusterInfo ci = new ClusterInfo(m_oracleHome);
                        Trace.out("Reading OCR locations used");
                        ocrInfo = ClusterInfo.getOCRLocations(new Version());
                    }
                    catch (ClusterInfoException ce) {
                        Trace.out(ce);
                        ocrInfo = null;
                    }
                    if (ocrInfo != null) {
                        File ocrFile;
                        String ocrLocation;
                        pathToCheck = ocrLocation = ocrInfo.getDisk();
                        if (ocrLocation != null) {
                            ocrFile = new File(ocrLocation);
                            Trace.out("Checking OCR file: " + ocrLocation);
                            if (ocrFile.exists() && ocrFile.canWrite()) {
                                Trace.out("OCR file: " + ocrLocation + " is clean");
                                bCleanOCR &= true;
                            } else {
                                bCleanOCR &= false;
                            }
                        }
                        if ((ocrLocation = ocrInfo.getMirrorDisk()) != null) {
                            ocrFile = new File(ocrLocation);
                            Trace.out("Checking OCR file: " + ocrLocation);
                            if (ocrFile.exists() && ocrFile.canWrite()) {
                                Trace.out("OCR file: " + ocrLocation + " is clean");
                                bCleanOCR &= true;
                            } else {
                                bCleanOCR &= false;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Trace.out(e);
                }
            }
        }
        Trace.out("bCleanOCR = " + bCleanOCR);
        if (!bCleanOCR) {
            Object[] args = new String[]{scriptName, pathToCheck};
            String mesg = m_msgUBundle.getMessage("1015", false, args);
            return false;
        }
        return true;
    }

    private static void showMessage(String msg) {
        System.out.println();
        System.out.println(msg);
        System.out.flush();
    }

    private static void verifyRACDatabases() throws FatalException {
        Trace.out("Checking for existance of admin based databases");
        List<String> dbs = null;
        try {
            ClusterwareInfo cwInfo = new ClusterwareInfo();
            dbs = cwInfo.getHAManagedAdminDatabases(m_localNode);
        }
        catch (InvalidArgsException iae) {
            Trace.out(iae);
        }
        catch (InstallException ie) {
            Trace.out(ie);
        }
        if (dbs != null && dbs.size() > 0) {
            String mesg = m_sihaStack ? m_msgUBundle.getMessage("1039", false) : m_msgUBundle.getMessage("1025", false);
            Trace.out(mesg);
            m_summaryTextList.add(mesg);
            throw new FatalException(mesg);
        }
    }

    private static boolean checkSharedNess(String home) {
        Trace.out("Checking sharedness of home: " + home);
        boolean bShared = false;
        try {
            bShared = Cluster.isSharedPath(home, ma_activeNodes, m_localNode);
        }
        catch (SharedDeviceException sde) {
            Trace.out(sde);
        }
        catch (InvalidNodeListException ine) {
            Trace.out(ine);
        }
        return bShared;
    }

    private static void printSummary(Properties props) {
        Trace.out("Printing CRS VIP details");
        Trace.out("nodes = " + ma_activeNodes.length);
        if (ma_activeNodes != null) {
            Object[] args = new String[4];
            for (int i = 0; i < ma_activeNodes.length; ++i) {
                String vipName = props.getProperty("VIP_" + ma_activeNodes[i].toUpperCase() + "_IP");
                String vipIF = props.getProperty("VIP_" + ma_activeNodes[i].toUpperCase() + "_IF");
                String vipMask = props.getProperty("VIP_" + ma_activeNodes[i].toUpperCase() + "_MASK");
                Trace.out("IP(" + ma_activeNodes[i] + ") = " + vipName);
                Trace.out("IF(" + ma_activeNodes[i] + ") = " + vipIF);
                Trace.out("Mask(" + ma_activeNodes[i] + ") = " + vipMask);
                if (vipName == null) continue;
                args[0] = ma_activeNodes[i];
                args[1] = vipName;
                args[2] = vipIF;
                args[3] = vipMask;
                String mesg = m_msgUBundle.getMessage("1020", false, args);
                m_summaryTextList.add(mesg);
                vipMask = "";
                vipIF = "";
                vipName = "";
            }
        }
    }

    private static void copyFileToNode(String srcFile, String node, String destFile) throws oracle.ops.mgmt.cluster.ClusterException {
        ClusterCmd cmd = new ClusterCmd();
        Trace.out("Checking if node: " + node + " is accessible");
        CRSDeconfig.isNodeAlive(node);
        Trace.out("Copying file:" + srcFile + " to " + node + ":" + destFile);
        cmd.copyFileToNode(srcFile, node, destFile);
        Trace.out("Done: Copying file:" + srcFile + " to " + node + ":" + destFile);
    }

    private static void isNodeAlive(String nodeName) throws oracle.ops.mgmt.cluster.ClusterException {
        ClusterCmd cmd = new ClusterCmd();
        String[] nodes = new String[]{nodeName};
        boolean bAlive = true;
        try {
            bAlive = cmd.areNodesAlive(nodes, 10, null);
        }
        catch (RemoteFileOperationException rfe) {
            new oracle.ops.mgmt.cluster.ClusterException(rfe.getMessage());
        }
        if (!bAlive) {
            Object[] args = new String[]{nodeName};
            throw new oracle.ops.mgmt.cluster.ClusterException(m_msgUBundle.getMessage("1029", false, args));
        }
    }

    private static void removeFileFromNode(String file, String node) {
        Trace.out("Removing file " + file);
        ClusterCmd cmd = new ClusterCmd();
        try {
            cmd.removeFileFromNode(node, file);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            Trace.out("Error removing file " + file);
            Trace.out(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCRSConfigParamfile(Properties props) {
        Trace.out("Reading properties defined in file crsconfig_params");
        String dcToolPath = props.getProperty("LOGDIR");
        if (dcToolPath == null) {
            dcToolPath = System.getProperty("user.dir");
        }
        Trace.out("Setting deinstall home location " + dcToolPath + " to the parameter DC_HOME");
        props.setProperty(DC_HOME_PROPERTY, dcToolPath);
        String crsconfigFile = dcToolPath + Constants.FILE_SEPARATOR + "crsconfig_params";
        Trace.out("crsconfigFile = " + crsconfigFile);
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String line;
            fr = new FileReader(crsconfigFile);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String lineTrimRes = line.trim();
                boolean processThisLine = !lineTrimRes.startsWith("#") && !lineTrimRes.equals("");
                String[] pair = line.split("=");
                boolean bl = processThisLine = processThisLine && pair != null;
                if (processThisLine) {
                    Trace.out(pair[0] + "=" + (pair.length > 1 ? pair[1] : ""));
                    String value = props.getProperty(pair[0]);
                    if (value == null) {
                        if (pair.length > 1 && pair[1].trim().startsWith("%") && pair[1].trim().endsWith("%")) {
                            Trace.out("Unset attribute:" + pair[0] + "=" + (pair.length > 1 ? pair[1] : ""));
                            continue;
                        }
                        Trace.out("Setting property: " + pair[0] + " to value: " + (pair.length > 1 ? pair[1] : ""));
                        props.setProperty(pair[0].trim(), (pair.length > 1 ? pair[1] : "").trim());
                        continue;
                    }
                    Trace.out("Property name: " + pair[0] + " ia already set to value: " + value);
                    continue;
                }
                Trace.out("Not processed line: " + line);
            }
        }
        catch (FileNotFoundException fnfe) {
            Trace.out(fnfe);
        }
        catch (IOException ie) {
            Trace.out(ie);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException fnfe) {}
        }
    }

    private static boolean execRootScriptAuto(String[] nodeList, Properties props) {
        ConfigurationSetupFactory csFact = ConfigurationSetupFactory.getInstance();
        try {
            ConfigurationSetup csObj = csFact.getConfigSetupInstance(m_crsHome);
            HashMap resultMap = new HashMap();
            String[] localNode = new String[1];
            boolean remtExecStatus = true;
            Object[] msgArgs = new String[1];
            if (!s_nativeSystem.isUnixSystem()) {
                String script = m_crsHome + sConstants.SCRIPT_WIN;
                String[] args = new String[5];
                args[0] = "-deconfig";
                args[1] = "-force";
                args[2] = "-paramfile";
                args[3] = "\"" + m_crsconfigParamFile + "\"";
                if (nodeList != null) {
                    try {
                        Trace.out("Executing root script on remote nodes");
                        msgArgs[0] = oracle.cluster.impl.util.Utils.strArrToString(nodeList, ",");
                        CRSDeconfig.showMessage(m_msgUBundle.getMessage("1058", false, msgArgs));
                        csObj.runScript(nodeList, script, args, null, resultMap);
                    }
                    catch (ConfigException ce) {
                        remtExecStatus = false;
                        Trace.out(ce.getMessage());
                    }
                    catch (ClusterException cle) {
                        remtExecStatus = false;
                        Trace.out(cle.getMessage());
                    }
                    catch (CompositeOperationException coe) {
                        remtExecStatus = false;
                        Trace.out(coe.getMessage());
                    }
                }
                if (remtExecStatus) {
                    localNode[0] = m_localNode;
                    if (!m_sihaStack && m_dcFailedNodes.size() == 0 && !m_localDC) {
                        args[4] = "-lastnode";
                    }
                    try {
                        Trace.out("Executing root script on local node " + m_localNode);
                        msgArgs[0] = oracle.cluster.impl.util.Utils.strArrToString(localNode, ",");
                        CRSDeconfig.showMessage(m_msgUBundle.getMessage("1058", false, msgArgs));
                        csObj.runScript(localNode, script, args, null, resultMap);
                    }
                    catch (ConfigException ce) {
                        Trace.out(ce.getMessage());
                    }
                    catch (ClusterException cle) {
                        Trace.out(cle.getMessage());
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out(coe.getMessage());
                    }
                }
            }
            ArrayList<String> failedNodes = new ArrayList<String>();
            for (String node : resultMap.keySet()) {
                NodeStatus ns = (NodeStatus)resultMap.get(node);
                Trace.out("Execution result for " + node + "::");
                if (null == ns) continue;
                Trace.out("Status: " + ns.getStatus() + "Output: " + ns.getStdOut() + "Error: " + ns.getStdErr() + "Exitcode: " + ns.getExitCode() + "Exception: " + ns.getExceptionMesg());
                if (ns.getStatus() && 0 == ns.getExitCode()) continue;
                msgArgs[0] = node;
                CRSDeconfig.showMessage(m_msgUBundle.getMessage("1059", false, msgArgs));
                CRSDeconfig.showMessage(ns.getStdOut());
                failedNodes.add(node);
            }
            if (!failedNodes.isEmpty()) {
                String[] failedNodesArr = new String[failedNodes.size()];
                failedNodes.toArray(failedNodesArr);
                msgArgs[0] = oracle.cluster.impl.util.Utils.strArrToString(failedNodesArr, ",");
                Trace.out("Nodes failing are " + msgArgs[0]);
                CRSDeconfig.showMessage(m_msgUBundle.getMessage("1059", true, msgArgs));
                CRSDeconfig.showMessage(m_msgUBundle.getCause("1059", false));
                CRSDeconfig.showMessage(m_msgUBundle.getAction("1059", false));
                return false;
            }
        }
        catch (ConfigException ce) {
            Trace.out("Failed to get the ConfigSetup Instance , aborting the automated run of root scripts" + ce.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePropertyValues(Properties props) {
        Trace.out("Saving properties into file paramfile.crs");
        BufferedWriter bw = null;
        String saveDir = props.getProperty("LOGDIR");
        String crsconfigFile = saveDir + Constants.FILE_SEPARATOR + "crsparams.saved";
        Trace.out("crsconfigFile = " + crsconfigFile);
        try {
            bw = new BufferedWriter(new FileWriter(crsconfigFile));
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                String prop = name + "=\"" + value + "\"";
                Trace.out("Writing prop = " + prop);
                bw.write(prop, 0, prop.length());
                bw.newLine();
            }
        }
        catch (IOException ie) {
            Trace.out(ie);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void verifyMemberClusters() throws FatalException {
        if (m_localDC) {
            Trace.out("Skip check for Client Clusters for local deinstall or delete node");
            return;
        }
        Map<String, List<ClientClusterComponent>> ccList = null;
        try {
            ClusterwareInfo cwi = new ClusterwareInfo();
            ccList = cwi.getClientClusterswithComp();
        }
        catch (InstallException ie) {
            Trace.out(ie);
        }
        catch (NotExistsException ne) {
            Trace.out("Ignorning NotExistsException, no client clusters exist");
            Trace.out(ne.getMessage());
            return;
        }
        if (ccList != null && ccList.size() > 0) {
            String ccNames = null;
            StringBuilder sb = new StringBuilder();
            for (String key : ccList.keySet()) {
                List<ClientClusterComponent> valList = ccList.get(key);
                if (ccNames == null) {
                    ccNames = key;
                    sb.append(key);
                    for (ClientClusterComponent val : valList) {
                        sb.append(" " + (Object)((Object)val));
                    }
                    continue;
                }
                sb.append("," + key);
                for (ClientClusterComponent val : valList) {
                    sb.append(" " + (Object)((Object)val));
                }
            }
            ccNames = sb.toString();
            String mesg = m_msgUBundle.getMessage("1063", true, new Object[]{ccNames});
            Trace.out(mesg);
            m_summaryTextList.add(mesg);
            throw new FatalException(mesg);
        }
    }

    public static void main(String[] args) {
        Trace.out("Calling checkConfig");
        Properties props = new Properties();
        props.setProperty("ORA_CRS_HOME", args[0]);
        props.setProperty("ORACLE_HOME", args[0]);
        props.setProperty("PARAM_FILE_NAME", "paramfile.crs");
        Trace.out("args.length = " + args.length);
        if (args.length > 1 && args[1].equalsIgnoreCase("-silent")) {
            props.setProperty("silentFlag", "true");
        }
        Trace.out("Checking configuration of CRS home");
        try {
            CRSDeconfig.checkConfig(props);
        }
        catch (FatalException fe) {
            Trace.out(fe);
        }
        CRSDeconfig.savePropertyValues(props);
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Trace.out("Name: " + name + " value = " + props.getProperty(name));
        }
        Trace.out("Cleaning configuration of CRS home");
        try {
            CRSDeconfig.cleanConfig(props);
        }
        catch (FatalException fe) {
            Trace.out(fe);
        }
    }

    static {
        m_crsconfigParamFile = "crsconfig_params";
        m_crsCmdFileName = "rootcrs.sh";
        m_haCmdFileName = "roothas.sh";
        m_silent = false;
        m_localDC = false;
        m_localDCInvalid = false;
        m_sihaStack = false;
        m_execAutoScript = false;
        m_isUnlock = false;
        m_msgVBundle = MessageBundle.getMessageBundle("Prkv");
        m_msgUBundle = MessageBundle.getMessageBundle("Prku");
        s_nativeSystem = new SystemFactory().CreateSystem();
    }
}

