/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.viprange;

import java.io.Serializable;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.Binary;
import oracle.ops.mgmt.viprange.DottedDecimalBinaryConverter;

public class VIPRangeConfiguration
implements Constants,
Serializable {
    private Binary m_netmask;
    private Vector m_IPAddresses;
    private static final MessageBundle s_cluMsgBundle = MessageBundle.getMessageBundle("Prkc");

    public VIPRangeConfiguration(Binary netmask, Binary[] ipAddrs) throws VirtualIPException {
        DottedDecimalBinaryConverter converter = new DottedDecimalBinaryConverter(netmask);
        if (!converter.isValidNetmask()) {
            Object[] args = new String[]{netmask.toString()};
            throw new VirtualIPException(s_cluMsgBundle.getMessage("1024", true, args));
        }
        Trace.out("netmask is " + netmask.toString());
        this.m_netmask = netmask;
        this.m_IPAddresses = new Vector();
        for (int i = 0; i < ipAddrs.length; ++i) {
            Trace.out("ip element " + ipAddrs[i].toString());
            this.m_IPAddresses.addElement(ipAddrs[i]);
        }
    }

    public void addVIP(Binary ip) {
        if (!this.m_IPAddresses.contains(ip)) {
            this.m_IPAddresses.addElement(ip);
        }
    }

    public void deleteVIP(Binary ip) {
        this.m_IPAddresses.removeElement(ip);
    }

    public Binary getNetmask() {
        return this.m_netmask;
    }

    public Binary[] getIPAddresses() {
        Object[] ipAddrArray = new Binary[this.m_IPAddresses.size()];
        this.m_IPAddresses.copyInto(ipAddrArray);
        return ipAddrArray;
    }
}

