/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.viprange;

import java.util.Arrays;
import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.Binary;
import oracle.ops.mgmt.viprange.DottedDecimalBinaryConverter;

public class VIPAddressRange {
    private VIPAddress m_startIP;
    private VIPAddress m_endIP;
    private int m_count;
    private Binary m_startBinaryIP;
    private Binary m_endBinaryIP;
    private Binary m_netmaskBinaryIP;

    public VIPAddressRange(Binary startIP, Binary endIP, Binary netmask) throws VirtualIPException {
        this.m_startBinaryIP = startIP;
        this.m_endBinaryIP = endIP;
        this.m_netmaskBinaryIP = netmask;
        String netmaskStringIP = this.convertToDottedDecimalString(netmask);
        this.m_startIP = new VIPAddress(this.convertToDottedDecimalString(startIP), netmaskStringIP, null);
        this.m_endIP = new VIPAddress(this.convertToDottedDecimalString(endIP), netmaskStringIP, null);
        this.checkRange();
        this.m_count = this.getBinaryIPAddresses().length;
    }

    public VIPAddressRange(VIPAddress startIP, VIPAddress endIP) throws VirtualIPException {
        this.m_startIP = startIP;
        this.m_startBinaryIP = this.convertToBinary(startIP.getAddressAsString());
        this.m_endIP = endIP;
        this.m_endBinaryIP = this.convertToBinary(endIP.getAddressAsString());
        this.m_netmaskBinaryIP = this.convertToBinary(startIP.getNetmask());
        this.checkRange();
        this.m_count = this.getBinaryIPAddresses().length;
    }

    public String getNetmask() {
        return this.m_startIP.getNetmask();
    }

    public Binary getBinaryNetmask() {
        return this.m_netmaskBinaryIP;
    }

    public VIPAddress getStartVIP() {
        return this.m_startIP;
    }

    public Binary getBinaryStartVIP() {
        return this.m_startBinaryIP;
    }

    public VIPAddress getEndVIP() {
        return this.m_endIP;
    }

    public Binary getBinaryEndVIP() {
        return this.m_endBinaryIP;
    }

    public int getAddressCount() {
        return this.m_count;
    }

    public String toString() {
        return this.getNetmask() + ":" + this.getStartVIP().getIPAddress().getHostAddress() + ":" + this.getEndVIP().getIPAddress().getHostAddress();
    }

    private Binary convertToBinary(String ip) {
        return new DottedDecimalBinaryConverter(ip).getBinary();
    }

    private String convertToDottedDecimalString(Binary ip) {
        return new DottedDecimalBinaryConverter(ip).getDottedDecimal();
    }

    private void checkRange() throws VirtualIPException {
        String binNetworkID2;
        if (!this.m_startIP.getNetmask().equals(this.m_endIP.getNetmask())) {
            throw new VirtualIPException(MessageBundle.getMessageBundle("Prka").getMessage("2005", true));
        }
        int lengthNetworkID = this.m_netmaskBinaryIP.toString().lastIndexOf("1") + 1;
        String binNetworkID1 = this.m_startBinaryIP.toString().substring(0, lengthNetworkID);
        if (!binNetworkID1.equals(binNetworkID2 = this.m_endBinaryIP.toString().substring(0, lengthNetworkID))) {
            throw new VirtualIPException(MessageBundle.getMessageBundle("Prka").getMessage("2006", true));
        }
        if (Binary.compare(this.m_startBinaryIP, this.m_endBinaryIP) > 0) {
            throw new VirtualIPException(MessageBundle.getMessageBundle("Prka").getMessage("2017", true));
        }
    }

    public Binary[] getBinaryIPAddresses() {
        int len = this.m_startBinaryIP.length();
        String startStr = this.m_startBinaryIP.toString();
        String endStr = this.m_endBinaryIP.toString();
        if (Binary.compare(this.m_startBinaryIP, this.m_endBinaryIP) > 0) {
            Trace.out("no ip in the range");
            return null;
        }
        if (Binary.compare(this.m_startBinaryIP, this.m_endBinaryIP) == 0) {
            Trace.out("single ip in the range");
            Binary[] result = new Binary[]{this.m_startBinaryIP};
            return result;
        }
        int count = (int)Binary.subtract(this.m_endBinaryIP, this.m_startBinaryIP).intValue() + 1;
        Trace.out("#vips = " + count);
        Binary[] result = new Binary[count];
        for (int i = 0; i < count; ++i) {
            Binary increase = new Binary(i, len);
            result[i] = Binary.add(this.m_startBinaryIP, increase);
            Trace.out("result[" + i + "] = " + result[i]);
        }
        return result;
    }

    public static VIPAddressRange[] createAddressRanges(Binary[] ips, Binary netMask) throws VirtualIPException {
        Arrays.sort(ips);
        Vector<VIPAddressRange> rangeVector = new Vector<VIPAddressRange>();
        int startIP = 0;
        int curIP = 0;
        for (int i = 0; i < ips.length; ++i) {
            if (i == ips.length - 1) {
                rangeVector.addElement(new VIPAddressRange(ips[startIP], ips[i], netMask));
                continue;
            }
            if (ips[i].intValue() - ips[curIP].intValue() > 1L) {
                rangeVector.addElement(new VIPAddressRange(ips[startIP], ips[curIP], netMask));
                startIP = i;
                curIP = i;
                continue;
            }
            curIP = i;
        }
        int size = rangeVector.size();
        VIPAddressRange[] rangeArray = new VIPAddressRange[size];
        for (int i = 0; i < size; ++i) {
            rangeArray[i] = (VIPAddressRange)rangeVector.elementAt(i);
        }
        return rangeArray;
    }

    public boolean equals(Object range) {
        Trace.out("Calling equals object");
        if (range == null) {
            return false;
        }
        if (range instanceof VIPAddressRange) {
            return this.equals((VIPAddressRange)range);
        }
        return false;
    }

    public boolean equals(VIPAddressRange range) {
        Trace.out("starts match?" + this.getStartVIP().getAddressAsString() + " == " + range.getStartVIP().getAddressAsString());
        Trace.out("ends match?" + this.getEndVIP().getAddressAsString() + " == " + range.getEndVIP().getAddressAsString());
        Trace.out("netmasks match?" + this.getNetmask() + " == " + range.getNetmask());
        if (range == null) {
            return false;
        }
        return this.getStartVIP().equals(range.getStartVIP()) && this.getEndVIP().equals(range.getEndVIP()) && this.getNetmask().equals(range.getNetmask());
    }
}

