/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.synchronize;

import oracle.ops.mgmt.synchronize.BufferArray;
import oracle.ops.mgmt.synchronize.Semaphore;

public class SyncBuffer {
    protected final BufferArray buff;
    protected Semaphore empty;
    protected Semaphore full;

    public SyncBuffer(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.buff = new BufferArray(capacity);
        this.empty = new Semaphore(capacity, "SyncBufferEmpty");
        this.full = new Semaphore(0, "SyncBufferFull");
    }

    public void put(Object elem) throws InterruptedException {
        this.empty.acquire();
        this.buff.insert(elem);
        this.full.release();
    }

    public Object get() throws InterruptedException {
        this.full.acquire();
        Object x = this.buff.extract();
        this.empty.release();
        return x;
    }

    public Object getElementAt(int index) {
        return this.buff.getElementAt(index);
    }

    public Object[] read() {
        return this.buff.read();
    }

    public void clearAll() {
        this.buff.clearAll();
        this.empty = new Semaphore(this.buff.getCapacity(), "SyncBufferEmpty");
        this.full = new Semaphore(0, "SyncBufferFull");
    }

    public int getFillCount() {
        return this.buff.getFillCount();
    }

    public int getCapacity() {
        return this.buff.getCapacity();
    }

    public Object[] getAll() {
        return this.buff.getAll();
    }

    public Object[] getAllElements() {
        return this.buff.getAllElements();
    }
}

