/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.synchronize;

import oracle.ops.mgmt.trace.Trace;

public class Semaphore {
    private static int s_num = 0;
    private int m_count;
    private String m_semid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Semaphore(int initialCount) {
        this.m_count = initialCount;
        Class<Semaphore> clazz = Semaphore.class;
        synchronized (Semaphore.class) {
            this.m_semid = "Semaphore" + s_num;
            ++s_num;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Semaphore(int initialCount, String name) {
        this.m_count = initialCount;
        this.m_semid = name;
    }

    public synchronized boolean release() {
        ++this.m_count;
        Trace.out(this.m_semid + ":Release called by thread " + Thread.currentThread().getName() + " m_count=" + this.m_count);
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            Trace.out(this.m_semid + ":Acquire called by thread " + Thread.currentThread().getName() + " m_count=" + this.m_count);
            try {
                while (this.m_count <= 0) {
                    this.wait();
                }
                --this.m_count;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public boolean acquire(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            Trace.out(this.m_semid + ":Timed Acquire called by thread " + Thread.currentThread().getName() + " m_count=" + this.m_count);
            if (this.m_count > 0) {
                --this.m_count;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            try {
                long now;
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this.m_count <= 0) continue;
                    --this.m_count;
                    return true;
                } while ((waitTime = msecs - ((now = System.currentTimeMillis()) - startTime)) > 0L);
                Trace.out(this.m_semid + "Timeout " + Thread.currentThread().getName());
                return false;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(int num) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.m_count - num < 0) {
                    this.wait();
                }
                this.m_count -= num;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(boolean bool) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                --this.m_count;
                while (this.m_count < 0) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public String getID() {
        return this.m_semid;
    }
}

