/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.synchronize;

public class BufferArray {
    protected final Object[] array;
    protected int putPtr = 0;
    protected int getPtr = 0;
    protected int fillCount = 0;

    public BufferArray(int capacity) {
        this.array = new Object[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.array[i] = null;
        }
    }

    public synchronized void insert(Object elem) {
        this.array[this.putPtr] = elem;
        ++this.fillCount;
        this.putPtr = (this.putPtr + 1) % this.array.length;
    }

    public synchronized Object extract() {
        Object x = this.array[this.getPtr];
        this.array[this.getPtr] = null;
        --this.fillCount;
        this.getPtr = (this.getPtr + 1) % this.array.length;
        return x;
    }

    public synchronized Object[] read() {
        return this.array;
    }

    public Object getElementAt(int index) {
        return this.array[index];
    }

    public synchronized Object[] getAll() {
        Object[] filledArray = new Object[this.fillCount];
        int j = 0;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            filledArray[j++] = this.array[i];
            this.array[i] = null;
            --this.fillCount;
            this.getPtr = (this.getPtr + 1) % this.array.length;
        }
        return filledArray;
    }

    public synchronized Object[] getAllElements() {
        Object[] filledArray = new Object[this.fillCount];
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] == null) continue;
            filledArray[i] = this.array[i];
        }
        return filledArray;
    }

    public synchronized void clearAll() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
        this.fillCount = 0;
    }

    public synchronized int getFillCount() {
        return this.fillCount;
    }

    public synchronized int getCapacity() {
        return this.array.length;
    }
}

