/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.synchronize;

import oracle.ops.mgmt.synchronize.Semaphore;

public class BinarySemaphore {
    private static int s_num = 0;
    private int m_count;
    private String m_semid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinarySemaphore(int initialCount) {
        if (initialCount > 1) {
            throw new IllegalArgumentException("Initial value must be either 1 or 0");
        }
        this.m_count = initialCount;
        Class<Semaphore> clazz = Semaphore.class;
        synchronized (Semaphore.class) {
            this.m_semid = "BinarySemaphore" + s_num;
            ++s_num;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public BinarySemaphore(int initialCount, String name) {
        if (initialCount > 1) {
            throw new IllegalArgumentException("Initial value must be either 1 or 0");
        }
        this.m_semid = name;
        this.m_count = initialCount;
    }

    public synchronized boolean release() {
        if (this.m_count < 1) {
            ++this.m_count;
        }
        this.notify();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        BinarySemaphore binarySemaphore = this;
        synchronized (binarySemaphore) {
            try {
                while (this.m_count <= 0) {
                    this.wait();
                }
                --this.m_count;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }

    public boolean acquire(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        BinarySemaphore binarySemaphore = this;
        synchronized (binarySemaphore) {
            if (this.m_count > 0) {
                --this.m_count;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            try {
                long now;
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this.m_count <= 0) continue;
                    --this.m_count;
                    return true;
                } while ((waitTime = msecs - ((now = System.currentTimeMillis()) - startTime)) > 0L);
                return false;
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
    }
}

