/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import oracle.ops.mgmt.asm.operation.ASMTreeDefinition;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.trace.Trace;

public class SRVMRecover
implements OCRKeyLiterals {
    private final String m_logRootKey;
    private static SRVMRecover s_srvmRecover = null;
    private OCR m_ocr = null;
    private OCRTreeDefinitionHA m_ocrTreeDef = null;

    private SRVMRecover(OCR ocr) throws OCRException {
        this.m_ocr = ocr;
        this.m_ocrTreeDef = new OCRTreeDefinitionHA();
        this.m_logRootKey = this.m_ocrTreeDef.getLogRootKey();
        Trace.out("SRVMRecover: Came in");
        try {
            this.m_ocr.createKey(this.m_logRootKey, 6, "DATABASE", null);
        }
        catch (OCRException oe) {
            Trace.out(oe.getMessage());
        }
        this.m_ocr.openKey(this.m_logRootKey);
        Trace.out("SRVMRecover: Successful in opening " + this.m_logRootKey);
        this.m_ocr.openKey("DATABASE");
        Trace.out("SRVMRecover: Done with init");
    }

    public static synchronized SRVMRecover init(OCR ocr) throws OCRException {
        if (s_srvmRecover == null) {
            s_srvmRecover = new SRVMRecover(ocr);
        }
        return s_srvmRecover;
    }

    public synchronized void setTreeDefinition(OCRTreeDefinitionHA treeDef) {
        this.m_ocrTreeDef = treeDef;
    }

    public synchronized void beginLog(String keyName, int operationId) throws OCRException {
        Integer secType = new Integer(0);
        Trace.out("SRVMRecover:beginLog: Came in");
        this.recover(keyName);
        String logComponent = this.getLogComponent(keyName, secType);
        this.m_ocr.openKey("DATABASE");
        String logValid = logComponent + "." + "VALID";
        String logKeyName = logComponent + "." + "KEY_NAME";
        String logKeyData = logComponent + "." + "DATA";
        String logOperationType = logComponent + "." + "OP_TYPE";
        try {
            this.m_ocr.deleteKey(logKeyName, true);
            this.m_ocr.deleteKey(logKeyData, true);
            this.m_ocr.deleteKey(logOperationType, true);
            this.m_ocr.deleteKey(logValid, true);
        }
        catch (OCRException oCRException) {
            // empty catch block
        }
        Trace.out("SRVMRecover:beginLog: Done deleting earlier keys");
        this.m_ocr.setKeyValue(logKeyName, keyName, 6, this.m_logRootKey, null);
        Trace.out("SRVMRecover:beginLog: Done creating " + logKeyName);
        if (this.m_ocr.keyExists(keyName)) {
            this.m_ocr.createKey(logKeyData, 6, this.m_logRootKey, null);
            Trace.out("SRVMRecover:beginLog: Done creating " + logKeyData);
            this.m_ocr.setKeyValue(logOperationType, Integer.toString(operationId), 3, 6, this.m_logRootKey, null);
            Trace.out("SRVMRecover:beginLog: Done creating " + logOperationType);
            this.m_ocr.copyRecurse(keyName, logKeyData, secType);
            Trace.out("SRVMRecover:beginLog: Done copy recurse");
        }
        this.m_ocr.createKey(logValid, 6, this.m_logRootKey, null);
        Trace.out("SRVMRecover:beginLog: Done");
    }

    public synchronized void recover(String keyName) throws OCRException {
        Integer secType = new Integer(0);
        Trace.out("SRVMRecover:recover: Enter [" + keyName + "]");
        String logComponent = this.getLogComponent(keyName, secType);
        this.m_ocr.openKey("DATABASE");
        String logValid = logComponent + "." + "VALID";
        String logKeyName = logComponent + "." + "KEY_NAME";
        String logKeyData = logComponent + "." + "DATA";
        if (!this.m_ocr.keyExists(logValid)) {
            Trace.out("SRVMRecover:recover: There is nothing to recover");
            return;
        }
        Trace.out("SRVMRecover:recover: There is something to recover");
        String recoverKeyName = this.m_ocr.getKeyValue(logKeyName);
        Trace.out("SRVMRecover:recover: recover key : [" + recoverKeyName + "]");
        if (this.m_ocr.keyExists(recoverKeyName)) {
            this.m_ocr.openKey(recoverKeyName);
            this.m_ocr.deleteKey(recoverKeyName, true);
        }
        if (this.m_ocr.keyExists(logKeyData)) {
            this.m_ocr.createKey(recoverKeyName, 5, null, null);
            this.m_ocr.copyRecurse(logKeyData, recoverKeyName, secType);
        }
        this.m_ocr.deleteKey(logValid, false);
    }

    public synchronized void endLog(String keyName) throws OCRException {
        Integer secType = new Integer(0);
        String logComponent = this.getLogComponent(keyName, secType);
        this.m_ocr.openKey("DATABASE");
        String logValid = logComponent + "." + "VALID";
        Trace.out("SRVMRecover: Begin end log for " + logComponent);
        this.m_ocr.deleteKey(logValid, false);
        Trace.out("SRVMRecover: Done end log");
    }

    private String getLogComponent(String keyName, Integer secType) throws OCRException {
        Trace.out("SRVMRecover:getLogComponent: Came in [" + keyName + "]");
        if (keyName.startsWith(this.m_ocrTreeDef.getNodeRootKey())) {
            Trace.out("SRVMRecover:getLogComponent: Log component [" + this.m_ocrTreeDef.getLogNodeAppsCompKey() + "]");
            secType = new Integer(3);
            return this.m_ocrTreeDef.getLogNodeAppsCompKey();
        }
        if (keyName.startsWith(this.m_ocrTreeDef.getVRangeRootKey())) {
            Trace.out("SRVMRecover:getLogComponaent: Log component [" + this.m_ocrTreeDef.getLogVRangeCompKey() + "]");
            secType = new Integer(4);
            return this.m_ocrTreeDef.getLogVRangeCompKey();
        }
        if (keyName.startsWith(this.m_ocrTreeDef.getDBRootKey())) {
            secType = new Integer(2);
            int startIndex = this.m_ocrTreeDef.getDBRootKey().length() + 1;
            String subStr = keyName.substring(startIndex);
            int endIndex = subStr.indexOf(".");
            if (endIndex == -1) {
                Trace.out("SRVMRecover:getLogComponaent: Log component [" + this.m_logRootKey + "." + subStr + "]");
                return this.m_logRootKey + "." + subStr;
            }
            Trace.out("SRVMRecover:getLogComponaent: Log component [" + this.m_logRootKey + "." + subStr.substring(0, endIndex) + "]");
            return this.m_logRootKey + "." + subStr.substring(0, endIndex);
        }
        if (this.m_ocrTreeDef instanceof ASMTreeDefinition && keyName.startsWith(((ASMTreeDefinition)this.m_ocrTreeDef).getASMRootKey())) {
            String asmRootKey = ((ASMTreeDefinition)this.m_ocrTreeDef).getASMRootKey();
            String asmLogRootKey = ((ASMTreeDefinition)this.m_ocrTreeDef).getASMRootKey(true);
            secType = new Integer(3);
            int startIndex = asmRootKey.length() + 1;
            Trace.out("startIndex=" + startIndex);
            String subStr = keyName.length() < startIndex ? null : keyName.substring(startIndex);
            if (subStr == null) {
                Trace.out("SRVMRecover:getLogComponent: Log component [" + asmLogRootKey + "]");
                return asmLogRootKey;
            }
            int endIndex = subStr.indexOf(".");
            if (endIndex == -1) {
                Trace.out("SRVMRecover:getLogComponent: Log component [" + asmLogRootKey + "." + subStr + "]");
                return asmLogRootKey + "." + subStr;
            }
            String asmInstSubStr = subStr.substring(endIndex + 1);
            if ((endIndex = asmInstSubStr.indexOf(".")) == -1) {
                Trace.out("SRVMRecover:getLogComponent: Log component [" + asmLogRootKey + "." + subStr + "]");
                return asmLogRootKey + "." + subStr;
            }
            Trace.out("SRVMRecover:getLogComponaent: Log component [" + asmLogRootKey + "." + subStr.substring(0, endIndex) + "]");
            return asmLogRootKey + "." + subStr.substring(0, endIndex);
        }
        throw new OCRException();
    }
}

