/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.OCRTreeHA;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class RawDeviceConfigHA
extends RawDeviceConfig
implements Constants {
    protected RawDeviceConfigHA(Version v) throws RawDeviceException {
        super(v);
        try {
            Trace.out("initializing RawDeviceConfig");
            this.m_ocrtree = (OCRTreeHA)OCRTree.init(v);
            if (this.m_ocrtree == null) {
                throw new RawDeviceException();
            }
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    @Override
    public synchronized void setNodeConfiguration(NodeConfiguration nodeConfig) throws RawDeviceException {
        try {
            this.m_ocrtree.setNodeConfiguration(nodeConfig);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    @Override
    public synchronized void setVIPRangeConfiguration(VIPRangeConfiguration vrConfig) throws RawDeviceException {
        try {
            this.m_ocrtree.setVIPRangeConfiguration(vrConfig);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    @Override
    public synchronized NodeConfiguration getNodeConfiguration(String nodeName) throws RawDeviceException {
        try {
            return this.m_ocrtree.getNodeConfiguration(nodeName);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    @Override
    public synchronized VIPRangeConfiguration[] getVIPRangeConfigurations() throws RawDeviceException {
        try {
            return this.m_ocrtree.getVIPRangeConfigurations();
        }
        catch (OCRException e) {
            Trace.out(e);
            throw new RawDeviceException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized void deleteInstance(String opsName, String instName) throws RawDeviceException {
        int i;
        Object resultString = null;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig == null) {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        int index = opsConfig.getIndexOf(instName);
        if (index < 0) {
            Object[] args = new Object[]{instName};
            String msg = s_rawMsgBundle.getMessage("1003", true, args);
            throw new RawDeviceException(msg);
        }
        Vector instances = opsConfig.getInstances();
        instances.removeElementAt(index);
        opsConfig.setInstances(instances);
        Vector services = opsConfig.getServices();
        Vector<ServiceComposite> servToGo = new Vector<ServiceComposite>();
        for (i = 0; i < services.size(); ++i) {
            ServiceComposite sc = (ServiceComposite)services.elementAt(i);
            if (sc.isAvailable(instName)) {
                sc.deleteAvailableInstance(instName);
            } else if (sc.isPreferred(instName)) {
                sc.deletePreferredInstance(instName);
            }
            if (sc.getPreferredInstances().length != 0) continue;
            servToGo.addElement(sc);
        }
        i = 0;
        while (true) {
            if (i >= servToGo.size()) {
                opsConfig.setServices(services);
                this.setConfiguration(opsConfig);
                return;
            }
            services.removeElement((ServiceComposite)servToGo.elementAt(i));
            ++i;
        }
    }

    @Override
    public void setResEnv(String dbName, String entityName, int resType, String[] envNames, String[] envVals) throws RawDeviceException {
        switch (resType) {
            case 101: {
                this.setInstEnv(dbName, entityName, envNames, envVals);
                break;
            }
            case 102: {
                this.setServEnv(dbName, entityName, envNames, envVals);
                break;
            }
            case 103: {
                this.setNodeAppsEnv(entityName, envNames, envVals);
                break;
            }
            default: {
                Trace.out("RawDeviceConfig: unknown resource type: " + resType);
            }
        }
    }

    @Override
    public void unsetResEnv(String dbName, String entityName, int resType, String[] envNames) throws RawDeviceException {
        switch (resType) {
            case 101: {
                this.unsetInstEnv(dbName, entityName, envNames);
                break;
            }
            case 102: {
                this.unsetServEnv(dbName, entityName, envNames);
                break;
            }
            case 103: {
                this.unsetNodeAppsEnv(entityName, envNames);
                break;
            }
            default: {
                Trace.out("RawDeviceConfig: unknown resource type: " + resType);
            }
        }
    }

    @Override
    public String[] getResEnv(String dbName, String entityName, int resType, String[] envNames) throws RawDeviceException {
        switch (resType) {
            case 101: {
                if (envNames == null) {
                    return this.getInstEnv(dbName, entityName);
                }
                return this.getInstEnv(dbName, entityName, envNames);
            }
            case 102: {
                if (envNames == null) {
                    return this.getServEnv(dbName, entityName);
                }
                return this.getServEnv(dbName, entityName, envNames);
            }
            case 103: {
                if (envNames == null) {
                    return this.getNodeAppsEnv(entityName);
                }
                return this.getNodeAppsEnv(entityName, envNames);
            }
        }
        Trace.out("RawDeviceConfig: unknown resource type: " + resType);
        return null;
    }

    @Override
    public void setServEnv(String opsName, String servName, String[] envName, String[] envValue) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            ServiceComposite sc = opsConfig.getService(servName);
            if (sc == null) {
                Object[] args = new Object[]{servName, opsName};
                String msg = s_rawMsgBundle.getMessage("1058", true, args);
                throw new RawDeviceException(msg);
            }
            String[] servEnv = sc.getEnv();
            boolean[] bExists = new boolean[envName.length];
            Vector<String> envVector = new Vector<String>();
            if (servEnv != null) {
                Trace.out("setEnv: servEnv length=" + servEnv.length);
                for (int i = 0; i < servEnv.length; ++i) {
                    Trace.out("setEnv: servEnv[" + i + "] = " + servEnv[i]);
                    StringTokenizer st = new StringTokenizer(servEnv[i], "=");
                    if (st == null || !st.hasMoreTokens()) continue;
                    String environName = st.nextToken();
                    Trace.out("setEnv: environName = " + environName);
                    for (int j = 0; j < envName.length; ++j) {
                        if (envName[j].compareTo(environName) != 0) continue;
                        servEnv[i] = environName + "=" + envValue[j];
                        Trace.out("setEnv: servEnv[" + i + "] =" + servEnv[i]);
                        bExists[j] = true;
                        break;
                    }
                    envVector.addElement(servEnv[i]);
                    Trace.out("setEnv: servEnv[" + i + "] =" + servEnv[i]);
                }
            }
            for (int k = 0; k < envName.length; ++k) {
                if (bExists[k]) continue;
                envVector.addElement(envName[k] + "=" + envValue[k]);
            }
            envVector.trimToSize();
            String[] newEnv = new String[envVector.size()];
            for (int i = 0; i < envVector.size(); ++i) {
                newEnv[i] = (String)envVector.elementAt(i);
            }
            sc.setEnv(newEnv);
            opsConfig.setService(sc);
            try {
                this.m_ocrtree.setDatabaseService(opsConfig, sc, true);
            }
            catch (OCRException e) {
                throw new RawDeviceException(e.getMessage());
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unsetServEnv(String opsName, String servName, String[] envName) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig == null) {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        ServiceComposite sc = opsConfig.getService(servName);
        if (sc == null) {
            Object[] args = new Object[]{servName, opsName};
            String msg = s_rawMsgBundle.getMessage("1058", true, args);
            throw new RawDeviceException(msg);
        }
        String[] servEnv = sc.getEnv();
        boolean bExists = false;
        boolean envChanged = false;
        Vector<String> envVector = new Vector<String>();
        if (servEnv != null) {
            Trace.out("unsetEnv: servEnv length=" + servEnv.length);
            for (int i = 0; i < servEnv.length; ++i) {
                bExists = false;
                StringTokenizer st = new StringTokenizer(servEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                for (int j = 0; j < envName.length; ++j) {
                    if (environName.compareTo(envName[j]) != 0) continue;
                    bExists = true;
                    envChanged = true;
                    break;
                }
                if (bExists) continue;
                envVector.addElement(servEnv[i]);
            }
        }
        if (!envChanged) {
            String msg = s_rawMsgBundle.getMessage("1057", true);
            throw new RawDeviceException(msg);
        }
        Trace.out("envVector =" + envVector.toString());
        envVector.trimToSize();
        Trace.out("envVector size=" + envVector.size());
        String[] newEnv = new String[envVector.size()];
        for (int i = 0; i < envVector.size(); ++i) {
            newEnv[i] = (String)envVector.elementAt(i);
        }
        sc.setEnv(newEnv);
        opsConfig.setService(sc);
        try {
            this.m_ocrtree.setDatabaseService(opsConfig, sc, true);
            return;
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    @Override
    public String[] getServEnv(String opsName, String servName, String[] name) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            String[] values = new String[name.length];
            ServiceComposite sc = opsConfig.getService(servName);
            if (sc == null) {
                Object[] args = new Object[]{servName, opsName};
                String msg = s_rawMsgBundle.getMessage("1058", true, args);
                throw new RawDeviceException(msg);
            }
            String[] servEnv = sc.getEnv();
            if (servEnv == null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < name.length; ++i) {
                    if (i < name.length - 1) {
                        sb.append(name[i] + ",");
                        continue;
                    }
                    sb.append(name[i]);
                }
                Object[] args = new Object[]{sb.toString(), servName, opsName};
                String msg = s_rawMsgBundle.getMessage("1049", true, args);
                throw new RawDeviceException(msg);
            }
            int valIndex = 0;
            for (int j = 0; j < name.length; ++j) {
                boolean found = false;
                for (int i = 0; i < servEnv.length; ++i) {
                    String environName;
                    int eqIndex = servEnv[i].indexOf("=");
                    if (eqIndex == -1 || (environName = servEnv[i].substring(0, eqIndex)).compareTo(name[j]) != 0) continue;
                    found = true;
                    if (servEnv[i].length() > eqIndex) {
                        values[valIndex++] = servEnv[i].substring(eqIndex + 1);
                        break;
                    }
                    values[valIndex++] = "";
                    break;
                }
                if (found) continue;
                Object[] args = new Object[]{name[j], servName, opsName};
                String msg = s_opsMsgBundle.getMessage("1049", true, args);
                throw new RawDeviceException(msg);
            }
            return values;
        }
        Object[] args = new Object[]{opsName};
        String msg = s_rawMsgBundle.getMessage("1001", true, args);
        throw new RawDeviceException(msg);
    }

    @Override
    public String[] getServEnv(String opsName, String servName) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            ServiceComposite sc = opsConfig.getService(servName);
            if (sc == null) {
                Object[] args = new Object[]{servName, opsName};
                String msg = s_rawMsgBundle.getMessage("1058", true, args);
                throw new RawDeviceException(msg);
            }
            return sc.getEnv();
        }
        Object[] args = new Object[]{opsName};
        String msg = s_rawMsgBundle.getMessage("1001", true, args);
        throw new RawDeviceException(msg);
    }

    @Override
    public void setNodeAppsEnv(String nodeName, String[] envName, String[] envValue) throws RawDeviceException {
        NodeConfiguration nodeConfig;
        try {
            nodeConfig = this.m_ocrtree.getNodeConfiguration(nodeName);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
        if (nodeConfig != null) {
            String[] nodeEnv = nodeConfig.getEnv();
            boolean[] bExists = new boolean[envName.length];
            Vector<String> envVector = new Vector<String>();
            if (nodeEnv != null) {
                Trace.out("setEnv: nodeEnv length=" + nodeEnv.length);
                for (int i = 0; i < nodeEnv.length; ++i) {
                    Trace.out("setEnv: nodeEnv[" + i + "] = " + nodeEnv[i]);
                    StringTokenizer st = new StringTokenizer(nodeEnv[i], "=");
                    if (st == null || !st.hasMoreTokens()) continue;
                    String environName = st.nextToken();
                    Trace.out("setEnv: environName = " + environName);
                    for (int j = 0; j < envName.length; ++j) {
                        if (envName[j].compareTo(environName) != 0) continue;
                        nodeEnv[i] = environName + "=" + envValue[j];
                        Trace.out("setEnv: nodeEnv[" + i + "] =" + nodeEnv[i]);
                        bExists[j] = true;
                        break;
                    }
                    envVector.addElement(nodeEnv[i]);
                    Trace.out("setEnv: nodeEnv[" + i + "] =" + nodeEnv[i]);
                }
            }
            for (int k = 0; k < envName.length; ++k) {
                if (bExists[k]) continue;
                envVector.addElement(envName[k] + "=" + envValue[k]);
            }
            envVector.trimToSize();
            String[] newEnv = new String[envVector.size()];
            for (int i = 0; i < envVector.size(); ++i) {
                newEnv[i] = (String)envVector.elementAt(i);
            }
            nodeConfig.setEnv(newEnv);
            try {
                this.m_ocrtree.setNodeConfiguration(nodeConfig);
            }
            catch (OCRException e) {
                throw new RawDeviceException(e.getMessage());
            }
        } else {
            Object[] args = new Object[]{nodeName};
            String msg = s_rawMsgBundle.getMessage("1059", true, args);
            throw new RawDeviceException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unsetNodeAppsEnv(String nodeName, String[] envName) throws RawDeviceException {
        NodeConfiguration nodeConfig;
        try {
            nodeConfig = this.m_ocrtree.getNodeConfiguration(nodeName);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
        if (nodeConfig == null) {
            Object[] args = new Object[]{nodeName};
            String msg = s_rawMsgBundle.getMessage("1059", true, args);
            throw new RawDeviceException(msg);
        }
        String[] nodeEnv = nodeConfig.getEnv();
        boolean bExists = false;
        boolean envChanged = false;
        Vector<String> envVector = new Vector<String>();
        if (nodeEnv != null) {
            Trace.out("unsetEnv: nodeEnv length=" + nodeEnv.length);
            for (int i = 0; i < nodeEnv.length; ++i) {
                bExists = false;
                StringTokenizer st = new StringTokenizer(nodeEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                for (int j = 0; j < envName.length; ++j) {
                    if (environName.compareTo(envName[j]) != 0) continue;
                    bExists = true;
                    envChanged = true;
                    break;
                }
                if (bExists) continue;
                envVector.addElement(nodeEnv[i]);
            }
        }
        if (!envChanged) {
            String msg = s_rawMsgBundle.getMessage("1057", true);
            throw new RawDeviceException(msg);
        }
        Trace.out("envVector =" + envVector.toString());
        envVector.trimToSize();
        Trace.out("envVector size=" + envVector.size());
        String[] newEnv = new String[envVector.size()];
        for (int i = 0; i < envVector.size(); ++i) {
            newEnv[i] = (String)envVector.elementAt(i);
        }
        nodeConfig.setEnv(newEnv);
        try {
            this.m_ocrtree.setNodeConfiguration(nodeConfig);
            return;
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    @Override
    public String[] getNodeAppsEnv(String nodeName, String[] name) throws RawDeviceException {
        NodeConfiguration nodeConfig;
        try {
            nodeConfig = this.m_ocrtree.getNodeConfiguration(nodeName);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
        if (nodeConfig != null) {
            String[] nodeEnv = nodeConfig.getEnv();
            if (nodeEnv == null) {
                String names = "";
                for (int i = 0; i < name.length; ++i) {
                    names = names + " " + name[i];
                }
                Object[] args = new Object[]{names.trim(), nodeName};
                String msg = s_opsMsgBundle.getMessage("1034", true, args);
                throw new RawDeviceException(msg);
            }
            String[] values = new String[name.length];
            int valIndex = 0;
            for (int j = 0; j < name.length; ++j) {
                boolean found = false;
                for (int i = 0; i < nodeEnv.length; ++i) {
                    String environName;
                    int eqIndex = nodeEnv[i].indexOf("=");
                    if (eqIndex == -1 || (environName = nodeEnv[i].substring(0, eqIndex)).compareTo(name[j]) != 0) continue;
                    found = true;
                    if (nodeEnv[i].length() > eqIndex) {
                        values[valIndex++] = nodeEnv[i].substring(eqIndex + 1);
                        break;
                    }
                    values[valIndex++] = "";
                    break;
                }
                if (found) continue;
                Object[] args = new Object[]{name[j], nodeName};
                String msg = s_opsMsgBundle.getMessage("1034", true, args);
                throw new RawDeviceException(msg);
            }
            return values;
        }
        Object[] args = new Object[]{nodeName};
        String msg = s_rawMsgBundle.getMessage("1059", true, args);
        throw new RawDeviceException(msg);
    }

    @Override
    public String[] getNodeAppsEnv(String nodeName) throws RawDeviceException {
        NodeConfiguration nodeConfig;
        try {
            nodeConfig = this.m_ocrtree.getNodeConfiguration(nodeName);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
        if (nodeConfig != null) {
            return nodeConfig.getEnv();
        }
        Object[] args = new Object[]{nodeName};
        String msg = s_rawMsgBundle.getMessage("1059", true, args);
        throw new RawDeviceException(msg);
    }
}

