/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.RawDeviceConfigHA;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.VIPRangeConfiguration;

public class RawDeviceConfig
implements Constants {
    static MessageBundle s_rawMsgBundle = MessageBundle.getMessageBundle("Prkr");
    static MessageBundle s_opsMsgBundle = MessageBundle.getMessageBundle("Prkp");
    private static Hashtable s_RawDeviceConfigInstanceTable = new Hashtable();
    protected OCRTree m_ocrtree;
    protected static Version s_version = new Version();

    protected RawDeviceConfig(Version v) throws RawDeviceException {
        try {
            Trace.out("initializing RawDeviceConfig");
            this.m_ocrtree = OCRTree.init(v);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    public static synchronized RawDeviceConfig init(Version v) throws RawDeviceException {
        RawDeviceConfig instance = (RawDeviceConfig)s_RawDeviceConfigInstanceTable.get(v);
        if (instance == null) {
            Trace.out("RawDeviceConfig instance is null");
            if (v.equals(s_version)) {
                Trace.out("Creating a RawDeviceConfigHA instance");
                instance = new RawDeviceConfigHA(v);
            } else {
                Trace.out("Creating a RawDeviceConfig instance");
                instance = new RawDeviceConfig(v);
            }
            s_RawDeviceConfigInstanceTable.put(v, instance);
        }
        return instance;
    }

    public static synchronized RawDeviceConfig init() throws RawDeviceException {
        Version v = Version.get92Version();
        return RawDeviceConfig.init(v);
    }

    public synchronized ParallelServerConfig getConfiguration(String opsName) throws RawDeviceException {
        if (this.m_ocrtree == null) {
            Trace.out(" OCR TREE IS NULL");
            throw new RawDeviceException();
        }
        try {
            Trace.out("calling ocrtree.getDBConfig");
            ParallelServerConfig opsConfig = this.m_ocrtree.getDatabaseConfiguration(opsName);
            Trace.out("returning from ocrtree.getDBConfig");
            return opsConfig;
        }
        catch (OCRException e) {
            Trace.out("throwing rawdeviceexception: " + e.getMessage());
            throw new RawDeviceException(e.getMessage());
        }
    }

    protected synchronized void setConfiguration(ParallelServerConfig opsConfig) throws RawDeviceException {
        Trace.out("calling OCRTree.setDatabaseConfiguration");
        try {
            this.m_ocrtree.setDatabaseConfiguration(opsConfig);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    public synchronized void addConfiguration(ParallelServerConfig opsConfig) throws RawDeviceException {
        Trace.out("calling OCRTree.addDatabaseConfiguration");
        try {
            this.m_ocrtree.addDatabaseConfiguration(opsConfig);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    public synchronized void removeConfiguration(String opsName) throws RawDeviceException {
        try {
            this.m_ocrtree.removeDatabaseConfiguration(opsName);
        }
        catch (OCRException e) {
            throw new RawDeviceException(e.getMessage());
        }
    }

    public synchronized void addInstance(String opsName, Instance inst) throws RawDeviceException {
        Object resultString = null;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            if (opsConfig.getIndexOf(inst.getName()) >= 0) {
                Object[] args = new Object[]{inst.getName()};
                String msg = s_rawMsgBundle.getMessage("1004", true, args);
                throw new RawDeviceException(msg);
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        Vector instances = opsConfig.getInstances();
        instances.addElement(inst);
        opsConfig.setInstances(instances);
        this.setConfiguration(opsConfig);
    }

    public synchronized void addInstance(String opsName, String instName, String nodeName) throws RawDeviceException {
        Object resultString = null;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            if (opsConfig.getIndexOf(instName) >= 0) {
                Object[] args = new Object[]{instName};
                String msg = s_rawMsgBundle.getMessage("1004", true, args);
                throw new RawDeviceException(msg);
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        String oracleHome = opsConfig.getOracleHome();
        String[] env = null;
        Instance inst = new Instance(instName, nodeName, env);
        Vector instances = opsConfig.getInstances();
        instances.addElement(inst);
        opsConfig.setInstances(instances);
        this.setConfiguration(opsConfig);
    }

    public synchronized void deleteInstance(String opsName, String instName) throws RawDeviceException {
        int index;
        Object resultString = null;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            index = opsConfig.getIndexOf(instName);
            if (index < 0) {
                Object[] args = new Object[]{instName};
                String msg = s_rawMsgBundle.getMessage("1003", true, args);
                throw new RawDeviceException(msg);
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        Vector instances = opsConfig.getInstances();
        instances.removeElementAt(index);
        opsConfig.setInstances(instances);
        this.setConfiguration(opsConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void renameInstance(String opsName, String oldName, String newName) throws RawDeviceException {
        Object resultString = null;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig == null) {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        int oldIndex = opsConfig.getIndexOf(oldName);
        if (oldIndex < 0) {
            Object[] args = new Object[]{oldName};
            String msg = s_rawMsgBundle.getMessage("1003", true, args);
            throw new RawDeviceException(msg);
        }
        int newIndex = opsConfig.getIndexOf(newName);
        if (newIndex < 0) {
            Vector instances = opsConfig.getInstances();
            Instance inst = (Instance)instances.elementAt(oldIndex);
            inst.setName(newName);
            instances.setElementAt(inst, oldIndex);
            opsConfig.setInstances(instances);
            this.setConfiguration(opsConfig);
            return;
        }
        Object[] args = new Object[]{newName};
        String msg = s_rawMsgBundle.getMessage("1004", true, args);
        throw new RawDeviceException(msg);
    }

    public synchronized void moveInstance(String opsName, String instName, String nodeName) throws RawDeviceException {
        int index;
        Object resultString = null;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            index = opsConfig.getIndexOf(instName);
            if (index < 0) {
                Object[] args = new Object[]{instName};
                String msg = s_rawMsgBundle.getMessage("1003", true, args);
                throw new RawDeviceException(msg);
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        Vector instances = opsConfig.getInstances();
        Instance inst = (Instance)instances.elementAt(index);
        inst.setNode(nodeName);
        instances.setElementAt(inst, index);
        opsConfig.setInstances(instances);
        this.setConfiguration(opsConfig);
    }

    public String[] enumerateOPS() {
        String[] results;
        try {
            results = this.m_ocrtree.listDatabases();
        }
        catch (OCRException e) {
            Trace.out("RawdeviceConfig.emunerateOPS: got OCRException!");
            results = null;
        }
        return results;
    }

    public void setEnv(String opsName, String name, String value) throws RawDeviceException {
        String[] envName = new String[]{name};
        String[] envValue = new String[]{value};
        this.setEnv(opsName, envName, envValue);
    }

    public void setEnv(String opsName, String[] envName, String[] envValue) throws RawDeviceException {
        String[] newOraEnv;
        ParallelServerConfig opsConfig;
        if (envName != null) {
            for (int i = 0; i < envName.length; ++i) {
                Trace.out("env[" + i + "]: " + envName[i] + "=" + envValue[i]);
            }
        }
        if ((opsConfig = this.getConfiguration(opsName)) != null) {
            String[] oraEnv = opsConfig.getEnvironment();
            boolean[] bExists = new boolean[envName.length];
            Vector<String> envVector = new Vector<String>();
            if (oraEnv != null) {
                Trace.out("setEnv: oraEnv length=" + oraEnv.length);
                for (int i = 0; i < oraEnv.length; ++i) {
                    StringTokenizer st = new StringTokenizer(oraEnv[i], "=");
                    if (st == null || !st.hasMoreTokens()) continue;
                    String environName = st.nextToken();
                    for (int j = 0; j < envName.length; ++j) {
                        if (envName[j].compareTo(environName) != 0) continue;
                        oraEnv[i] = environName + "=" + envValue[j];
                        Trace.out("setEnv: oraEnv[" + i + "] =" + oraEnv[i]);
                        bExists[j] = true;
                        break;
                    }
                    envVector.addElement(oraEnv[i]);
                }
            }
            for (int k = 0; k < envName.length; ++k) {
                if (bExists[k]) continue;
                envVector.addElement(envName[k] + "=" + envValue[k]);
            }
            envVector.trimToSize();
            newOraEnv = new String[envVector.size()];
            for (int i = 0; i < envVector.size(); ++i) {
                newOraEnv[i] = (String)envVector.elementAt(i);
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        opsConfig.setEnvironment(newOraEnv);
        this.setConfiguration(opsConfig);
    }

    public void unsetEnv(String opsName, String name) throws RawDeviceException {
        String[] envName = new String[]{name};
        this.unsetEnv(opsName, envName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unsetEnv(String opsName, String[] envName) throws RawDeviceException {
        int i;
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig == null) {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        String[] oraEnv = opsConfig.getEnvironment();
        boolean bExists = false;
        Vector<String> envVector = new Vector<String>();
        if (oraEnv != null) {
            Trace.out("unsetEnv: oraEnv length=" + oraEnv.length);
            for (i = 0; i < oraEnv.length; ++i) {
                bExists = false;
                StringTokenizer st = new StringTokenizer(oraEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                Trace.out("unsetEnv: existing env name: " + environName);
                for (int j = 0; j < envName.length; ++j) {
                    if (environName.compareTo(envName[j]) != 0) continue;
                    bExists = true;
                    break;
                }
                if (bExists) continue;
                envVector.addElement(oraEnv[i]);
            }
        }
        envVector.trimToSize();
        for (i = 0; i < envVector.size(); ++i) {
            Trace.out("envVector.elementAt(" + i + ")=" + envVector.elementAt(i));
        }
        if (envVector.size() == oraEnv.length) {
            String msg = s_rawMsgBundle.getMessage("1057", true);
            throw new RawDeviceException(msg);
        }
        String[] newOraEnv = new String[envVector.size()];
        int i2 = 0;
        while (true) {
            if (i2 >= envVector.size()) {
                opsConfig.setEnvironment(newOraEnv);
                this.setConfiguration(opsConfig);
                return;
            }
            newOraEnv[i2] = (String)envVector.elementAt(i2);
            ++i2;
        }
    }

    public String[] getEnv(String opsName) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            return opsConfig.getEnvironment();
        }
        Object[] args = new Object[]{opsName};
        String msg = s_rawMsgBundle.getMessage("1001", true, args);
        throw new RawDeviceException(msg);
    }

    public String[] getEnv(String opsName, String[] name) throws RawDeviceException {
        if (name == null) {
            return this.getEnv(opsName);
        }
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            String[] values = new String[name.length];
            int valIndex = 0;
            String[] oraEnv = opsConfig.getEnvironment();
            if (oraEnv == null) {
                Trace.out("oraEnv is " + oraEnv);
                String msg = s_rawMsgBundle.getMessage("1057", true);
                Trace.out("msg is " + msg);
                throw new RawDeviceException(msg);
            }
            for (int j = 0; j < name.length; ++j) {
                boolean found = false;
                for (int i = 0; i < oraEnv.length; ++i) {
                    String environName;
                    int eqIndex = oraEnv[i].indexOf("=");
                    if (eqIndex == -1 || (environName = oraEnv[i].substring(0, eqIndex)).compareTo(name[j]) != 0) continue;
                    found = true;
                    if (oraEnv[i].length() > eqIndex) {
                        values[valIndex++] = oraEnv[i].substring(eqIndex + 1);
                        break;
                    }
                    values[valIndex++] = "";
                    break;
                }
                if (found) continue;
                Object[] args = new Object[]{name[j], opsName};
                String msg = s_opsMsgBundle.getMessage("1013", true, args);
                throw new RawDeviceException(msg);
            }
            return values;
        }
        Object[] args = new Object[]{opsName};
        String msg = s_rawMsgBundle.getMessage("1001", true, args);
        throw new RawDeviceException(msg);
    }

    public void setInstEnv(String opsName, String inst, String name, String value) throws RawDeviceException {
        String[] envName = new String[]{name};
        String[] envValue = new String[]{value};
        this.setInstEnv(opsName, inst, envName, envValue);
    }

    public void setInstEnv(String opsName, String inst, String[] envName, String[] envValue) throws RawDeviceException {
        String[] newEnv;
        Instance instance;
        ParallelServerConfig opsConfig;
        if (envName != null) {
            for (int i = 0; i < envName.length; ++i) {
                Trace.out("env[" + i + "]: " + envName[i] + "=" + envValue[i]);
            }
        }
        if ((opsConfig = this.getConfiguration(opsName)) != null) {
            instance = opsConfig.getInstance(inst);
            if (instance == null) {
                Object[] args = new Object[]{inst, opsName};
                String msg = s_rawMsgBundle.getMessage("1003", true, args);
                throw new RawDeviceException(msg);
            }
            String[] instEnv = instance.getEnv();
            boolean[] bExists = new boolean[envName.length];
            Vector<String> envVector = new Vector<String>();
            if (instEnv != null) {
                Trace.out("setEnv: instEnv length=" + instEnv.length);
                for (int i = 0; i < instEnv.length; ++i) {
                    Trace.out("setEnv: instEnv[" + i + "] = " + instEnv[i]);
                    StringTokenizer st = new StringTokenizer(instEnv[i], "=");
                    if (st == null || !st.hasMoreTokens()) continue;
                    String environName = st.nextToken();
                    Trace.out("setEnv: environName = " + environName);
                    for (int j = 0; j < envName.length; ++j) {
                        if (envName[j].compareTo(environName) != 0) continue;
                        instEnv[i] = environName + "=" + envValue[j];
                        Trace.out("setEnv: instEnv[" + i + "] =" + instEnv[i]);
                        bExists[j] = true;
                        break;
                    }
                    envVector.addElement(instEnv[i]);
                    Trace.out("setEnv: instEnv[" + i + "] =" + instEnv[i]);
                }
            }
            for (int k = 0; k < envName.length; ++k) {
                if (bExists[k]) continue;
                envVector.addElement(envName[k] + "=" + envValue[k]);
            }
            envVector.trimToSize();
            newEnv = new String[envVector.size()];
            for (int i = 0; i < envVector.size(); ++i) {
                newEnv[i] = (String)envVector.elementAt(i);
            }
        } else {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        instance.setEnv(newEnv);
        opsConfig.setInstance(instance);
        this.setConfiguration(opsConfig);
    }

    public void unsetInstEnv(String opsName, String inst, String name) throws RawDeviceException {
        String[] envName = new String[]{name};
        this.unsetInstEnv(opsName, inst, envName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void unsetInstEnv(String opsName, String inst, String[] envName) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig == null) {
            Object[] args = new Object[]{opsName};
            String msg = s_rawMsgBundle.getMessage("1001", true, args);
            throw new RawDeviceException(msg);
        }
        Instance instance = opsConfig.getInstance(inst);
        if (instance == null) {
            Object[] args = new Object[]{inst, opsName};
            String msg = s_rawMsgBundle.getMessage("1003", true, args);
            throw new RawDeviceException(msg);
        }
        String[] instEnv = instance.getEnv();
        boolean bExists = false;
        boolean envChanged = false;
        Vector<String> envVector = new Vector<String>();
        if (instEnv != null) {
            Trace.out("unsetEnv: instEnv length=" + instEnv.length);
            for (int i = 0; i < instEnv.length; ++i) {
                bExists = false;
                StringTokenizer st = new StringTokenizer(instEnv[i], "=");
                if (st == null || !st.hasMoreTokens()) continue;
                String environName = st.nextToken();
                for (int j = 0; j < envName.length; ++j) {
                    if (environName.compareTo(envName[j]) != 0) continue;
                    bExists = true;
                    envChanged = true;
                    break;
                }
                if (bExists) continue;
                envVector.addElement(instEnv[i]);
            }
        }
        if (!envChanged) {
            String msg = s_rawMsgBundle.getMessage("1057", true);
            throw new RawDeviceException(msg);
        }
        Trace.out("envVector =" + envVector.toString());
        envVector.trimToSize();
        Trace.out("envVector size=" + envVector.size());
        String[] newEnv = new String[envVector.size()];
        int i = 0;
        while (true) {
            if (i >= envVector.size()) {
                instance.setEnv(newEnv);
                opsConfig.setInstance(instance);
                this.setConfiguration(opsConfig);
                return;
            }
            newEnv[i] = (String)envVector.elementAt(i);
            ++i;
        }
    }

    public String[] getInstEnv(String opsName, String inst, String[] name) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            String[] values = new String[name.length];
            int valIndex = 0;
            Instance instance = opsConfig.getInstance(inst);
            if (instance == null) {
                Object[] args = new Object[]{inst, opsName};
                String msg = s_rawMsgBundle.getMessage("1003", true, args);
                throw new RawDeviceException(msg);
            }
            String[] instEnv = instance.getEnv();
            if (instEnv == null) {
                Trace.out("instEnv is " + instEnv);
                String msg = s_rawMsgBundle.getMessage("1057", true);
                Trace.out("msg is " + msg);
                throw new RawDeviceException(msg);
            }
            for (int j = 0; j < name.length; ++j) {
                boolean found = false;
                for (int i = 0; i < instEnv.length; ++i) {
                    String environName;
                    int eqIndex = instEnv[i].indexOf("=");
                    if (eqIndex == -1 || (environName = instEnv[i].substring(0, eqIndex)).compareTo(name[j]) != 0) continue;
                    found = true;
                    if (instEnv[i].length() > eqIndex) {
                        values[valIndex++] = instEnv[i].substring(eqIndex + 1);
                        break;
                    }
                    values[valIndex++] = "";
                    break;
                }
                if (found) continue;
                Object[] args = new Object[]{name[j], inst, opsName};
                String msg = s_opsMsgBundle.getMessage("1014", true, args);
                throw new RawDeviceException(msg);
            }
            return values;
        }
        Object[] args = new Object[]{opsName};
        String msg = s_rawMsgBundle.getMessage("1001", true, args);
        throw new RawDeviceException(msg);
    }

    public String[] getInstEnv(String opsName, String instName) throws RawDeviceException {
        ParallelServerConfig opsConfig = this.getConfiguration(opsName);
        if (opsConfig != null) {
            Instance instance = opsConfig.getInstance(instName);
            if (instance == null) {
                Object[] args = new Object[]{instName, opsName};
                String msg = s_rawMsgBundle.getMessage("1003", true, args);
                throw new RawDeviceException(msg);
            }
            return instance.getEnv();
        }
        Object[] args = new Object[]{opsName};
        String msg = s_rawMsgBundle.getMessage("1001", true, args);
        throw new RawDeviceException(msg);
    }

    public synchronized void setVIPRangeConfiguration(VIPRangeConfiguration vrConfig) throws RawDeviceException {
    }

    public synchronized NodeConfiguration getNodeConfiguration(String nodeName) throws RawDeviceException {
        return null;
    }

    public synchronized void setNodeConfiguration(NodeConfiguration nodeConfig) throws RawDeviceException {
    }

    public synchronized VIPRangeConfiguration[] getVIPRangeConfigurations() throws RawDeviceException {
        return null;
    }

    public void setResEnv(String dbName, String entityName, int resType, String[] envNames, String[] envVals) throws RawDeviceException {
    }

    public void unsetResEnv(String dbName, String entityName, int resType, String[] envNames) throws RawDeviceException {
    }

    public void setServEnv(String opsName, String servName, String[] envName, String[] envValue) throws RawDeviceException {
    }

    public void unsetServEnv(String opsName, String servName, String[] envName) throws RawDeviceException {
    }

    public String[] getServEnv(String opsName, String servName, String[] name) throws RawDeviceException {
        return null;
    }

    public String[] getServEnv(String opsName, String servName) throws RawDeviceException {
        return null;
    }

    public void setNodeAppsEnv(String nodeName, String[] envName, String[] envValue) throws RawDeviceException {
    }

    public void unsetNodeAppsEnv(String nodeName, String[] envName) throws RawDeviceException {
    }

    public String[] getNodeAppsEnv(String nodeName, String[] name) throws RawDeviceException {
        return null;
    }

    public String[] getNodeAppsEnv(String nodeName) throws RawDeviceException {
        return null;
    }

    public String[] getResEnv(String dbName, String entityName, int resType, String[] envNames) throws RawDeviceException {
        return null;
    }
}

