/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.rawdevice;

import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;

public class OCRTreeDefinition
implements Constants,
OCRKeyLiterals {
    public String getDBRootKey() {
        return "DATABASE.DATABASES";
    }

    public String getLogRootKey() {
        return "DATABASE.LOG";
    }

    public String getDBKey(String dbName) {
        return this.getDBKey(dbName, false);
    }

    public String getDBKey(String dbName, boolean bLog) {
        if (bLog) {
            return this.getLogRootKey() + "." + dbName;
        }
        return this.getDBRootKey() + "." + dbName;
    }

    public String getDBVersionKey(String dbName) {
        return this.getDBKey(dbName) + "." + "CONFIG_VERSION";
    }

    public String getDBOHomeKey(String dbName) {
        return this.getDBOHomeKey(dbName, false);
    }

    public String getDBOHomeKey(String dbName, boolean bLog) {
        return this.getDBKey(dbName, bLog) + "." + "ORACLE_HOME";
    }

    public String getDBDomainKey(String dbName) {
        return this.getDBDomainKey(dbName, false);
    }

    public String getDBDomainKey(String dbName, boolean bLog) {
        return this.getDBKey(dbName, bLog) + "." + "DOMAIN";
    }

    public String getDBSPFileKey(String dbName) {
        return this.getDBSPFileKey(dbName, false);
    }

    public String getDBSPFileKey(String dbName, boolean bLog) {
        return this.getDBKey(dbName, bLog) + "." + "SPFILE";
    }

    public String getDBEnabledKey(String dbName) {
        return this.getDBKey(dbName) + "." + "ENABLED";
    }

    public String getDBPolicyKey(String dbName) {
        return this.getDBKey(dbName) + "." + "POLICY";
    }

    public String getDBPriorPolicyKey(String dbName) {
        return this.getDBKey(dbName) + "." + "PRIOR_POLICY";
    }

    public String getDBEnvKey(String dbName) {
        return this.getDBEnvKey(dbName, false);
    }

    public String getDBEnvKey(String dbName, boolean bLog) {
        return this.getDBKey(dbName, bLog) + "." + "ENVIRONMENT";
    }

    public String getDBInstanceKey(String dbName) {
        return this.getDBInstanceKey(dbName, false);
    }

    public String getDBInstanceKey(String dbName, boolean bLog) {
        return this.getDBKey(dbName, bLog) + "." + "INSTANCE";
    }

    public String getDBInstanceNameKey(String dbName, String instName) {
        return this.getDBInstanceNameKey(dbName, instName, false);
    }

    public String getDBInstanceNameKey(String dbName, String instName, boolean bLog) {
        return this.getDBInstanceKey(dbName, bLog) + "." + instName;
    }

    public String getInstanceNodeKey(String dbName, String instName) {
        return this.getInstanceNodeKey(dbName, instName, false);
    }

    public String getInstanceNodeKey(String dbName, String instName, boolean bLog) {
        return this.getDBInstanceNameKey(dbName, instName, bLog) + "." + "NODE";
    }

    public String getInstanceEnvKey(String dbName, String instName) {
        return this.getInstanceEnvKey(dbName, instName, false);
    }

    public String getInstanceEnvKey(String dbName, String instName, boolean bLog) {
        return this.getDBInstanceNameKey(dbName, instName, bLog) + "." + "ENVIRONMENT";
    }

    public String getInstanceEnabledKey(String dbName, String instName) {
        return this.getDBInstanceNameKey(dbName, instName) + "." + "ENABLED";
    }

    public String getMigrationKey() {
        return "DATABASEmigration.91to92";
    }
}

