/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAStatusOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    String[] m_resourceNames = null;
    String m_nodeName = null;
    boolean m_usePFlag = false;

    public HAStatusOperation(Version version) throws HAOperationException {
        super("crs_stat", version);
    }

    public HAStatusOperation(String resourceName, Version version) throws HAOperationException {
        super("crs_stat", resourceName, version);
        this.m_resourceNames = new String[]{resourceName};
    }

    public HAStatusOperation(Version version, String nodeName) throws HAOperationException {
        super("crs_stat", version);
        this.m_nodeName = nodeName;
    }

    public HAStatusOperation(String[] resourceNames, String nodeName, Version version) throws HAOperationException {
        super("crs_stat", version);
        this.m_resourceNames = new String[resourceNames.length];
        System.arraycopy(resourceNames, 0, this.m_resourceNames, 0, resourceNames.length);
        this.m_nodeName = nodeName;
    }

    public HAStatusOperation(String resourceName, Version version, boolean pflag) throws HAOperationException {
        this(resourceName, version);
        this.m_usePFlag = pflag;
    }

    public boolean isUsePFlag() {
        return this.m_usePFlag;
    }

    @Override
    public String[] getResourceNames() {
        return this.m_resourceNames;
    }

    public void setResourceNames(String[] resNames) {
        this.m_resourceNames = resNames;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public OperationResult run() {
        HAOperationResult result = HAOperationImpl.status(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

