/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAStartOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    String m_openMode;
    String m_pfileName;
    Credentials m_credentials;
    String m_node = null;

    public HAStartOperation(String resourceName, String openMode, String pfileName, Credentials credentials, Version version) throws HAOperationException {
        super("crs_start", resourceName, version);
        this.m_openMode = openMode;
        this.m_pfileName = pfileName;
        this.m_credentials = credentials;
    }

    public HAStartOperation(String resourceName, Version version) throws HAOperationException {
        super("crs_start", resourceName, version);
    }

    String getOpenMode() {
        return this.m_openMode;
    }

    String getpfileName() {
        return this.m_pfileName;
    }

    Credentials getCredentials() {
        return this.m_credentials;
    }

    public void setNode(String node) {
        this.m_node = node;
    }

    public String getNode() {
        return this.m_node;
    }

    @Override
    public OperationResult run() {
        Trace.out("Executing the HA operation " + this.m_verb + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.start(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

