/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HARacgWrapOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    public static final String TYPE_STARTORP = "startorp";
    public static final String TYPE_FAILSRVSA = "failsrvsa";
    private String m_opType = null;
    private String m_dbName = null;
    private String m_instName = null;
    private String m_servName = null;

    public HARacgWrapOperation(String opType, String dbName, String instName, String servName, String ohome, Version version) throws HAOperationException {
        super("racgwrap", version);
        this.m_opType = opType;
        this.m_dbName = dbName;
        this.m_instName = instName;
        this.m_servName = servName;
    }

    public String getOpType() {
        return this.m_opType;
    }

    public String getDatabaseName() {
        return this.m_dbName;
    }

    public String getInstanceName() {
        return this.m_instName;
    }

    public String getServiceName() {
        return this.m_servName;
    }

    @Override
    public OperationResult run() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        this.m_verb = nativeSystem.getScriptFileName(this.m_verb);
        Trace.out("Executing the HA operation " + this.m_verb + " " + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.racgwrap(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

