/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAProfileOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    public static final String SERVICE_MEMBER = "srv";
    public static final String COMPOSITE_SERVICE = "cs";
    public static final String VIRTUAL_IP = "vip";
    public static final String GSD = "gsd";
    public static final String LISTENER = "lsnr";
    public static final String AGENT = "oem";
    public static final String INSTANCE = "inst";
    public static final String DATABASE = "db";
    public static final String ONS = "ons";
    public static final String ASM = "asm";
    public static final String smDescription = "CRS application for Service Member";
    public static final String csDescription = "CRS application for Composite Service";
    public static final String vipDescription = "CRS application for VIP on a node";
    public static final String gsdDescription = "CRS application for GSD on node";
    public static final String lsnrDescription = "CRS application for listener on node";
    public static final String oemDescription = "CRS application for OEM Agent on node";
    public static final String instDescription = "CRS application for Instance";
    public static final String dbDescription = "CRS application for the Database";
    public static final String onsDescription = "CRS application for ONS on node";
    public static final String asmDescription = "CRS application for ASM instance";
    public static final String CREATE = "-create";
    public static final String DELETE = "-delete";
    public static final String UPDATE = "-update";
    public static final String UPDATE_HOSTING_NODE = "-update -h";
    public static final String UPDATE_ACTION_SCRIPT = "-update -a";
    public static final String UPDATE_OPTIONAL_RESOURCE = "-update -l";
    String m_oracleHome;
    String[] m_hostingNodes;
    VIPAddress m_vipAddress = null;
    String m_tafPolicy = null;
    boolean m_SMOptionalResource = false;
    String m_profileType;
    String m_profileOption = "-create";
    String m_policy = "AUTOMATIC";

    public HAProfileOperation(String resourceName, String ohome, Version version) throws HAOperationException {
        super("crs_profile", resourceName, version);
        this.m_oracleHome = ohome;
    }

    public HAProfileOperation(String resourceName, String ohome, String profileType, Version version) throws HAOperationException {
        super("crs_profile", resourceName, version);
        this.m_oracleHome = ohome;
        this.m_profileType = profileType;
    }

    public HAProfileOperation(String resourceName, String ohome, String profileType, String[] hostingNodes, Version version) throws HAOperationException {
        super("crs_profile", resourceName, version);
        this.m_oracleHome = ohome;
        this.m_hostingNodes = hostingNodes;
        this.m_profileType = profileType;
    }

    public HAProfileOperation(String resourceName, String ohome, String profileType, String hostingNode, Version version) throws HAOperationException {
        super("crs_profile", resourceName, version);
        this.m_oracleHome = ohome;
        String[] hostNodes = new String[]{hostingNode};
        this.m_hostingNodes = hostNodes;
        this.m_profileType = profileType;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public String[] getHostingNodes() {
        return this.m_hostingNodes;
    }

    public String getHostNode() {
        return this.m_hostingNodes[0];
    }

    public String getProfileType() {
        return this.m_profileType;
    }

    public String getProfileOption() {
        return this.m_profileOption;
    }

    public void setProfileOption(String option) {
        this.m_profileOption = option;
    }

    public VIPAddress getVIPAddress() {
        return this.m_vipAddress;
    }

    public void setVIPAddress(VIPAddress vAddr) {
        this.m_vipAddress = vAddr;
    }

    public String getTAFPolicy() {
        return this.m_tafPolicy;
    }

    public void setTAFPolicy(String taf) {
        this.m_tafPolicy = taf;
    }

    public void setSMOptionalResource(boolean v) {
        this.m_SMOptionalResource = v;
    }

    public boolean isSetSMOptionalResource() {
        return this.m_SMOptionalResource;
    }

    public String getManagementPolicy() {
        return this.m_policy;
    }

    public void setManagementPolicy(String policy) {
        this.m_policy = policy;
    }

    @Override
    public OperationResult run() {
        Trace.out("Executing the HA operation " + this.m_verb + " " + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.profile(this);
        Trace.out("Returned from executing the HA Operation");
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        return result;
    }
}

