/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.File;
import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.trace.Trace;

public abstract class HAOperation
extends Operation
implements Serializable,
HALiterals {
    static final long serialVersionUID = 8025830119548957015L;
    public static final int HA_RES_NOT_EXIST_ERR = 210;
    public static final int HA_RES_ALREADY_REGISTERED = 211;
    public static final int HA_RES_NOT_REGISTERED = 212;
    public static final int HA_CANNOT_STOP_RES = 216;
    public static final int HA_RES_RELOCATE_ERR = 123;
    protected static final String HA_START = "crs_start";
    protected static final String HA_STOP = "crs_stop";
    protected static final String HA_REGISTER = "crs_register";
    protected static final String HA_UNREGISTER = "crs_unregister";
    protected static final String HA_STATUS = "crs_stat";
    protected static final String HA_RELOCATE = "crs_relocate";
    protected static final String HA_PROFILE = "crs_profile";
    protected static final String HA_SETPERM = "crs_setperm";
    protected static final String HA_GETPERM = "crs_getperm";
    protected static final String HA_RACGWRAP = "racgwrap";
    protected static final String HA_CRSCTL = "crsctl";
    protected static final String HA_DELETE = "delete";
    protected static final String HA_RESOURCE = "resource";
    protected static final String HA_FORCE = "-f";
    protected static final String HA_UNSUPPORTED = "-unsupported";
    protected String m_verb;
    protected boolean m_useUnsupported = false;
    protected String m_resourceName;
    protected String[] m_param;
    protected String m_crsHome;
    private String[] m_resourceNames;

    public HAOperation(String verb, Version version) throws HAOperationException {
        super(false, version);
        this.setCRSHome();
        this.m_useUnsupported = verb.equals(HA_CRSCTL);
        this.m_verb = this.getFullyQualifiedVerb(verb);
        this.checkCommandVerb();
    }

    public HAOperation(String verb, String resourceName, Version version) throws HAOperationException {
        this(verb, version);
        this.m_resourceName = resourceName;
    }

    public HAOperation(String verb, String[] resourceNames, Version version) throws HAOperationException {
        this(verb, version);
        this.m_resourceNames = new String[resourceNames.length];
        System.arraycopy(resourceNames, 0, this.m_resourceNames, 0, resourceNames.length);
    }

    private void setCRSHome() throws HAOperationException {
        try {
            Util hasUtil = new Util();
            this.m_crsHome = hasUtil.getCRSHome();
        }
        catch (UtilException ue) {
            throw new HAOperationException("1060", (Exception)((Object)ue));
        }
        Trace.out("CRS_HOME: " + this.m_crsHome);
    }

    protected String getFullyQualifiedVerb(String verb) {
        return this.m_crsHome + File.separator + "bin" + File.separator + verb;
    }

    public String getCrsHome() {
        return this.m_crsHome;
    }

    public String getCrsStatusVerb() {
        return this.getFullyQualifiedVerb(HA_STATUS);
    }

    public String getProfileHome() {
        String dirForRoot = this.m_crsHome + File.separator + "crs" + File.separator + "profile";
        String dirForOrclUser = this.m_crsHome + File.separator + "crs" + File.separator + "public";
        try {
            Util hasUtl = new Util();
            if (hasUtl.hasHAPrivilege()) {
                return dirForRoot;
            }
            return dirForOrclUser;
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            return dirForRoot;
        }
    }

    public String getResourceName() {
        if (this.m_resourceName == null && this.m_resourceNames != null && this.m_resourceNames.length > 0) {
            return this.m_resourceNames[0];
        }
        return this.m_resourceName;
    }

    public String[] getResourceNames() {
        if (this.m_resourceNames == null && this.m_resourceName != null) {
            return new String[]{this.m_resourceName};
        }
        return this.m_resourceNames;
    }

    public boolean useUnsupported() {
        return this.m_useUnsupported;
    }

    public void setResourceName(String res) {
        this.m_resourceName = res;
    }

    public String getVerb() {
        return this.m_verb;
    }

    public String[] getParam() {
        return this.m_param;
    }

    @Override
    public abstract OperationResult run();

    protected void checkCommandVerb() throws HAOperationException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String command = nativeSystem.getExeName(this.m_verb);
        String scriptCmd = nativeSystem.getScriptFileName(this.m_verb);
        Trace.out("Checking an existence of CRS command");
        File cmdFile = new File(command);
        File scriptCmdFile = new File(scriptCmd);
        if (!cmdFile.exists() && !scriptCmdFile.exists()) {
            Object[] args = new String[]{this.m_verb};
            String[] errMsg = new String[]{MessageBundle.getMessageBundle("Prka").getMessage("2019", true, args)};
            throw new HAOperationException(errMsg);
        }
    }
}

