/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation.ha;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.trace.Trace;

public class HAGetPermOperation
extends HAOperation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    String m_userName;
    String m_groupName;

    public HAGetPermOperation(String resourceName, Version version) throws HAOperationException {
        super("crs_getperm", resourceName, version);
    }

    public String getUserName() throws HAOperationException {
        if (this.m_userName != null) {
            return this.m_userName;
        }
        Trace.out("run() not called, m_userName=" + this.m_userName);
        throw new HAOperationException(new String[]{MessageBundle.getMessageBundle("Prka").getMessage("2022", true, new Object[]{this.m_resourceName})});
    }

    public String getGroupName() throws HAOperationException {
        if (this.m_groupName != null) {
            return this.m_groupName;
        }
        Trace.out("run() not called, m_groupName=" + this.m_groupName);
        throw new HAOperationException(new String[]{MessageBundle.getMessageBundle("Prka").getMessage("2023", true, new Object[]{this.m_resourceName})});
    }

    @Override
    public OperationResult run() {
        Trace.out("Executing the HA operation " + this.m_verb + " " + this.m_resourceName);
        HAOperationResult result = HAOperationImpl.getperm(this);
        Trace.out("Returned from executing the HA Operation");
        if (result.getStatus() != 0) {
            return result;
        }
        String[] output = result.getOutput();
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                Trace.out("OUTPUT> " + output[i]);
            }
        }
        if (output.length == 2) {
            String[] substrs = output[1].split(":");
            for (int s = 0; s < substrs.length; ++s) {
                String[] grps;
                if ("owner".equalsIgnoreCase(substrs[s].trim()) && s < substrs.length - 1) {
                    this.m_userName = substrs[s + 1].trim();
                    continue;
                }
                if (!substrs[s].trim().endsWith("pgrp") || s >= substrs.length - 1 || !"pgrp".equalsIgnoreCase((grps = substrs[s].split(","))[grps.length - 1].trim())) continue;
                this.m_groupName = substrs[s + 1].trim();
            }
        } else {
            Trace.out("No output from the HA Operation");
        }
        String error = result.getError();
        if (error != null) {
            Trace.out("ERROR> " + error);
        } else {
            Trace.out("No error from the HA Operation");
        }
        if (this.m_userName == null || this.m_groupName == null) {
            return HAOperationImpl.handleException(1, output, null);
        }
        return result;
    }
}

