/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.UnsetEnvResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;

public class UnsetEnvOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 5425551853606829172L;
    private String m_opsName;
    private String[] m_envName;
    private String m_entityName = null;
    private int m_resourceType;

    public UnsetEnvOperation(String opsName, String[] envName, Version v) {
        super(true, v);
        this.m_opsName = opsName;
        this.m_envName = envName;
    }

    public UnsetEnvOperation(String opsName, String entityName, int resType, String[] envName, Version v) {
        this(opsName, envName, v);
        this.m_entityName = entityName;
        this.m_resourceType = resType;
    }

    @Override
    public OperationResult run() {
        UnsetEnvResult result = null;
        try {
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            if (this.m_entityName != null) {
                Trace.out("unsetEnvOp: unset env " + this.m_envName[0] + " for ops " + this.m_opsName + " res name " + this.m_entityName);
                rawdeviceConfig.unsetResEnv(this.m_opsName, this.m_entityName, this.m_resourceType, this.m_envName);
            } else {
                Trace.out("unsetEnvOp: unset env " + this.m_envName[0] + " for ops " + this.m_opsName);
                rawdeviceConfig.unsetEnv(this.m_opsName, this.m_envName);
            }
            result = new UnsetEnvResult(0);
        }
        catch (RawDeviceException e) {
            Trace.out("unsetEnvOp: gettting raedev exception");
            result = new UnsetEnvResult(1, e);
        }
        return result;
    }
}

