/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ParallelServerImpl;
import oracle.ops.mgmt.operation.StartInstanceResult;

public class StartInstanceOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 8025830119548957015L;
    private String m_instanceName;
    private String m_mountOptions;
    private String[] m_env;
    private Credentials m_creds;
    private String m_oracleHome;

    public StartInstanceOperation(String name, String mountOptions, String[] env) {
        this.m_instanceName = name;
        this.m_mountOptions = mountOptions;
        this.m_env = env;
        this.m_creds = new Credentials();
    }

    public StartInstanceOperation(String name, String mountOptions, String[] env, Version v) {
        super(v);
        this.m_instanceName = name;
        this.m_mountOptions = mountOptions;
        this.m_env = env;
        this.m_creds = new Credentials();
    }

    public StartInstanceOperation(String name, String mountOptions, String[] env, Credentials creds) {
        this.m_instanceName = name;
        this.m_mountOptions = mountOptions;
        this.m_env = env;
        this.m_creds = creds;
    }

    public StartInstanceOperation(String name, String mountOptions, String[] env, Credentials creds, Version v) {
        super(v);
        this.m_instanceName = name;
        this.m_mountOptions = mountOptions;
        this.m_env = env;
        this.m_creds = creds;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setInstanceName(String name) {
        this.m_instanceName = name;
    }

    public String getMountOptions() {
        return this.m_mountOptions;
    }

    public void setMountOptions(String opts) {
        this.m_mountOptions = opts;
    }

    public String[] getEnvironment() {
        return this.m_env;
    }

    public void setEnvironment(String[] env) {
        this.m_env = env;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setOracleHome(String home) {
        this.m_oracleHome = home;
    }

    public Credentials getCredentials() {
        return this.m_creds;
    }

    public void setCredentials(Credentials creds) {
        this.m_creds = creds;
    }

    @Override
    public OperationResult run() {
        StartInstanceResult result = ParallelServerImpl.start(this);
        return result;
    }
}

