/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import java.util.Hashtable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.SetEnvResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;

public class SetEnvOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 5425551853606829172L;
    private String m_opsName;
    private String[] m_envName;
    private String[] m_envValue;
    private String m_entityName = null;
    private int m_resourceType;
    static MessageBundle s_rawMsgBundle = MessageBundle.getMessageBundle("Prkr");

    public SetEnvOperation(String opsName, String[] envName, String[] envValue, Version v) {
        super(true, v);
        this.m_opsName = opsName;
        this.m_envName = envName;
        this.m_envValue = envValue;
    }

    public SetEnvOperation(String opsName, String entityName, int resourceType, String[] envName, String[] envValue, Version v) {
        this(opsName, envName, envValue, v);
        this.m_entityName = entityName;
        this.m_resourceType = resourceType;
    }

    @Override
    public OperationResult run() {
        SetEnvResult result = null;
        StringBuffer buffer = new StringBuffer();
        String tempValue = null;
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < this.m_envName.length; ++i) {
            tempValue = table.put(this.m_envName[i], this.m_envValue[i]);
            if (tempValue == null) continue;
            buffer.append(this.m_envName[i] + " ");
            tempValue = null;
        }
        if (table.size() != this.m_envName.length) {
            Object[] args = new Object[]{buffer};
            RawDeviceException ex = new RawDeviceException(s_rawMsgBundle.getMessage("1080", true, args));
            result = new SetEnvResult(1, ex);
            return result;
        }
        try {
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            if (this.m_entityName != null) {
                Trace.out("SetEnvOperation.run: res name = " + this.m_entityName);
                rawdeviceConfig.setResEnv(this.m_opsName, this.m_entityName, this.m_resourceType, this.m_envName, this.m_envValue);
            } else {
                rawdeviceConfig.setEnv(this.m_opsName, this.m_envName, this.m_envValue);
            }
            result = new SetEnvResult(0);
            Trace.out("SetEnvOperation.run: SetEnvOperation OK");
        }
        catch (RawDeviceException e) {
            Trace.out("SetEnvOperation.run: SetEnvOperation FAILED");
            result = new SetEnvResult(1, e);
        }
        return result;
    }
}

