/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.ConfigurationResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.trace.Trace;

public class RemoveNodeConfigurationOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -8079111542450212257L;
    private String m_nodeName;

    public RemoveNodeConfigurationOperation(String node, Version v) {
        super(true, v);
        this.m_nodeName = node;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public OperationResult run() {
        ConfigurationResult result = null;
        try {
            OCRTree ocrTree = OCRTree.init(this.m_myVersion);
            Trace.out("removeNodeConfiguration using " + ocrTree);
            ocrTree.removeNodeConfiguration(this.m_nodeName, true);
            result = new ConfigurationResult(0);
        }
        catch (OCRException e) {
            result = new ConfigurationResult(1, e.getMessage());
            result.setException(e);
        }
        return result;
    }
}

