/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ParallelServerImpl;
import oracle.ops.mgmt.operation.ReloadListenerResult;

public class ReloadListenerOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 8012000680853049149L;
    private String m_listenerName = null;
    private String m_oracleHome = null;
    private String[] m_environment = null;

    public ReloadListenerOperation(String listenerName) {
        this.m_listenerName = listenerName;
    }

    public ReloadListenerOperation(String listenerName, Version v) {
        super(v);
        this.m_listenerName = listenerName;
    }

    public ReloadListenerOperation(String listenerName, String oracleHome) {
        this(listenerName);
        this.m_oracleHome = oracleHome;
    }

    public ReloadListenerOperation(String listenerName, String oracleHome, Version v) {
        this(listenerName, v);
        this.m_oracleHome = oracleHome;
    }

    public String getListenerName() {
        return this.m_listenerName;
    }

    public void setListenerName(String lname) {
        this.m_listenerName = lname;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setOracleHome(String home) {
        this.m_oracleHome = home;
    }

    public String[] getEnvironment() {
        return this.m_environment;
    }

    public void setEnvironment(String[] env) {
        this.m_environment = env;
    }

    @Override
    public OperationResult run() {
        ReloadListenerResult result = ParallelServerImpl.reloadListener(this);
        return result;
    }
}

