/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import oracle.net.config.Config;
import oracle.net.config.Listener;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.sUnixCommands;
import oracle.ops.mgmt.operation.CheckListenerOperation;
import oracle.ops.mgmt.operation.CheckListenerResult;
import oracle.ops.mgmt.operation.CreateOracleServiceOperation;
import oracle.ops.mgmt.operation.CreateOracleServiceResult;
import oracle.ops.mgmt.operation.DeleteOracleServiceOperation;
import oracle.ops.mgmt.operation.DeleteOracleServiceResult;
import oracle.ops.mgmt.operation.GetListenerOperation;
import oracle.ops.mgmt.operation.GetListenerResult;
import oracle.ops.mgmt.operation.ReloadListenerOperation;
import oracle.ops.mgmt.operation.ReloadListenerResult;
import oracle.ops.mgmt.operation.StartAgentOperation;
import oracle.ops.mgmt.operation.StartAgentResult;
import oracle.ops.mgmt.operation.StartInstanceOperation;
import oracle.ops.mgmt.operation.StartInstanceResult;
import oracle.ops.mgmt.operation.StartListenerOperation;
import oracle.ops.mgmt.operation.StartListenerResult;
import oracle.ops.mgmt.operation.StopInstanceOperation;
import oracle.ops.mgmt.operation.StopInstanceResult;
import oracle.ops.mgmt.operation.StopListenerOperation;
import oracle.ops.mgmt.operation.StopListenerResult;
import oracle.ops.mgmt.trace.Trace;

class ParallelServerImpl
implements sUnixCommands {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final int MAX_STRING = 1024;
    private static final int FAILURE = 1;
    private static final int SUCCESS = 0;
    private static final int AUTH_SIMPLE = 1;

    private ParallelServerImpl() {
    }

    private static synchronized int runCommand(String[] input, String[] command, String[] environ, Vector output, Vector error) {
        int i;
        RuntimeExec runtimeExec = new RuntimeExec(command, input, environ);
        int retcode = runtimeExec.runCommand();
        String[] m_out = runtimeExec.getOutput();
        String[] m_err = runtimeExec.getError();
        for (i = 0; i < m_out.length; ++i) {
            output.addElement(m_out[i]);
        }
        for (i = 0; i < m_err.length; ++i) {
            output.addElement(m_err[i]);
        }
        return retcode;
    }

    private static synchronized int runListenerCommand(String[] input, String[] command, String[] environ, Vector output, Vector error) {
        Process proc = null;
        int ret = 0;
        Runtime rt = Runtime.getRuntime();
        if (command[0] == null) {
            Trace.out("runCommand: null command passed");
        }
        if (environ == null) {
            Trace.out("runCommand: null environ passed");
            environ = new String[]{};
        }
        Trace.out("runListenerCommand: environ = ");
        for (int e = 0; e < environ.length; ++e) {
            Trace.out(" " + e + ":" + environ[e]);
        }
        Trace.out("runListenerCommand: command = ");
        for (int c = 0; c < command.length; ++c) {
            Trace.out(" " + c + ":" + command[c]);
        }
        try {
            proc = rt.exec(command, environ);
        }
        catch (IOException e) {
            Trace.out("exec exception:" + e.getMessage());
            e.printStackTrace();
            ret = 1;
            return ret;
        }
        try {
            if (input != null) {
                OutputStream outputStream = proc.getOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(outputStream);
                for (int line = 0; line < input.length; ++line) {
                    writer.write(input[line]);
                    Trace.out("runListenerCommand: Input line is " + input[line]);
                    writer.flush();
                }
                outputStream.close();
            }
            Trace.out("runListenerCommand: submitted input");
            InputStream inputStream = proc.getInputStream();
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader bufferInputReader = new BufferedReader(inputReader);
            String outputLine = null;
            char[] inpbuf = new char[1024];
            char[] errbuf = new char[1024];
            boolean res = false;
            int i = 0;
            while ((outputLine = bufferInputReader.readLine()) != null) {
                output.insertElementAt(outputLine, i++);
                Trace.out("Out put line is: " + outputLine);
                if (outputLine.compareTo("The command completed successfully") != 0) continue;
            }
            inputStream.close();
            try {
                Trace.out("runListenerCommand: Waiting for the process");
                ret = proc.waitFor();
                Trace.out("runListenerCommand: process returns " + ret);
            }
            catch (InterruptedException e) {
                Trace.out("runListenerCommand: interrupted awaiting process");
            }
        }
        catch (IOException e) {
            Trace.out("runListenerCommand: reading exception:" + e.getMessage());
        }
        proc.destroy();
        Trace.out("Returning from runListenerCommand");
        return ret;
    }

    static boolean containsError(String[] output) {
        for (int i = 0; i < output.length; ++i) {
            int ind = output[i].indexOf("ORA-");
            if (ind == -1 && (ind = output[i].indexOf("MGR-")) == -1 && (ind = output[i].indexOf("TNS-")) == -1) continue;
            return true;
        }
        return false;
    }

    private static String[] getSQLPlusError(String[] in) {
        String[] tmpErr = new String[in.length];
        int errCount = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i].indexOf("ORA-") == -1 && in[i].indexOf("MGR-") == -1 && in[i].indexOf("TNS-") == -1) continue;
            tmpErr[errCount++] = in[i];
        }
        String[] retErr = new String[errCount];
        for (int i = 0; i < errCount; ++i) {
            retErr[i] = tmpErr[i];
        }
        return retErr;
    }

    static StartInstanceResult start(StartInstanceOperation op) {
        int status = 0;
        String[] input = new String[3];
        String[] startCmd = new String[]{op.getOracleHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "sqlplus"};
        String userOptions = op.getMountOptions();
        String pfileOption = "";
        String pfile = ParallelServerImpl.getPfile(op.getOracleHome(), op.getInstanceName());
        if (userOptions == null) {
            userOptions = "";
        }
        Trace.out("start options is [" + userOptions + "]");
        if (userOptions.toUpperCase().indexOf("PFILE=") == -1 && pfile != null && new File(pfile).exists()) {
            pfileOption = "PFILE=" + pfile;
        }
        Trace.out("start pfileOPtion is [" + pfileOption + "]");
        input[0] = "/ as sysdba";
        input[1] = "startup " + userOptions + " " + pfileOption;
        input[2] = "exit";
        String[] env = ParallelServerImpl.buildEnvironment(op.getEnvironment(), op.getOracleHome());
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runCommand(input, startCmd, env, output, error);
        status = ret == 0 ? 0 : 1;
        Object[] newout = new String[output.size() + error.size()];
        int errlen = error.size();
        if (error.size() > 0) {
            error.copyInto(newout);
        }
        for (int j = 0; j < output.size(); ++j) {
            newout[errlen + j] = (String)output.elementAt(j);
        }
        if (ParallelServerImpl.containsError((String[])newout)) {
            status = 1;
            newout = ParallelServerImpl.getSQLPlusError((String[])newout);
            Trace.out("start instance failed");
        }
        StartInstanceResult res = new StartInstanceResult(status, (String[])newout);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StartAgentResult startAgent(StartAgentOperation op) {
        int status;
        block15: {
            status = 0;
            int exitStatus = 1;
            String[] env = new String[1];
            String oracleHome = op.getOracleHome();
            env[0] = "ORACLE_HOME=" + oracleHome;
            String cmdLine1 = oracleHome + File.separator + "bin" + File.separator + "agentctl start";
            Trace.out(" startAgent: cmdLine1 " + cmdLine1);
            BufferedInputStream inputStream = null;
            BufferedInputStream errorStream = null;
            BufferedOutputStream outputStream = null;
            Object inLine = null;
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(cmdLine1);
                inputStream = new BufferedInputStream(process.getInputStream());
                errorStream = new BufferedInputStream(process.getErrorStream());
                outputStream = new BufferedOutputStream(process.getOutputStream());
                if (process != null) {
                    Trace.out("\n WAITING for AGENTCTL TO EXIT");
                }
                try {
                    Trace.out("\n Trying to get the exitValue of the process");
                    exitStatus = process.exitValue();
                    Trace.out("\n Exit value from agentctl process = " + exitStatus);
                    if (exitStatus == 0) {
                        status = 0;
                        break block15;
                    }
                    status = 1;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                    errorStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        StartAgentResult res = new StartAgentResult(status);
        Trace.out("End of StartAgentCommand on Daemon Side");
        return res;
    }

    private static String getPfile(String oracleHome, String instanceName) {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String pfilePath = nativeSystem.getPfileName(oracleHome, instanceName);
        Trace.out("pfile is " + pfilePath);
        return pfilePath;
    }

    private static boolean checkListenerStartOutput(String[] output) {
        for (int i = 0; i < output.length; ++i) {
            if (output[i].indexOf("TNS-01106") == -1 && output[i].indexOf("The command completed successfully") == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean checkListenerStopOutput(String[] output) {
        for (int i = 0; i < output.length; ++i) {
            if (output[i].indexOf("TNS-00511") == -1 && output[i].indexOf("The command completed successfully") == -1) continue;
            return true;
        }
        return false;
    }

    private static boolean checkListenerReloadOutput(String[] output) {
        for (int i = 0; i < output.length; ++i) {
            if (output[i].indexOf("TNS-00511") == -1 && output[i].indexOf("The command completed successfully") == -1) continue;
            return true;
        }
        return false;
    }

    static StopInstanceResult stop(StopInstanceOperation op) {
        int status = 0;
        String[] stopCmd = new String[]{op.getOracleHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "sqlplus"};
        String[] input = new String[]{"/ as sysdba", op.getShutdownOptions() == null ? "shutdown" : "shutdown " + op.getShutdownOptions(), "exit"};
        String[] env = ParallelServerImpl.buildEnvironment(op.getEnvironment(), op.getOracleHome());
        for (int i = 0; i < env.length; ++i) {
            Trace.out("ParallelServerImpl: stop env[" + i + "]=" + env[i]);
        }
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runCommand(input, stopCmd, env, output, error);
        status = ret == 0 ? 0 : 1;
        Object[] newout = new String[output.size() + error.size()];
        Trace.out("ParallelServerImpl: output length " + output.size());
        Trace.out("ParallelServerImpl: error length " + error.size());
        int errlen = error.size();
        if (error.size() > 0) {
            error.copyInto(newout);
        }
        Trace.out("ParallelServerImpl: error=" + error.toString());
        Trace.out("ParallelServerImpl: error=" + output.toString());
        for (int j = 0; j < output.size(); ++j) {
            newout[errlen + j] = (String)output.elementAt(j);
        }
        if (ParallelServerImpl.containsError((String[])newout)) {
            status = 1;
            newout = ParallelServerImpl.getSQLPlusError((String[])newout);
            Trace.out("stop instance failed");
        }
        StopInstanceResult res = new StopInstanceResult(status, (String[])newout);
        return res;
    }

    private static boolean checkListenerStatOutput(String[] output, String sigStr) {
        for (int i = 0; i < output.length; ++i) {
            if (output[i].indexOf(sigStr) == -1) continue;
            Trace.out("checkListenerStatOutput: returning true");
            return true;
        }
        Trace.out("checkListenerStatOutput: returning false");
        return false;
    }

    static CheckListenerResult checkListener(CheckListenerOperation op) {
        int status = 0;
        String[] listenerNames = null;
        boolean noneStarted = true;
        boolean allStarted = true;
        String[] userCredentials = new String[]{null, null};
        String oracleHome = op.getOracleHome();
        String instanceName = op.getInstanceName();
        int i = 0;
        try {
            Config config = new Config(oracleHome, 1, userCredentials);
            listenerNames = Listener.enumListeners((Config)config, (String)instanceName);
            Trace.out("checkListener: " + listenerNames.length + " listeners are found for inst " + instanceName);
        }
        catch (Exception e) {
            status = 1;
        }
        StringBuffer errorBuffer = new StringBuffer();
        String oraHome = op.getOracleHome();
        String[] env = ParallelServerImpl.buildEnvironment(op.getEnvironment(), oraHome);
        if (listenerNames != null) {
            for (i = 0; i < listenerNames.length; ++i) {
                String sigStr;
                String[] startCmd = new String[]{oraHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "lsnrctl", "stat", listenerNames[i]};
                Vector output = new Vector();
                Vector error = new Vector();
                int ret = ParallelServerImpl.runCommand(null, startCmd, env, output, error);
                String[] newout = new String[output.size() + error.size()];
                int errlen = error.size();
                for (int j = 0; j < errlen; ++j) {
                    newout[i] = (String)error.elementAt(j);
                }
                for (int k = 0; k < output.size(); ++k) {
                    newout[errlen + k] = (String)output.elementAt(k);
                }
                if (ret == 0) {
                    Trace.out("checkListener: runCommand was successfull");
                    sigStr = "The command completed successfully";
                    if (!ParallelServerImpl.checkListenerStatOutput(newout, sigStr)) {
                        errorBuffer.append(newout);
                        allStarted = false;
                        continue;
                    }
                    noneStarted = false;
                    continue;
                }
                Trace.out("checkListener: runCommand returns " + ret);
                sigStr = "TNS-12541: TNS:no listener";
                if (ParallelServerImpl.checkListenerStatOutput(newout, sigStr)) {
                    allStarted = false;
                    continue;
                }
                status = 1;
            }
        }
        int runningStatus = i == 1 && allStarted ? 1 : (!allStarted && !noneStarted ? 0 : (allStarted && !noneStarted ? 1 : (noneStarted && !allStarted ? -1 : -1)));
        CheckListenerResult result = new CheckListenerResult(status, runningStatus, errorBuffer.toString());
        return result;
    }

    static StartListenerResult startListener(StartListenerOperation op, boolean force) {
        int status = 0;
        String[] startCmd = new String[]{op.getOracleHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "lsnrctl", "start", op.getListenerName()};
        Trace.out("Inside ParallelServerImpl.startListener: listenername= " + startCmd[2]);
        String[] env = ParallelServerImpl.buildEnvironment(op.getEnvironment(), op.getOracleHome());
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runListenerCommand(null, startCmd, env, output, error);
        Trace.out("ParallelServerImpl.startListener: Out of runListenerCommand " + ret);
        Object[] newout = new String[output.size()];
        if (output.size() > 0) {
            output.copyInto(newout);
        }
        Object[] newerr = new String[error.size()];
        if (error.size() > 0) {
            error.copyInto(newerr);
        }
        status = ret == 1 ? (!ParallelServerImpl.checkListenerStartOutput((String[])newout) && force ? 0 : 1) : 0;
        Trace.out("Status of listener starting " + status);
        StartListenerResult result = new StartListenerResult(status, (String[])newout, (String[])newerr);
        Trace.out("ParallelServerImpl.startListener :Returning from startListener ");
        return result;
    }

    static ReloadListenerResult reloadListener(ReloadListenerOperation op) {
        int status = 0;
        String[] reloadCmd = new String[]{op.getOracleHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "lsnrctl", "reload", op.getListenerName()};
        Trace.out("Inside ParallelServerImpl.reloadListener: listenername= " + reloadCmd[2]);
        String[] env = ParallelServerImpl.buildEnvironment(op.getEnvironment(), op.getOracleHome());
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runCommand(null, reloadCmd, env, output, error);
        Trace.out("ParallelServerImpl.reloadListener: Out of runListenerCommand " + ret);
        Object[] newout = new String[output.size()];
        if (output.size() > 0) {
            output.copyInto(newout);
        }
        Object[] newerr = new String[error.size()];
        if (error.size() > 0) {
            error.copyInto(newerr);
        }
        status = ret == 1 ? (!ParallelServerImpl.checkListenerReloadOutput((String[])newout) ? 0 : 1) : 0;
        Trace.out("Status of listener reloading " + status);
        ReloadListenerResult result = new ReloadListenerResult(status, (String[])newout, (String[])newerr);
        Trace.out("ParallelServerImpl.startListener :Returning from reloadListener ");
        return result;
    }

    static StopListenerResult stopListener(StopListenerOperation op, boolean force) {
        int status = 0;
        String[] stopCmd = new String[]{op.getOracleHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "lsnrctl", "stop", op.getListenerName()};
        String[] env = ParallelServerImpl.buildEnvironment(op.getEnvironment(), op.getOracleHome());
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runCommand(null, stopCmd, env, output, error);
        Object[] newout = new String[output.size()];
        if (output.size() > 0) {
            output.copyInto(newout);
        }
        Object[] newerr = new String[error.size()];
        if (error.size() > 0) {
            error.copyInto(newerr);
        }
        status = ret == 1 ? (!ParallelServerImpl.checkListenerStopOutput((String[])newout) && force ? 0 : 1) : 0;
        StopListenerResult result = new StopListenerResult(status, (String[])newout, (String[])newerr);
        return result;
    }

    static GetListenerResult getListener(GetListenerOperation op) {
        String oracleHome = op.getOracleHome();
        String instanceName = op.getInstanceName();
        String[] userCredentials = new String[]{null, null};
        String[] listenerNames = null;
        try {
            Config config = new Config(oracleHome, 1, userCredentials);
            listenerNames = Listener.enumListeners((Config)config, (String)instanceName);
            Trace.out("The first listener name is " + listenerNames[0] + " " + listenerNames.length);
        }
        catch (Exception e) {
            boolean bl = true;
        }
        int status = listenerNames != null ? 0 : 1;
        Trace.out("Returning from GetListener");
        return new GetListenerResult(status, listenerNames);
    }

    private static String[] buildEnvironment(String[] env, String oraHome) {
        NativeSystem nativeSystem;
        NativeResult result;
        String sysRootVal = System.getProperty("srvm.daemon.systemroot");
        Vector<String> envVector = new Vector<String>(0);
        Trace.out("buildEnvironment: oraclehome got is " + oraHome);
        if (env != null) {
            Trace.out("buildEnvironment: previous env size is " + env.length);
            for (int i = 0; i < env.length; ++i) {
                Trace.out("buildEnvironment: built " + env[i]);
                envVector.addElement(env[i]);
            }
        }
        String oldVal = (result = (nativeSystem = new SystemFactory().CreateSystem()).getEnvironment("LD_LIBRARY_PATH")).getStatus() ? result.getStringResult() : null;
        String newVal = oldVal != null ? "LD_LIBRARY_PATH=" + oraHome + FILE_SEPARATOR + "lib" + PATH_SEPARATOR + oldVal : "LD_LIBRARY_PATH=" + oraHome + FILE_SEPARATOR + "lib";
        envVector.addElement(newVal);
        Trace.out("buildEnvironment: built " + newVal);
        result = nativeSystem.getEnvironment("PATH");
        oldVal = result.getStatus() ? result.getStringResult() : null;
        newVal = oldVal != null ? "PATH=" + oraHome + FILE_SEPARATOR + "bin" + PATH_SEPARATOR + oldVal : "PATH=" + oraHome + FILE_SEPARATOR + "bin";
        Trace.out("buildEnvironment: built " + newVal);
        envVector.addElement(newVal);
        if (sysRootVal != null) {
            newVal = "SystemRoot=" + sysRootVal;
            Trace.out("buildEnvironment: built " + newVal);
            envVector.addElement(newVal);
        }
        Object[] newEnv = new String[envVector.size()];
        envVector.copyInto(newEnv);
        return newEnv;
    }

    static CreateOracleServiceResult createOracleService(CreateOracleServiceOperation op) {
        int status = 0;
        String oracleHome = op.getOracleHome();
        String sidName = op.getInstanceName();
        String pfileName = ParallelServerImpl.getPfile(oracleHome, sidName);
        String[] startCmd = new String[]{!new File(pfileName).exists() ? oracleHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "oradim -new -sid " + sidName.toUpperCase() + " -startmode m " + " -pfile " + pfileName : oracleHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "oradim -new -sid " + sidName.toUpperCase() + " -startmode m"};
        Trace.out("1.createOracleService cmd=" + startCmd[0]);
        String[] env = null;
        String[] input = null;
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runCommand(input, startCmd, env, output, error);
        if (ret == 0 && Version.isPre10i(op.getVersion())) {
            Trace.out("ParallelServerImpl:createOracleService succeeded");
            Trace.out("ParallelServerImpl:createOracleService output=" + output.toString());
            Trace.out("ParallelServerImpl:createOracleService error=" + error.toString());
            output.removeAllElements();
            error.removeAllElements();
            startCmd[0] = oracleHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "oradim -edit -sid " + sidName.toUpperCase() + " -startmode a ";
            Trace.out("2.createOracleService cmd=" + startCmd[0]);
            ret = ParallelServerImpl.runCommand(input, startCmd, env, output, error);
        }
        status = ret == 0 ? 0 : 1;
        Object[] newout = new String[output.size() + error.size()];
        int errlen = error.size();
        if (error.size() > 0) {
            error.copyInto(newout);
        }
        for (int j = 0; j < output.size(); ++j) {
            newout[errlen + j] = (String)output.elementAt(j);
        }
        CreateOracleServiceResult res = new CreateOracleServiceResult(status, (String[])newout);
        return res;
    }

    static DeleteOracleServiceResult deleteOracleService(DeleteOracleServiceOperation op) {
        int status = 0;
        String oracleHome = op.getOracleHome();
        String sidName = op.getInstanceName();
        String[] startCmd = new String[]{oracleHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "oradim -delete -sid " + sidName.toUpperCase()};
        String[] input = null;
        String[] env = null;
        Vector output = new Vector();
        Vector error = new Vector();
        int ret = ParallelServerImpl.runCommand(input, startCmd, env, output, error);
        status = ret == 0 ? 0 : 1;
        Object[] newout = new String[output.size() + error.size()];
        int errlen = error.size();
        if (error.size() > 0) {
            error.copyInto(newout);
        }
        for (int j = 0; j < output.size(); ++j) {
            newout[errlen + j] = (String)output.elementAt(j);
        }
        DeleteOracleServiceResult res = new DeleteOracleServiceResult(status, (String[])newout);
        return res;
    }
}

