/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nodeapps.config.NodeConfiguration;
import oracle.ops.mgmt.operation.GetNodeConfigurationResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;

public class GetNodeConfigurationOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -7298492198926649893L;
    private String m_nodeName;

    public GetNodeConfigurationOperation(String nodeName, Version v) {
        super(true, v);
        this.m_nodeName = nodeName;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public OperationResult run() {
        NodeConfiguration nodeConfig = null;
        GetNodeConfigurationResult result = null;
        try {
            Trace.out("in GetNodeConfigurationOperation.run()");
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            Trace.out("initialized raw device config");
            nodeConfig = rawdeviceConfig.getNodeConfiguration(this.m_nodeName);
            Trace.out("got configuration for node " + this.m_nodeName);
            result = new GetNodeConfigurationResult(0, nodeConfig);
        }
        catch (RawDeviceException e) {
            Trace.out(e);
            result = new GetNodeConfigurationResult(1, e.getMessage());
        }
        if (result == null) {
            Trace.out("result is null!");
        } else {
            Trace.out("result says " + result.getStatus());
        }
        return result;
    }
}

