/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.GetEnvResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;

public class GetEnvOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 5425551853606829172L;
    private String m_opsName;
    private String[] m_envName = null;
    private String m_entityName = null;
    private int m_resourceType;

    public GetEnvOperation(String opsName, Version version) {
        super(true, version);
        this.m_opsName = opsName;
    }

    public GetEnvOperation(String opsName, String[] envName, Version version) {
        super(true, version);
        this.m_opsName = opsName;
        this.m_envName = envName;
    }

    public GetEnvOperation(String opsName, String entityName, int resType, Version version) {
        this(opsName, null, version);
        this.m_entityName = entityName;
        this.m_resourceType = resType;
    }

    public GetEnvOperation(String opsName, String entityName, int resType, String[] envName, Version version) {
        this(opsName, envName, version);
        this.m_entityName = entityName;
        this.m_resourceType = resType;
    }

    @Override
    public OperationResult run() {
        GetEnvResult result = null;
        try {
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            String[] envValue = this.m_entityName != null ? rawdeviceConfig.getResEnv(this.m_opsName, this.m_entityName, this.m_resourceType, this.m_envName) : rawdeviceConfig.getEnv(this.m_opsName, this.m_envName);
            result = new GetEnvResult(0, envValue);
        }
        catch (RawDeviceException e) {
            result = new GetEnvResult(1, e);
        }
        return result;
    }
}

