/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.File;
import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.trace.Trace;

public class FileExistsTestOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 1888487687004200326L;
    private String m_nodeName;
    private String m_pathName;

    public FileExistsTestOperation(String nodeName, String pathName) {
        super(true);
        this.m_nodeName = nodeName;
        this.m_pathName = pathName;
    }

    public FileExistsTestOperation(String nodeName, String pathName, Version v) {
        super(v);
        this.m_nodeName = nodeName;
        this.m_pathName = pathName;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public String getPathName() {
        return this.m_pathName;
    }

    @Override
    public OperationResult run() {
        OperationResult result = null;
        try {
            boolean status = new File(this.m_pathName).exists();
            Trace.out("File " + this.m_pathName + " existence status is " + status);
            result = status ? new OperationResult(0) : new OperationResult(1);
        }
        catch (Exception e) {
            result.setException(e);
        }
        Trace.out("TestFileOperationResult is " + result.getStatus());
        return result;
    }
}

