/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.File;
import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.operation.CreateOracleServiceResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ParallelServerImpl;
import oracle.ops.mgmt.trace.Trace;

public class CreateOracleServiceOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = -1257418142324690880L;
    private String m_sidName;
    private String m_oracleHome;
    private String m_nodeName;

    public CreateOracleServiceOperation(String oracleHome, String sid) {
        this.m_sidName = sid;
        this.m_oracleHome = oracleHome;
    }

    public CreateOracleServiceOperation(String oracleHome, String sid, Version v) {
        super(v);
        this.m_sidName = sid;
        this.m_oracleHome = oracleHome;
    }

    public CreateOracleServiceOperation(String oracleHome, String sid, String node, Version v) {
        this(oracleHome, sid, v);
        this.m_nodeName = node;
    }

    public String getInstanceName() {
        return this.m_sidName;
    }

    public void setInstanceName(String inst) {
        this.m_sidName = inst;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setOracleHome(String oracleHome) {
        this.m_oracleHome = oracleHome;
    }

    @Override
    public OperationResult run() {
        CreateOracleServiceResult result;
        if (Version.isPre10i(this.m_myVersion)) {
            result = ParallelServerImpl.createOracleService(this);
        } else {
            int i;
            String runasCreds;
            String cmd = this.m_oracleHome + File.separator + "bin" + File.separator + "oradim.exe -new -host " + this.m_nodeName + " -ORACLE_HOME " + this.m_oracleHome + " -sid " + this.m_sidName.toUpperCase() + " -nopwdfile -startmode manual -srvcstart system";
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String pfile = nativeSystem.getPfileName(this.m_oracleHome, this.m_sidName);
            if (new File(pfile).exists()) {
                cmd = cmd + " -pfile " + pfile;
            }
            if ((runasCreds = System.getProperty("oracle.service.runas_creds")) != null) {
                cmd = cmd + " -runas " + runasCreds;
            }
            Trace.out("createOracleService cmd=" + cmd);
            RuntimeExec rt = new RuntimeExec(NativeSystem.getCmdArr(cmd), null, null);
            int exitStat = rt.runCommand();
            String[] output = rt.getOutput();
            String[] error = rt.getError();
            int status = exitStat == 0 ? 0 : 1;
            String[] newout = new String[output.length + error.length];
            for (i = 0; i < output.length; ++i) {
                newout[i] = output[i];
            }
            for (i = 0; i < error.length; ++i) {
                newout[output.length + i] = error[i];
            }
            result = new CreateOracleServiceResult(status, newout);
        }
        return result;
    }
}

