/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.operation.InstanceResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;

public class AddInstanceOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 3515041849600277846L;
    private String m_opsName;
    private String m_instName;
    private String m_nodeName;

    public AddInstanceOperation(String ops, String inst, String node, Version v) {
        super(true, v);
        this.m_opsName = ops;
        this.m_instName = inst;
        this.m_nodeName = node;
    }

    public String getOpsName() {
        return this.m_opsName;
    }

    public String getInstanceName() {
        return this.m_instName;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public OperationResult run() {
        InstanceResult result = null;
        try {
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            rawdeviceConfig.addInstance(this.m_opsName, this.m_instName, this.m_nodeName);
            result = new InstanceResult(0);
        }
        catch (RawDeviceException e) {
            result = new InstanceResult(1, e.getMessage());
        }
        return result;
    }
}

